# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCbhAvailabilityZonesResult',
    'AwaitableGetCbhAvailabilityZonesResult',
    'get_cbh_availability_zones',
    'get_cbh_availability_zones_output',
]

@pulumi.output_type
class GetCbhAvailabilityZonesResult:
    """
    A collection of values returned by getCbhAvailabilityZones.
    """
    def __init__(__self__, availability_zones=None, display_name=None, id=None, name=None, region=None):
        if availability_zones and not isinstance(availability_zones, list):
            raise TypeError("Expected argument 'availability_zones' to be a list")
        pulumi.set(__self__, "availability_zones", availability_zones)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence['outputs.GetCbhAvailabilityZonesAvailabilityZoneResult']:
        """
        All availability zones that match the filter parameters.  
        The availability_zones structure is documented below.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the availability zone.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the availability zone.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetCbhAvailabilityZonesResult(GetCbhAvailabilityZonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCbhAvailabilityZonesResult(
            availability_zones=self.availability_zones,
            display_name=self.display_name,
            id=self.id,
            name=self.name,
            region=self.region)


def get_cbh_availability_zones(display_name: Optional[_builtins.str] = None,
                               name: Optional[_builtins.str] = None,
                               region: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCbhAvailabilityZonesResult:
    """
    Use this data source to get the list of CBH availability zones within SberCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    availability_zone_name = config.require_object("availabilityZoneName")
    test = sbercloud.get_cbh_availability_zones(name=availability_zone_name)
    ```


    :param _builtins.str display_name: Specifies the display name of the availability zone to be queried.
    :param _builtins.str name: Specifies the name of the availability zone to be queried.
    :param _builtins.str region: Specifies the region in which to query the CBH availability zones.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getCbhAvailabilityZones:getCbhAvailabilityZones', __args__, opts=opts, typ=GetCbhAvailabilityZonesResult).value

    return AwaitableGetCbhAvailabilityZonesResult(
        availability_zones=pulumi.get(__ret__, 'availability_zones'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'))
def get_cbh_availability_zones_output(display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCbhAvailabilityZonesResult]:
    """
    Use this data source to get the list of CBH availability zones within SberCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    availability_zone_name = config.require_object("availabilityZoneName")
    test = sbercloud.get_cbh_availability_zones(name=availability_zone_name)
    ```


    :param _builtins.str display_name: Specifies the display name of the availability zone to be queried.
    :param _builtins.str name: Specifies the name of the availability zone to be queried.
    :param _builtins.str region: Specifies the region in which to query the CBH availability zones.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getCbhAvailabilityZones:getCbhAvailabilityZones', __args__, opts=opts, typ=GetCbhAvailabilityZonesResult)
    return __ret__.apply(lambda __response__: GetCbhAvailabilityZonesResult(
        availability_zones=pulumi.get(__response__, 'availability_zones'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region')))
