# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCbhFlavorsResult',
    'AwaitableGetCbhFlavorsResult',
    'get_cbh_flavors',
    'get_cbh_flavors_output',
]

@pulumi.output_type
class GetCbhFlavorsResult:
    """
    A collection of values returned by getCbhFlavors.
    """
    def __init__(__self__, action=None, asset=None, flavor_id=None, flavors=None, id=None, max_connection=None, memory=None, region=None, spec_code=None, type=None, vcpus=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if asset and not isinstance(asset, int):
            raise TypeError("Expected argument 'asset' to be a int")
        pulumi.set(__self__, "asset", asset)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_connection and not isinstance(max_connection, int):
            raise TypeError("Expected argument 'max_connection' to be a int")
        pulumi.set(__self__, "max_connection", max_connection)
        if memory and not isinstance(memory, int):
            raise TypeError("Expected argument 'memory' to be a int")
        pulumi.set(__self__, "memory", memory)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if spec_code and not isinstance(spec_code, str):
            raise TypeError("Expected argument 'spec_code' to be a str")
        pulumi.set(__self__, "spec_code", spec_code)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vcpus and not isinstance(vcpus, int):
            raise TypeError("Expected argument 'vcpus' to be a int")
        pulumi.set(__self__, "vcpus", vcpus)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def asset(self) -> Optional[_builtins.int]:
        """
        The number of CBH assets.
        """
        return pulumi.get(self, "asset")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetCbhFlavorsFlavorResult']:
        """
        Indicates the list of CBH specification.
        The flavor structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxConnection")
    def max_connection(self) -> Optional[_builtins.int]:
        """
        The maximum number of connections to the CBH.
        """
        return pulumi.get(self, "max_connection")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.int]:
        """
        The memory size of the CBH, in GB.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="specCode")
    def spec_code(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "spec_code")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of CBH specification. The value can be:
        + **basic**: Standard version.
        + **enhance**: Professional version.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def vcpus(self) -> Optional[_builtins.int]:
        """
        The number of CPU cores of the CBH.
        """
        return pulumi.get(self, "vcpus")


class AwaitableGetCbhFlavorsResult(GetCbhFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCbhFlavorsResult(
            action=self.action,
            asset=self.asset,
            flavor_id=self.flavor_id,
            flavors=self.flavors,
            id=self.id,
            max_connection=self.max_connection,
            memory=self.memory,
            region=self.region,
            spec_code=self.spec_code,
            type=self.type,
            vcpus=self.vcpus)


def get_cbh_flavors(action: Optional[_builtins.str] = None,
                    asset: Optional[_builtins.int] = None,
                    flavor_id: Optional[_builtins.str] = None,
                    max_connection: Optional[_builtins.int] = None,
                    memory: Optional[_builtins.int] = None,
                    region: Optional[_builtins.str] = None,
                    spec_code: Optional[_builtins.str] = None,
                    type: Optional[_builtins.str] = None,
                    vcpus: Optional[_builtins.int] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCbhFlavorsResult:
    """
    Use this data source to get the list of CBH specifications.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.get_cbh_flavors(type="basic")
    ```


    :param _builtins.str action: Specifies the action of querying instances specification information.
           The valid values are as follows:
           + **create**: Query instance specification information that can be created.
           + **update**: Query instance specification information that can be updated.
           
           If omitted, the CBH specifications that can be created will be queried.
    :param _builtins.int asset: Specifies the number of CBH assets.
    :param _builtins.str flavor_id: Specifies the ID of the specification of CBH.
           At present, CBH provides two functional versions: standard version and professional version.
           The standard version is equipped with asset specifications of 10(for example the `flavor_id` is: **cbh.basic.10**),
           20, 50, 100, 200, 500, 1000, 2000, 5000, and 10000.
           The professional version is equipped with 10(for example the `flavor_id` is: **cbh.enhance.10**),
           20, 50, 100, 200, 500, 1000, 2000, 5000, 10000 asset specifications.
           The specification 'enhance' is more advanced than the specification 'basic'.
    :param _builtins.int max_connection: Specifies the maximum number of connections to the CBH.
    :param _builtins.int memory: Specifies the memory size of the CBH, in GB.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param _builtins.str spec_code: Specifies the ID of the CBH specification, the query result shows all specifications
           that can be changed by this specification. This parameter is required when `action` is set to **update**.
    :param _builtins.str type: Specifies the type of CBH specification. The value can be:
           + **basic**: Standard version.
           + **enhance**: Professional version.
    :param _builtins.int vcpus: Specifies the number of CPU cores of the CBH.
    """
    __args__ = dict()
    __args__['action'] = action
    __args__['asset'] = asset
    __args__['flavorId'] = flavor_id
    __args__['maxConnection'] = max_connection
    __args__['memory'] = memory
    __args__['region'] = region
    __args__['specCode'] = spec_code
    __args__['type'] = type
    __args__['vcpus'] = vcpus
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getCbhFlavors:getCbhFlavors', __args__, opts=opts, typ=GetCbhFlavorsResult).value

    return AwaitableGetCbhFlavorsResult(
        action=pulumi.get(__ret__, 'action'),
        asset=pulumi.get(__ret__, 'asset'),
        flavor_id=pulumi.get(__ret__, 'flavor_id'),
        flavors=pulumi.get(__ret__, 'flavors'),
        id=pulumi.get(__ret__, 'id'),
        max_connection=pulumi.get(__ret__, 'max_connection'),
        memory=pulumi.get(__ret__, 'memory'),
        region=pulumi.get(__ret__, 'region'),
        spec_code=pulumi.get(__ret__, 'spec_code'),
        type=pulumi.get(__ret__, 'type'),
        vcpus=pulumi.get(__ret__, 'vcpus'))
def get_cbh_flavors_output(action: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           asset: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                           flavor_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           max_connection: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                           memory: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           spec_code: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           vcpus: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCbhFlavorsResult]:
    """
    Use this data source to get the list of CBH specifications.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.get_cbh_flavors(type="basic")
    ```


    :param _builtins.str action: Specifies the action of querying instances specification information.
           The valid values are as follows:
           + **create**: Query instance specification information that can be created.
           + **update**: Query instance specification information that can be updated.
           
           If omitted, the CBH specifications that can be created will be queried.
    :param _builtins.int asset: Specifies the number of CBH assets.
    :param _builtins.str flavor_id: Specifies the ID of the specification of CBH.
           At present, CBH provides two functional versions: standard version and professional version.
           The standard version is equipped with asset specifications of 10(for example the `flavor_id` is: **cbh.basic.10**),
           20, 50, 100, 200, 500, 1000, 2000, 5000, and 10000.
           The professional version is equipped with 10(for example the `flavor_id` is: **cbh.enhance.10**),
           20, 50, 100, 200, 500, 1000, 2000, 5000, 10000 asset specifications.
           The specification 'enhance' is more advanced than the specification 'basic'.
    :param _builtins.int max_connection: Specifies the maximum number of connections to the CBH.
    :param _builtins.int memory: Specifies the memory size of the CBH, in GB.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param _builtins.str spec_code: Specifies the ID of the CBH specification, the query result shows all specifications
           that can be changed by this specification. This parameter is required when `action` is set to **update**.
    :param _builtins.str type: Specifies the type of CBH specification. The value can be:
           + **basic**: Standard version.
           + **enhance**: Professional version.
    :param _builtins.int vcpus: Specifies the number of CPU cores of the CBH.
    """
    __args__ = dict()
    __args__['action'] = action
    __args__['asset'] = asset
    __args__['flavorId'] = flavor_id
    __args__['maxConnection'] = max_connection
    __args__['memory'] = memory
    __args__['region'] = region
    __args__['specCode'] = spec_code
    __args__['type'] = type
    __args__['vcpus'] = vcpus
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getCbhFlavors:getCbhFlavors', __args__, opts=opts, typ=GetCbhFlavorsResult)
    return __ret__.apply(lambda __response__: GetCbhFlavorsResult(
        action=pulumi.get(__response__, 'action'),
        asset=pulumi.get(__response__, 'asset'),
        flavor_id=pulumi.get(__response__, 'flavor_id'),
        flavors=pulumi.get(__response__, 'flavors'),
        id=pulumi.get(__response__, 'id'),
        max_connection=pulumi.get(__response__, 'max_connection'),
        memory=pulumi.get(__response__, 'memory'),
        region=pulumi.get(__response__, 'region'),
        spec_code=pulumi.get(__response__, 'spec_code'),
        type=pulumi.get(__response__, 'type'),
        vcpus=pulumi.get(__response__, 'vcpus')))
