# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCbhInstancesResult',
    'AwaitableGetCbhInstancesResult',
    'get_cbh_instances',
    'get_cbh_instances_output',
]

@pulumi.output_type
class GetCbhInstancesResult:
    """
    A collection of values returned by getCbhInstances.
    """
    def __init__(__self__, flavor_id=None, id=None, instances=None, name=None, region=None, security_group_id=None, subnet_id=None, version=None, vpc_id=None):
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[_builtins.str]:
        """
        Indicates the specification of the instance.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetCbhInstancesInstanceResult']:
        """
        Indicates the list of CBH instance.
        The instances structure is documented below.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Indicates the instance name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[_builtins.str]:
        """
        Indicates the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        Indicates the ID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Indicates the current version of the instance image.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        Indicates the ID of a VPC.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetCbhInstancesResult(GetCbhInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCbhInstancesResult(
            flavor_id=self.flavor_id,
            id=self.id,
            instances=self.instances,
            name=self.name,
            region=self.region,
            security_group_id=self.security_group_id,
            subnet_id=self.subnet_id,
            version=self.version,
            vpc_id=self.vpc_id)


def get_cbh_instances(flavor_id: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      security_group_id: Optional[_builtins.str] = None,
                      subnet_id: Optional[_builtins.str] = None,
                      version: Optional[_builtins.str] = None,
                      vpc_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCbhInstancesResult:
    """
    Use this data source to get the list of CBH instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    vpc_id = config.require_object("vpcId")
    subnet_id = config.require_object("subnetId")
    security_group_id = config.require_object("securityGroupId")
    test = sbercloud.get_cbh_instances(name="test_name",
        vpc_id=vpc_id,
        subnet_id=subnet_id,
        security_group_id=security_group_id)
    ```


    :param _builtins.str flavor_id: Specifies the specification of the instance.
    :param _builtins.str name: Specifies the instance name.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param _builtins.str security_group_id: Specifies the ID of a security group.
    :param _builtins.str subnet_id: Specifies the ID of a subnet.
    :param _builtins.str version: Specifies the current version of the instance image.
    :param _builtins.str vpc_id: Specifies the ID of a VPC.
    """
    __args__ = dict()
    __args__['flavorId'] = flavor_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['securityGroupId'] = security_group_id
    __args__['subnetId'] = subnet_id
    __args__['version'] = version
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getCbhInstances:getCbhInstances', __args__, opts=opts, typ=GetCbhInstancesResult).value

    return AwaitableGetCbhInstancesResult(
        flavor_id=pulumi.get(__ret__, 'flavor_id'),
        id=pulumi.get(__ret__, 'id'),
        instances=pulumi.get(__ret__, 'instances'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        security_group_id=pulumi.get(__ret__, 'security_group_id'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        version=pulumi.get(__ret__, 'version'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_cbh_instances_output(flavor_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             security_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             subnet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCbhInstancesResult]:
    """
    Use this data source to get the list of CBH instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    vpc_id = config.require_object("vpcId")
    subnet_id = config.require_object("subnetId")
    security_group_id = config.require_object("securityGroupId")
    test = sbercloud.get_cbh_instances(name="test_name",
        vpc_id=vpc_id,
        subnet_id=subnet_id,
        security_group_id=security_group_id)
    ```


    :param _builtins.str flavor_id: Specifies the specification of the instance.
    :param _builtins.str name: Specifies the instance name.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param _builtins.str security_group_id: Specifies the ID of a security group.
    :param _builtins.str subnet_id: Specifies the ID of a subnet.
    :param _builtins.str version: Specifies the current version of the instance image.
    :param _builtins.str vpc_id: Specifies the ID of a VPC.
    """
    __args__ = dict()
    __args__['flavorId'] = flavor_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['securityGroupId'] = security_group_id
    __args__['subnetId'] = subnet_id
    __args__['version'] = version
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getCbhInstances:getCbhInstances', __args__, opts=opts, typ=GetCbhInstancesResult)
    return __ret__.apply(lambda __response__: GetCbhInstancesResult(
        flavor_id=pulumi.get(__response__, 'flavor_id'),
        id=pulumi.get(__response__, 'id'),
        instances=pulumi.get(__response__, 'instances'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        security_group_id=pulumi.get(__response__, 'security_group_id'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        version=pulumi.get(__response__, 'version'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
