# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCbrBackupResult',
    'AwaitableGetCbrBackupResult',
    'get_cbr_backup',
    'get_cbr_backup_output',
]

@pulumi.output_type
class GetCbrBackupResult:
    """
    A collection of values returned by getCbrBackup.
    """
    def __init__(__self__, checkpoint_id=None, childrens=None, created_at=None, description=None, enterprise_project_id=None, expired_at=None, extend_infos=None, id=None, name=None, parent_id=None, region=None, replication_records=None, resource_az=None, resource_id=None, resource_name=None, resource_size=None, resource_type=None, status=None, type=None, updated_at=None, vault_id=None):
        if checkpoint_id and not isinstance(checkpoint_id, str):
            raise TypeError("Expected argument 'checkpoint_id' to be a str")
        pulumi.set(__self__, "checkpoint_id", checkpoint_id)
        if childrens and not isinstance(childrens, list):
            raise TypeError("Expected argument 'childrens' to be a list")
        pulumi.set(__self__, "childrens", childrens)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if expired_at and not isinstance(expired_at, str):
            raise TypeError("Expected argument 'expired_at' to be a str")
        pulumi.set(__self__, "expired_at", expired_at)
        if extend_infos and not isinstance(extend_infos, list):
            raise TypeError("Expected argument 'extend_infos' to be a list")
        pulumi.set(__self__, "extend_infos", extend_infos)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if replication_records and not isinstance(replication_records, list):
            raise TypeError("Expected argument 'replication_records' to be a list")
        pulumi.set(__self__, "replication_records", replication_records)
        if resource_az and not isinstance(resource_az, str):
            raise TypeError("Expected argument 'resource_az' to be a str")
        pulumi.set(__self__, "resource_az", resource_az)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_name and not isinstance(resource_name, str):
            raise TypeError("Expected argument 'resource_name' to be a str")
        pulumi.set(__self__, "resource_name", resource_name)
        if resource_size and not isinstance(resource_size, int):
            raise TypeError("Expected argument 'resource_size' to be a int")
        pulumi.set(__self__, "resource_size", resource_size)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="checkpointId")
    def checkpoint_id(self) -> _builtins.str:
        """
        The restore point ID of the sub-backup resource.
        """
        return pulumi.get(self, "checkpoint_id")

    @_builtins.property
    @pulumi.getter
    def childrens(self) -> Sequence['outputs.GetCbrBackupChildrenResult']:
        """
        The backup list of the sub-backup resources.
        The object structure is documented below.
        """
        return pulumi.get(self, "childrens")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation time of the sub-backup.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The sub-backup description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        """
        The enterprise project to which the backup sub-backup resource belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="expiredAt")
    def expired_at(self) -> _builtins.str:
        """
        The expiration time of the sub-backup.
        """
        return pulumi.get(self, "expired_at")

    @_builtins.property
    @pulumi.getter(name="extendInfos")
    def extend_infos(self) -> Sequence['outputs.GetCbrBackupExtendInfoResult']:
        """
        The extended information.
        """
        return pulumi.get(self, "extend_infos")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The sub-backup ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The sub-backup name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> _builtins.str:
        """
        The parent backup ID.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicationRecords")
    def replication_records(self) -> Sequence['outputs.GetCbrBackupReplicationRecordResult']:
        """
        The replication records.
        """
        return pulumi.get(self, "replication_records")

    @_builtins.property
    @pulumi.getter(name="resourceAz")
    def resource_az(self) -> _builtins.str:
        """
        The availability zone where the backup sub-backup resource is located.
        """
        return pulumi.get(self, "resource_az")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The sub-backup resource ID.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> _builtins.str:
        """
        The sub-backup resource name.
        """
        return pulumi.get(self, "resource_name")

    @_builtins.property
    @pulumi.getter(name="resourceSize")
    def resource_size(self) -> _builtins.int:
        """
        The sub-backup resource size, in GB.
        """
        return pulumi.get(self, "resource_size")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The sub-backup resource type.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The sub-backup status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The sub-backup type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The latest update time of the sub-backup.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The vault to which the backup resource belongs.
        """
        return pulumi.get(self, "vault_id")


class AwaitableGetCbrBackupResult(GetCbrBackupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCbrBackupResult(
            checkpoint_id=self.checkpoint_id,
            childrens=self.childrens,
            created_at=self.created_at,
            description=self.description,
            enterprise_project_id=self.enterprise_project_id,
            expired_at=self.expired_at,
            extend_infos=self.extend_infos,
            id=self.id,
            name=self.name,
            parent_id=self.parent_id,
            region=self.region,
            replication_records=self.replication_records,
            resource_az=self.resource_az,
            resource_id=self.resource_id,
            resource_name=self.resource_name,
            resource_size=self.resource_size,
            resource_type=self.resource_type,
            status=self.status,
            type=self.type,
            updated_at=self.updated_at,
            vault_id=self.vault_id)


def get_cbr_backup(id: Optional[_builtins.str] = None,
                   region: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCbrBackupResult:
    """
    Use this data source to query the backup detail using its ID within Sbercloud.

    ## Example Usage

    ### Using backup ID to query the backup detail

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    backup_id = config.require_object("backupId")
    test = sbercloud.get_cbr_backup(id="backup_id")
    ```


    :param _builtins.str id: Specifies the backup ID.
    :param _builtins.str region: Specifies the region in which to query the backup detail.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getCbrBackup:getCbrBackup', __args__, opts=opts, typ=GetCbrBackupResult).value

    return AwaitableGetCbrBackupResult(
        checkpoint_id=pulumi.get(__ret__, 'checkpoint_id'),
        childrens=pulumi.get(__ret__, 'childrens'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        expired_at=pulumi.get(__ret__, 'expired_at'),
        extend_infos=pulumi.get(__ret__, 'extend_infos'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        region=pulumi.get(__ret__, 'region'),
        replication_records=pulumi.get(__ret__, 'replication_records'),
        resource_az=pulumi.get(__ret__, 'resource_az'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        resource_name=pulumi.get(__ret__, 'resource_name'),
        resource_size=pulumi.get(__ret__, 'resource_size'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        vault_id=pulumi.get(__ret__, 'vault_id'))
def get_cbr_backup_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                          region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCbrBackupResult]:
    """
    Use this data source to query the backup detail using its ID within Sbercloud.

    ## Example Usage

    ### Using backup ID to query the backup detail

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    backup_id = config.require_object("backupId")
    test = sbercloud.get_cbr_backup(id="backup_id")
    ```


    :param _builtins.str id: Specifies the backup ID.
    :param _builtins.str region: Specifies the region in which to query the backup detail.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getCbrBackup:getCbrBackup', __args__, opts=opts, typ=GetCbrBackupResult)
    return __ret__.apply(lambda __response__: GetCbrBackupResult(
        checkpoint_id=pulumi.get(__response__, 'checkpoint_id'),
        childrens=pulumi.get(__response__, 'childrens'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        expired_at=pulumi.get(__response__, 'expired_at'),
        extend_infos=pulumi.get(__response__, 'extend_infos'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        region=pulumi.get(__response__, 'region'),
        replication_records=pulumi.get(__response__, 'replication_records'),
        resource_az=pulumi.get(__response__, 'resource_az'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        resource_name=pulumi.get(__response__, 'resource_name'),
        resource_size=pulumi.get(__response__, 'resource_size'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        vault_id=pulumi.get(__response__, 'vault_id')))
