# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCbrPoliciesResult',
    'AwaitableGetCbrPoliciesResult',
    'get_cbr_policies',
    'get_cbr_policies_output',
]

@pulumi.output_type
class GetCbrPoliciesResult:
    """
    A collection of values returned by getCbrPolicies.
    """
    def __init__(__self__, enabled=None, id=None, name=None, policies=None, policy_id=None, region=None, type=None, vault_id=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable the policy. The valid values are as follows:
        + **true**: Policy enabled
        + **false**: Policy not enabled
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The policy name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetCbrPoliciesPolicyResult']:
        """
        All CBR policies that match the filter parameters.
        The policies structure is documented below.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The protection type of the policy. The valid values are as follows:
        + **backup**: Backup policy
        + **replication**: Replication policy
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[_builtins.str]:
        """
        The vault ID of the associated CBR policy.
        """
        return pulumi.get(self, "vault_id")


class AwaitableGetCbrPoliciesResult(GetCbrPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCbrPoliciesResult(
            enabled=self.enabled,
            id=self.id,
            name=self.name,
            policies=self.policies,
            policy_id=self.policy_id,
            region=self.region,
            type=self.type,
            vault_id=self.vault_id)


def get_cbr_policies(enabled: Optional[_builtins.bool] = None,
                     name: Optional[_builtins.str] = None,
                     policy_id: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     type: Optional[_builtins.str] = None,
                     vault_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCbrPoliciesResult:
    """
    Use this data source to get available CBR policies within Sbercloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    policy_name = config.require_object("policyName")
    test = sbercloud.get_cbr_policies(name=policy_name)
    ```


    :param _builtins.bool enabled: Specifies the policy enabling status to query. The valid values are as follows:
           + **true**: Policy enabled
           + **false**: Policy not enabled
    :param _builtins.str name: Specifies the policy name used to query.
    :param _builtins.str policy_id: Specifies the policy ID used to query.
    :param _builtins.str region: Specifies the region in which to query the policies.
           If omitted, the provider-level region will be used.
    :param _builtins.str type: Specifies the policy type used to query. The valid values are as follows:
           + **backup**: Backup policy
           + **replication**: Replication policy
    :param _builtins.str vault_id: Specifies the vault ID of the associated policy used to query.
    """
    __args__ = dict()
    __args__['enabled'] = enabled
    __args__['name'] = name
    __args__['policyId'] = policy_id
    __args__['region'] = region
    __args__['type'] = type
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getCbrPolicies:getCbrPolicies', __args__, opts=opts, typ=GetCbrPoliciesResult).value

    return AwaitableGetCbrPoliciesResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        policies=pulumi.get(__ret__, 'policies'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        region=pulumi.get(__ret__, 'region'),
        type=pulumi.get(__ret__, 'type'),
        vault_id=pulumi.get(__ret__, 'vault_id'))
def get_cbr_policies_output(enabled: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                            name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            policy_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            vault_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCbrPoliciesResult]:
    """
    Use this data source to get available CBR policies within Sbercloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    policy_name = config.require_object("policyName")
    test = sbercloud.get_cbr_policies(name=policy_name)
    ```


    :param _builtins.bool enabled: Specifies the policy enabling status to query. The valid values are as follows:
           + **true**: Policy enabled
           + **false**: Policy not enabled
    :param _builtins.str name: Specifies the policy name used to query.
    :param _builtins.str policy_id: Specifies the policy ID used to query.
    :param _builtins.str region: Specifies the region in which to query the policies.
           If omitted, the provider-level region will be used.
    :param _builtins.str type: Specifies the policy type used to query. The valid values are as follows:
           + **backup**: Backup policy
           + **replication**: Replication policy
    :param _builtins.str vault_id: Specifies the vault ID of the associated policy used to query.
    """
    __args__ = dict()
    __args__['enabled'] = enabled
    __args__['name'] = name
    __args__['policyId'] = policy_id
    __args__['region'] = region
    __args__['type'] = type
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getCbrPolicies:getCbrPolicies', __args__, opts=opts, typ=GetCbrPoliciesResult)
    return __ret__.apply(lambda __response__: GetCbrPoliciesResult(
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        policies=pulumi.get(__response__, 'policies'),
        policy_id=pulumi.get(__response__, 'policy_id'),
        region=pulumi.get(__response__, 'region'),
        type=pulumi.get(__response__, 'type'),
        vault_id=pulumi.get(__response__, 'vault_id')))
