# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCdmFlavorsResult',
    'AwaitableGetCdmFlavorsResult',
    'get_cdm_flavors',
    'get_cdm_flavors_output',
]

@pulumi.output_type
class GetCdmFlavorsResult:
    """
    A collection of values returned by getCdmFlavors.
    """
    def __init__(__self__, flavors=None, id=None, region=None, version=None):
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetCdmFlavorsFlavorResult']:
        """
        Indicates the flavors information. Structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region in which to obtain the CDM flavors. If omitted, the provider-level region will be used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the flavor.
        """
        return pulumi.get(self, "version")


class AwaitableGetCdmFlavorsResult(GetCdmFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCdmFlavorsResult(
            flavors=self.flavors,
            id=self.id,
            region=self.region,
            version=self.version)


def get_cdm_flavors(region: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCdmFlavorsResult:
    """
    Use this data source to get available SberCloud cdm flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    flavor = sbercloud.get_cdm_flavors()
    ```


    :param _builtins.str region: The region in which to obtain the CDM flavors. If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getCdmFlavors:getCdmFlavors', __args__, opts=opts, typ=GetCdmFlavorsResult).value

    return AwaitableGetCdmFlavorsResult(
        flavors=pulumi.get(__ret__, 'flavors'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        version=pulumi.get(__ret__, 'version'))
def get_cdm_flavors_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCdmFlavorsResult]:
    """
    Use this data source to get available SberCloud cdm flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    flavor = sbercloud.get_cdm_flavors()
    ```


    :param _builtins.str region: The region in which to obtain the CDM flavors. If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getCdmFlavors:getCdmFlavors', __args__, opts=opts, typ=GetCdmFlavorsResult)
    return __ret__.apply(lambda __response__: GetCdmFlavorsResult(
        flavors=pulumi.get(__response__, 'flavors'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        version=pulumi.get(__response__, 'version')))
