# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDcsProductResult',
    'AwaitableGetDcsProductResult',
    'get_dcs_product',
    'get_dcs_product_output',
]

@pulumi.output_type
class GetDcsProductResult:
    """
    A collection of values returned by getDcsProduct.
    """
    def __init__(__self__, cache_mode=None, capacity=None, engine=None, engine_version=None, id=None, region=None, spec_code=None):
        if cache_mode and not isinstance(cache_mode, str):
            raise TypeError("Expected argument 'cache_mode' to be a str")
        pulumi.set(__self__, "cache_mode", cache_mode)
        if capacity and not isinstance(capacity, str):
            raise TypeError("Expected argument 'capacity' to be a str")
        pulumi.set(__self__, "capacity", capacity)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if spec_code and not isinstance(spec_code, str):
            raise TypeError("Expected argument 'spec_code' to be a str")
        pulumi.set(__self__, "spec_code", spec_code)

    @_builtins.property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> _builtins.str:
        """
        The mode of a cache engine. The value is one of *single*, *ha*, *cluster*,
        *proxy* and *ha_rw_split*.
        """
        return pulumi.get(self, "cache_mode")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> _builtins.str:
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        The cache engine. The value is *redis* or *memcached*.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        """
        The supported versions of a cache engine.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="specCode")
    def spec_code(self) -> _builtins.str:
        return pulumi.get(self, "spec_code")


class AwaitableGetDcsProductResult(GetDcsProductResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDcsProductResult(
            cache_mode=self.cache_mode,
            capacity=self.capacity,
            engine=self.engine,
            engine_version=self.engine_version,
            id=self.id,
            region=self.region,
            spec_code=self.spec_code)


def get_dcs_product(region: Optional[_builtins.str] = None,
                    spec_code: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDcsProductResult:
    """
    Use this data source to get the ID of an available DCS product.

    !> **WARNING:** It has been deprecated. This data source is used for the `product_id` of the
    `Dcs.Instance` resource. Now `product_id` has been deprecated and this data source is no longer used.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    product1 = sbercloud.get_dcs_product(spec_code="dcs.single_node")
    ```


    :param _builtins.str region: Specifies the region in which to obtain the dcs products.
           If omitted, the provider-level region will be used.
    :param _builtins.str spec_code: Specifies the DCS instance specification code. For details, see
           [Querying Service Specifications](https://support.hc.sbercloud.ru/api/dcs/dcs-api-0312040.html).
           + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['specCode'] = spec_code
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getDcsProduct:getDcsProduct', __args__, opts=opts, typ=GetDcsProductResult).value

    return AwaitableGetDcsProductResult(
        cache_mode=pulumi.get(__ret__, 'cache_mode'),
        capacity=pulumi.get(__ret__, 'capacity'),
        engine=pulumi.get(__ret__, 'engine'),
        engine_version=pulumi.get(__ret__, 'engine_version'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        spec_code=pulumi.get(__ret__, 'spec_code'))
def get_dcs_product_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           spec_code: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDcsProductResult]:
    """
    Use this data source to get the ID of an available DCS product.

    !> **WARNING:** It has been deprecated. This data source is used for the `product_id` of the
    `Dcs.Instance` resource. Now `product_id` has been deprecated and this data source is no longer used.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    product1 = sbercloud.get_dcs_product(spec_code="dcs.single_node")
    ```


    :param _builtins.str region: Specifies the region in which to obtain the dcs products.
           If omitted, the provider-level region will be used.
    :param _builtins.str spec_code: Specifies the DCS instance specification code. For details, see
           [Querying Service Specifications](https://support.hc.sbercloud.ru/api/dcs/dcs-api-0312040.html).
           + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['specCode'] = spec_code
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getDcsProduct:getDcsProduct', __args__, opts=opts, typ=GetDcsProductResult)
    return __ret__.apply(lambda __response__: GetDcsProductResult(
        cache_mode=pulumi.get(__response__, 'cache_mode'),
        capacity=pulumi.get(__response__, 'capacity'),
        engine=pulumi.get(__response__, 'engine'),
        engine_version=pulumi.get(__response__, 'engine_version'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        spec_code=pulumi.get(__response__, 'spec_code')))
