# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDmsKafkaConsumerGroupsResult',
    'AwaitableGetDmsKafkaConsumerGroupsResult',
    'get_dms_kafka_consumer_groups',
    'get_dms_kafka_consumer_groups_output',
]

@pulumi.output_type
class GetDmsKafkaConsumerGroupsResult:
    """
    A collection of values returned by getDmsKafkaConsumerGroups.
    """
    def __init__(__self__, coordinator_id=None, description=None, groups=None, id=None, instance_id=None, lag=None, name=None, region=None, state=None):
        if coordinator_id and not isinstance(coordinator_id, int):
            raise TypeError("Expected argument 'coordinator_id' to be a int")
        pulumi.set(__self__, "coordinator_id", coordinator_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if lag and not isinstance(lag, int):
            raise TypeError("Expected argument 'lag' to be a int")
        pulumi.set(__self__, "lag", lag)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="coordinatorId")
    def coordinator_id(self) -> Optional[_builtins.int]:
        """
        Indicates the coordinator ID.
        """
        return pulumi.get(self, "coordinator_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Indicates the consumer group description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetDmsKafkaConsumerGroupsGroupResult']:
        """
        Indicates the groups list.
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def lag(self) -> Optional[_builtins.int]:
        """
        Indicates the number of accumulated messages.
        """
        return pulumi.get(self, "lag")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Indicates the consumer group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        Indicates the consumer group status.
        """
        return pulumi.get(self, "state")


class AwaitableGetDmsKafkaConsumerGroupsResult(GetDmsKafkaConsumerGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDmsKafkaConsumerGroupsResult(
            coordinator_id=self.coordinator_id,
            description=self.description,
            groups=self.groups,
            id=self.id,
            instance_id=self.instance_id,
            lag=self.lag,
            name=self.name,
            region=self.region,
            state=self.state)


def get_dms_kafka_consumer_groups(coordinator_id: Optional[_builtins.int] = None,
                                  description: Optional[_builtins.str] = None,
                                  instance_id: Optional[_builtins.str] = None,
                                  lag: Optional[_builtins.int] = None,
                                  name: Optional[_builtins.str] = None,
                                  region: Optional[_builtins.str] = None,
                                  state: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDmsKafkaConsumerGroupsResult:
    """
    Use this data source to get the list of Kafka instance consumer groups.

    ## Example Usage

    ### Get all groups for an instance

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.get_dms_kafka_consumer_groups(instance_id=instance_id)
    ```

    ### Get specific group for an instance

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.get_dms_kafka_consumer_groups(instance_id=instance_id,
        name="test_group")
    ```


    :param _builtins.int coordinator_id: Specifies the coordinator ID.
    :param _builtins.str description: Specifies the group description.
    :param _builtins.str instance_id: Specifies the instance ID.
    :param _builtins.int lag: Specifies the number of accumulated messages.
    :param _builtins.str name: Specifies the group name.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str state: Specifies the consumer group status.
    """
    __args__ = dict()
    __args__['coordinatorId'] = coordinator_id
    __args__['description'] = description
    __args__['instanceId'] = instance_id
    __args__['lag'] = lag
    __args__['name'] = name
    __args__['region'] = region
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getDmsKafkaConsumerGroups:getDmsKafkaConsumerGroups', __args__, opts=opts, typ=GetDmsKafkaConsumerGroupsResult).value

    return AwaitableGetDmsKafkaConsumerGroupsResult(
        coordinator_id=pulumi.get(__ret__, 'coordinator_id'),
        description=pulumi.get(__ret__, 'description'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        lag=pulumi.get(__ret__, 'lag'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        state=pulumi.get(__ret__, 'state'))
def get_dms_kafka_consumer_groups_output(coordinator_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                         description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         lag: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDmsKafkaConsumerGroupsResult]:
    """
    Use this data source to get the list of Kafka instance consumer groups.

    ## Example Usage

    ### Get all groups for an instance

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.get_dms_kafka_consumer_groups(instance_id=instance_id)
    ```

    ### Get specific group for an instance

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.get_dms_kafka_consumer_groups(instance_id=instance_id,
        name="test_group")
    ```


    :param _builtins.int coordinator_id: Specifies the coordinator ID.
    :param _builtins.str description: Specifies the group description.
    :param _builtins.str instance_id: Specifies the instance ID.
    :param _builtins.int lag: Specifies the number of accumulated messages.
    :param _builtins.str name: Specifies the group name.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str state: Specifies the consumer group status.
    """
    __args__ = dict()
    __args__['coordinatorId'] = coordinator_id
    __args__['description'] = description
    __args__['instanceId'] = instance_id
    __args__['lag'] = lag
    __args__['name'] = name
    __args__['region'] = region
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getDmsKafkaConsumerGroups:getDmsKafkaConsumerGroups', __args__, opts=opts, typ=GetDmsKafkaConsumerGroupsResult)
    return __ret__.apply(lambda __response__: GetDmsKafkaConsumerGroupsResult(
        coordinator_id=pulumi.get(__response__, 'coordinator_id'),
        description=pulumi.get(__response__, 'description'),
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        lag=pulumi.get(__response__, 'lag'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        state=pulumi.get(__response__, 'state')))
