# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDmsKafkaMessagesResult',
    'AwaitableGetDmsKafkaMessagesResult',
    'get_dms_kafka_messages',
    'get_dms_kafka_messages_output',
]

@pulumi.output_type
class GetDmsKafkaMessagesResult:
    """
    A collection of values returned by getDmsKafkaMessages.
    """
    def __init__(__self__, download=None, end_time=None, id=None, instance_id=None, keyword=None, message_offset=None, messages=None, partition=None, region=None, start_time=None, topic=None):
        if download and not isinstance(download, bool):
            raise TypeError("Expected argument 'download' to be a bool")
        pulumi.set(__self__, "download", download)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if keyword and not isinstance(keyword, str):
            raise TypeError("Expected argument 'keyword' to be a str")
        pulumi.set(__self__, "keyword", keyword)
        if message_offset and not isinstance(message_offset, str):
            raise TypeError("Expected argument 'message_offset' to be a str")
        pulumi.set(__self__, "message_offset", message_offset)
        if messages and not isinstance(messages, list):
            raise TypeError("Expected argument 'messages' to be a list")
        pulumi.set(__self__, "messages", messages)
        if partition and not isinstance(partition, str):
            raise TypeError("Expected argument 'partition' to be a str")
        pulumi.set(__self__, "partition", partition)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)
        if topic and not isinstance(topic, str):
            raise TypeError("Expected argument 'topic' to be a str")
        pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter
    def download(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "download")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def keyword(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "keyword")

    @_builtins.property
    @pulumi.getter(name="messageOffset")
    def message_offset(self) -> Optional[_builtins.str]:
        """
        Indicates the message offset.
        """
        return pulumi.get(self, "message_offset")

    @_builtins.property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.GetDmsKafkaMessagesMessageResult']:
        """
        Indicates the message list.
        """
        return pulumi.get(self, "messages")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[_builtins.str]:
        """
        Indicates the partition where the message is located.
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        return pulumi.get(self, "topic")


class AwaitableGetDmsKafkaMessagesResult(GetDmsKafkaMessagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDmsKafkaMessagesResult(
            download=self.download,
            end_time=self.end_time,
            id=self.id,
            instance_id=self.instance_id,
            keyword=self.keyword,
            message_offset=self.message_offset,
            messages=self.messages,
            partition=self.partition,
            region=self.region,
            start_time=self.start_time,
            topic=self.topic)


def get_dms_kafka_messages(download: Optional[_builtins.bool] = None,
                           end_time: Optional[_builtins.str] = None,
                           instance_id: Optional[_builtins.str] = None,
                           keyword: Optional[_builtins.str] = None,
                           message_offset: Optional[_builtins.str] = None,
                           partition: Optional[_builtins.str] = None,
                           region: Optional[_builtins.str] = None,
                           start_time: Optional[_builtins.str] = None,
                           topic: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDmsKafkaMessagesResult:
    """
    Use this data source to get the list of Kafka messages.

    ## Example Usage

    ### Query messages by creation time

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    topic = config.require_object("topic")
    start_time = config.require_object("startTime")
    end_time = config.require_object("endTime")
    test = sbercloud.get_dms_kafka_messages(instance_id=instance_id,
        topic=topic,
        start_time=start_time,
        end_time=end_time)
    ```

    ### Query messages by content's keyword, a maximum of 10 messages can be returned

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    topic = config.require_object("topic")
    start_time = config.require_object("startTime")
    end_time = config.require_object("endTime")
    keyword = config.require_object("keyword")
    test = sbercloud.get_dms_kafka_messages(instance_id=instance_id,
        topic=topic,
        start_time=start_time,
        end_time=end_time,
        keyword=keyword)
    ```

    ### Query messages content by offset

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    topic = config.require_object("topic")
    partition = config.require_object("partition")
    message_offset = config.require_object("messageOffset")
    test = sbercloud.get_dms_kafka_messages(instance_id=instance_id,
        topic=topic,
        partition=partition,
        message_offset=message_offset)
    ```


    :param _builtins.bool download: Whether download is required.
           If it is **false**, the big message will be truncated. Defaults to **false**.
    :param _builtins.str end_time: Specifies the end time, a Unix timestamp in millisecond.
           This parameter is mandatory when you query the message creation time.
    :param _builtins.str instance_id: Specifies the instance ID.
    :param _builtins.str keyword: Specifies the keyword.
           If it's specified, a maximum of **10** messages can be returned.
    :param _builtins.str message_offset: Specifies the message offset.
           This parameter is mandatory when you query the message content by offset.
    :param _builtins.str partition: Specifies the partition.
           This parameter is mandatory when you query the message content by offset.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str start_time: Specifies the start time, a Unix timestamp in millisecond.
           This parameter is mandatory when you query the message creation time.
    :param _builtins.str topic: Specifies the topic name.
    """
    __args__ = dict()
    __args__['download'] = download
    __args__['endTime'] = end_time
    __args__['instanceId'] = instance_id
    __args__['keyword'] = keyword
    __args__['messageOffset'] = message_offset
    __args__['partition'] = partition
    __args__['region'] = region
    __args__['startTime'] = start_time
    __args__['topic'] = topic
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getDmsKafkaMessages:getDmsKafkaMessages', __args__, opts=opts, typ=GetDmsKafkaMessagesResult).value

    return AwaitableGetDmsKafkaMessagesResult(
        download=pulumi.get(__ret__, 'download'),
        end_time=pulumi.get(__ret__, 'end_time'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        keyword=pulumi.get(__ret__, 'keyword'),
        message_offset=pulumi.get(__ret__, 'message_offset'),
        messages=pulumi.get(__ret__, 'messages'),
        partition=pulumi.get(__ret__, 'partition'),
        region=pulumi.get(__ret__, 'region'),
        start_time=pulumi.get(__ret__, 'start_time'),
        topic=pulumi.get(__ret__, 'topic'))
def get_dms_kafka_messages_output(download: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                  end_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  keyword: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  message_offset: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  partition: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  start_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  topic: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDmsKafkaMessagesResult]:
    """
    Use this data source to get the list of Kafka messages.

    ## Example Usage

    ### Query messages by creation time

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    topic = config.require_object("topic")
    start_time = config.require_object("startTime")
    end_time = config.require_object("endTime")
    test = sbercloud.get_dms_kafka_messages(instance_id=instance_id,
        topic=topic,
        start_time=start_time,
        end_time=end_time)
    ```

    ### Query messages by content's keyword, a maximum of 10 messages can be returned

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    topic = config.require_object("topic")
    start_time = config.require_object("startTime")
    end_time = config.require_object("endTime")
    keyword = config.require_object("keyword")
    test = sbercloud.get_dms_kafka_messages(instance_id=instance_id,
        topic=topic,
        start_time=start_time,
        end_time=end_time,
        keyword=keyword)
    ```

    ### Query messages content by offset

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    topic = config.require_object("topic")
    partition = config.require_object("partition")
    message_offset = config.require_object("messageOffset")
    test = sbercloud.get_dms_kafka_messages(instance_id=instance_id,
        topic=topic,
        partition=partition,
        message_offset=message_offset)
    ```


    :param _builtins.bool download: Whether download is required.
           If it is **false**, the big message will be truncated. Defaults to **false**.
    :param _builtins.str end_time: Specifies the end time, a Unix timestamp in millisecond.
           This parameter is mandatory when you query the message creation time.
    :param _builtins.str instance_id: Specifies the instance ID.
    :param _builtins.str keyword: Specifies the keyword.
           If it's specified, a maximum of **10** messages can be returned.
    :param _builtins.str message_offset: Specifies the message offset.
           This parameter is mandatory when you query the message content by offset.
    :param _builtins.str partition: Specifies the partition.
           This parameter is mandatory when you query the message content by offset.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str start_time: Specifies the start time, a Unix timestamp in millisecond.
           This parameter is mandatory when you query the message creation time.
    :param _builtins.str topic: Specifies the topic name.
    """
    __args__ = dict()
    __args__['download'] = download
    __args__['endTime'] = end_time
    __args__['instanceId'] = instance_id
    __args__['keyword'] = keyword
    __args__['messageOffset'] = message_offset
    __args__['partition'] = partition
    __args__['region'] = region
    __args__['startTime'] = start_time
    __args__['topic'] = topic
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getDmsKafkaMessages:getDmsKafkaMessages', __args__, opts=opts, typ=GetDmsKafkaMessagesResult)
    return __ret__.apply(lambda __response__: GetDmsKafkaMessagesResult(
        download=pulumi.get(__response__, 'download'),
        end_time=pulumi.get(__response__, 'end_time'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        keyword=pulumi.get(__response__, 'keyword'),
        message_offset=pulumi.get(__response__, 'message_offset'),
        messages=pulumi.get(__response__, 'messages'),
        partition=pulumi.get(__response__, 'partition'),
        region=pulumi.get(__response__, 'region'),
        start_time=pulumi.get(__response__, 'start_time'),
        topic=pulumi.get(__response__, 'topic')))
