# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDmsKafkaUsersResult',
    'AwaitableGetDmsKafkaUsersResult',
    'get_dms_kafka_users',
    'get_dms_kafka_users_output',
]

@pulumi.output_type
class GetDmsKafkaUsersResult:
    """
    A collection of values returned by getDmsKafkaUsers.
    """
    def __init__(__self__, description=None, id=None, instance_id=None, name=None, region=None, users=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Indicates the description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Indicates the username.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetDmsKafkaUsersUserResult']:
        """
        Indicates the user list.
        """
        return pulumi.get(self, "users")


class AwaitableGetDmsKafkaUsersResult(GetDmsKafkaUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDmsKafkaUsersResult(
            description=self.description,
            id=self.id,
            instance_id=self.instance_id,
            name=self.name,
            region=self.region,
            users=self.users)


def get_dms_kafka_users(description: Optional[_builtins.str] = None,
                        instance_id: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        region: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDmsKafkaUsersResult:
    """
    Use this data source to get the list of Kafka instance users.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.get_dms_kafka_users(instance_id=instance_id)
    ```


    :param _builtins.str description: Specifies the user description.
    :param _builtins.str instance_id: Specifies the instance ID.
    :param _builtins.str name: Specifies the user name.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getDmsKafkaUsers:getDmsKafkaUsers', __args__, opts=opts, typ=GetDmsKafkaUsersResult).value

    return AwaitableGetDmsKafkaUsersResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        users=pulumi.get(__ret__, 'users'))
def get_dms_kafka_users_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDmsKafkaUsersResult]:
    """
    Use this data source to get the list of Kafka instance users.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.get_dms_kafka_users(instance_id=instance_id)
    ```


    :param _builtins.str description: Specifies the user description.
    :param _builtins.str instance_id: Specifies the instance ID.
    :param _builtins.str name: Specifies the user name.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getDmsKafkaUsers:getDmsKafkaUsers', __args__, opts=opts, typ=GetDmsKafkaUsersResult)
    return __ret__.apply(lambda __response__: GetDmsKafkaUsersResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        users=pulumi.get(__response__, 'users')))
