# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDmsRabbitmqFlavorsResult',
    'AwaitableGetDmsRabbitmqFlavorsResult',
    'get_dms_rabbitmq_flavors',
    'get_dms_rabbitmq_flavors_output',
]

@pulumi.output_type
class GetDmsRabbitmqFlavorsResult:
    """
    A collection of values returned by getDmsRabbitmqFlavors.
    """
    def __init__(__self__, arch_type=None, availability_zones=None, charging_mode=None, flavor_id=None, flavors=None, id=None, region=None, storage_spec_code=None, type=None, versions=None):
        if arch_type and not isinstance(arch_type, str):
            raise TypeError("Expected argument 'arch_type' to be a str")
        pulumi.set(__self__, "arch_type", arch_type)
        if availability_zones and not isinstance(availability_zones, list):
            raise TypeError("Expected argument 'availability_zones' to be a list")
        pulumi.set(__self__, "availability_zones", availability_zones)
        if charging_mode and not isinstance(charging_mode, str):
            raise TypeError("Expected argument 'charging_mode' to be a str")
        pulumi.set(__self__, "charging_mode", charging_mode)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if storage_spec_code and not isinstance(storage_spec_code, str):
            raise TypeError("Expected argument 'storage_spec_code' to be a str")
        pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "arch_type")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[Sequence[_builtins.str]]:
        """
        Indicates the list of availability zones with available resources.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetDmsRabbitmqFlavorsFlavorResult']:
        """
        Indicates the list of flavor details.
        The object structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> Optional[_builtins.str]:
        """
        Indicates the disk IO encoding.
        """
        return pulumi.get(self, "storage_spec_code")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The disk type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence[_builtins.str]:
        """
        Indicates the supported flavor versions.
        """
        return pulumi.get(self, "versions")


class AwaitableGetDmsRabbitmqFlavorsResult(GetDmsRabbitmqFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDmsRabbitmqFlavorsResult(
            arch_type=self.arch_type,
            availability_zones=self.availability_zones,
            charging_mode=self.charging_mode,
            flavor_id=self.flavor_id,
            flavors=self.flavors,
            id=self.id,
            region=self.region,
            storage_spec_code=self.storage_spec_code,
            type=self.type,
            versions=self.versions)


def get_dms_rabbitmq_flavors(arch_type: Optional[_builtins.str] = None,
                             availability_zones: Optional[Sequence[_builtins.str]] = None,
                             charging_mode: Optional[_builtins.str] = None,
                             flavor_id: Optional[_builtins.str] = None,
                             region: Optional[_builtins.str] = None,
                             storage_spec_code: Optional[_builtins.str] = None,
                             type: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDmsRabbitmqFlavorsResult:
    """
    Use this data source to get the list of RabbitMQ available flavor details within SberCloud.

    ## Example Usage

    ### Query the list of RabbitMQ flavors by cluster type

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.get_dms_rabbitmq_flavors(type="cluster")
    ```

    ### Query the list of RabbitMQ flavors by flavor ID

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.get_dms_rabbitmq_flavors(flavor_id="c6.2u4g.cluster")
    ```

    ### Query the list of RabbitMQ flavors by availability zone

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    az1 = config.require_object("az1")
    az2 = config.require_object("az2")
    test = sbercloud.get_dms_rabbitmq_flavors(availability_zones=[
        az1,
        az2,
    ])
    ```


    :param _builtins.str arch_type: Specifies the type of CPU architecture, e.g. **X86**.
    :param Sequence[_builtins.str] availability_zones: Specifies the list of availability zones with available resources.
    :param _builtins.str charging_mode: Specifies the flavor billing mode.
           The valid values are **prePaid** and **postPaid**.
    :param _builtins.str flavor_id: Specifies the DMS flavor ID, e.g. **c6.2u4g.cluster**.
    :param _builtins.str region: Specifies the region in which to obtain the dms RabbitMQ flavors.
           If omitted, the provider-level region will be used.
    :param _builtins.str storage_spec_code: Specifies the disk IO encoding.
           + **dms.physical.storage.high.v2**: Type of the disk that uses high I/O.
           + **dms.physical.storage.ultra.v2**: Type of the disk that uses ultra-high I/O.
    :param _builtins.str type: Specifies flavor type. The valid values are **single** and **cluster**.
    """
    __args__ = dict()
    __args__['archType'] = arch_type
    __args__['availabilityZones'] = availability_zones
    __args__['chargingMode'] = charging_mode
    __args__['flavorId'] = flavor_id
    __args__['region'] = region
    __args__['storageSpecCode'] = storage_spec_code
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getDmsRabbitmqFlavors:getDmsRabbitmqFlavors', __args__, opts=opts, typ=GetDmsRabbitmqFlavorsResult).value

    return AwaitableGetDmsRabbitmqFlavorsResult(
        arch_type=pulumi.get(__ret__, 'arch_type'),
        availability_zones=pulumi.get(__ret__, 'availability_zones'),
        charging_mode=pulumi.get(__ret__, 'charging_mode'),
        flavor_id=pulumi.get(__ret__, 'flavor_id'),
        flavors=pulumi.get(__ret__, 'flavors'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        storage_spec_code=pulumi.get(__ret__, 'storage_spec_code'),
        type=pulumi.get(__ret__, 'type'),
        versions=pulumi.get(__ret__, 'versions'))
def get_dms_rabbitmq_flavors_output(arch_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    availability_zones: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                    charging_mode: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    flavor_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    storage_spec_code: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDmsRabbitmqFlavorsResult]:
    """
    Use this data source to get the list of RabbitMQ available flavor details within SberCloud.

    ## Example Usage

    ### Query the list of RabbitMQ flavors by cluster type

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.get_dms_rabbitmq_flavors(type="cluster")
    ```

    ### Query the list of RabbitMQ flavors by flavor ID

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.get_dms_rabbitmq_flavors(flavor_id="c6.2u4g.cluster")
    ```

    ### Query the list of RabbitMQ flavors by availability zone

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    az1 = config.require_object("az1")
    az2 = config.require_object("az2")
    test = sbercloud.get_dms_rabbitmq_flavors(availability_zones=[
        az1,
        az2,
    ])
    ```


    :param _builtins.str arch_type: Specifies the type of CPU architecture, e.g. **X86**.
    :param Sequence[_builtins.str] availability_zones: Specifies the list of availability zones with available resources.
    :param _builtins.str charging_mode: Specifies the flavor billing mode.
           The valid values are **prePaid** and **postPaid**.
    :param _builtins.str flavor_id: Specifies the DMS flavor ID, e.g. **c6.2u4g.cluster**.
    :param _builtins.str region: Specifies the region in which to obtain the dms RabbitMQ flavors.
           If omitted, the provider-level region will be used.
    :param _builtins.str storage_spec_code: Specifies the disk IO encoding.
           + **dms.physical.storage.high.v2**: Type of the disk that uses high I/O.
           + **dms.physical.storage.ultra.v2**: Type of the disk that uses ultra-high I/O.
    :param _builtins.str type: Specifies flavor type. The valid values are **single** and **cluster**.
    """
    __args__ = dict()
    __args__['archType'] = arch_type
    __args__['availabilityZones'] = availability_zones
    __args__['chargingMode'] = charging_mode
    __args__['flavorId'] = flavor_id
    __args__['region'] = region
    __args__['storageSpecCode'] = storage_spec_code
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getDmsRabbitmqFlavors:getDmsRabbitmqFlavors', __args__, opts=opts, typ=GetDmsRabbitmqFlavorsResult)
    return __ret__.apply(lambda __response__: GetDmsRabbitmqFlavorsResult(
        arch_type=pulumi.get(__response__, 'arch_type'),
        availability_zones=pulumi.get(__response__, 'availability_zones'),
        charging_mode=pulumi.get(__response__, 'charging_mode'),
        flavor_id=pulumi.get(__response__, 'flavor_id'),
        flavors=pulumi.get(__response__, 'flavors'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        storage_spec_code=pulumi.get(__response__, 'storage_spec_code'),
        type=pulumi.get(__response__, 'type'),
        versions=pulumi.get(__response__, 'versions')))
