# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDmsRocketmqConsumerGroupsResult',
    'AwaitableGetDmsRocketmqConsumerGroupsResult',
    'get_dms_rocketmq_consumer_groups',
    'get_dms_rocketmq_consumer_groups_output',
]

@pulumi.output_type
class GetDmsRocketmqConsumerGroupsResult:
    """
    A collection of values returned by getDmsRocketmqConsumerGroups.
    """
    def __init__(__self__, broadcast=None, enabled=None, groups=None, id=None, instance_id=None, name=None, region=None, retry_max_times=None):
        if broadcast and not isinstance(broadcast, bool):
            raise TypeError("Expected argument 'broadcast' to be a bool")
        pulumi.set(__self__, "broadcast", broadcast)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if retry_max_times and not isinstance(retry_max_times, int):
            raise TypeError("Expected argument 'retry_max_times' to be a int")
        pulumi.set(__self__, "retry_max_times", retry_max_times)

    @_builtins.property
    @pulumi.getter
    def broadcast(self) -> Optional[_builtins.bool]:
        """
        Indicates whether to broadcast the consumer group.
        """
        return pulumi.get(self, "broadcast")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Indicates the consumer group is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetDmsRocketmqConsumerGroupsGroupResult']:
        """
        The list of consumer groups.
        The groups structure is documented below.
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Indicates the name of the consumer group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="retryMaxTimes")
    def retry_max_times(self) -> Optional[_builtins.int]:
        """
        Indicates the maximum number of retry times.
        """
        return pulumi.get(self, "retry_max_times")


class AwaitableGetDmsRocketmqConsumerGroupsResult(GetDmsRocketmqConsumerGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDmsRocketmqConsumerGroupsResult(
            broadcast=self.broadcast,
            enabled=self.enabled,
            groups=self.groups,
            id=self.id,
            instance_id=self.instance_id,
            name=self.name,
            region=self.region,
            retry_max_times=self.retry_max_times)


def get_dms_rocketmq_consumer_groups(broadcast: Optional[_builtins.bool] = None,
                                     enabled: Optional[_builtins.bool] = None,
                                     instance_id: Optional[_builtins.str] = None,
                                     name: Optional[_builtins.str] = None,
                                     region: Optional[_builtins.str] = None,
                                     retry_max_times: Optional[_builtins.int] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDmsRocketmqConsumerGroupsResult:
    """
    Use this data source to get the list of DMS rocketMQ consumer groups.


    :param _builtins.bool broadcast: Specifies whether to broadcast the consumer group. Defaults to **false**.
    :param _builtins.bool enabled: Specifies the consumer group is enabled or not. Defaults to **true**.
    :param _builtins.str instance_id: Specifies the ID of the rocketMQ instance.
    :param _builtins.str name: Specifies the name of the consumer group.
    :param _builtins.str region: Specifies the region in which to create the resource.
           If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
    :param _builtins.int retry_max_times: Specifies the maximum number of retry times.
    """
    __args__ = dict()
    __args__['broadcast'] = broadcast
    __args__['enabled'] = enabled
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['retryMaxTimes'] = retry_max_times
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getDmsRocketmqConsumerGroups:getDmsRocketmqConsumerGroups', __args__, opts=opts, typ=GetDmsRocketmqConsumerGroupsResult).value

    return AwaitableGetDmsRocketmqConsumerGroupsResult(
        broadcast=pulumi.get(__ret__, 'broadcast'),
        enabled=pulumi.get(__ret__, 'enabled'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        retry_max_times=pulumi.get(__ret__, 'retry_max_times'))
def get_dms_rocketmq_consumer_groups_output(broadcast: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                            enabled: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            retry_max_times: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDmsRocketmqConsumerGroupsResult]:
    """
    Use this data source to get the list of DMS rocketMQ consumer groups.


    :param _builtins.bool broadcast: Specifies whether to broadcast the consumer group. Defaults to **false**.
    :param _builtins.bool enabled: Specifies the consumer group is enabled or not. Defaults to **true**.
    :param _builtins.str instance_id: Specifies the ID of the rocketMQ instance.
    :param _builtins.str name: Specifies the name of the consumer group.
    :param _builtins.str region: Specifies the region in which to create the resource.
           If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
    :param _builtins.int retry_max_times: Specifies the maximum number of retry times.
    """
    __args__ = dict()
    __args__['broadcast'] = broadcast
    __args__['enabled'] = enabled
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['retryMaxTimes'] = retry_max_times
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getDmsRocketmqConsumerGroups:getDmsRocketmqConsumerGroups', __args__, opts=opts, typ=GetDmsRocketmqConsumerGroupsResult)
    return __ret__.apply(lambda __response__: GetDmsRocketmqConsumerGroupsResult(
        broadcast=pulumi.get(__response__, 'broadcast'),
        enabled=pulumi.get(__response__, 'enabled'),
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        retry_max_times=pulumi.get(__response__, 'retry_max_times')))
