# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDmsRocketmqConsumersResult',
    'AwaitableGetDmsRocketmqConsumersResult',
    'get_dms_rocketmq_consumers',
    'get_dms_rocketmq_consumers_output',
]

@pulumi.output_type
class GetDmsRocketmqConsumersResult:
    """
    A collection of values returned by getDmsRocketmqConsumers.
    """
    def __init__(__self__, clients=None, group=None, id=None, instance_id=None, is_detail=None, online=None, region=None, subscription_consistency=None):
        if clients and not isinstance(clients, list):
            raise TypeError("Expected argument 'clients' to be a list")
        pulumi.set(__self__, "clients", clients)
        if group and not isinstance(group, str):
            raise TypeError("Expected argument 'group' to be a str")
        pulumi.set(__self__, "group", group)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if is_detail and not isinstance(is_detail, bool):
            raise TypeError("Expected argument 'is_detail' to be a bool")
        pulumi.set(__self__, "is_detail", is_detail)
        if online and not isinstance(online, bool):
            raise TypeError("Expected argument 'online' to be a bool")
        pulumi.set(__self__, "online", online)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if subscription_consistency and not isinstance(subscription_consistency, bool):
            raise TypeError("Expected argument 'subscription_consistency' to be a bool")
        pulumi.set(__self__, "subscription_consistency", subscription_consistency)

    @_builtins.property
    @pulumi.getter
    def clients(self) -> Sequence['outputs.GetDmsRocketmqConsumersClientResult']:
        """
        Indicates the list of consumer subscription details.
        """
        return pulumi.get(self, "clients")

    @_builtins.property
    @pulumi.getter
    def group(self) -> _builtins.str:
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isDetail")
    def is_detail(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_detail")

    @_builtins.property
    @pulumi.getter
    def online(self) -> _builtins.bool:
        """
        Indicates whether the consumer group is online.
        """
        return pulumi.get(self, "online")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="subscriptionConsistency")
    def subscription_consistency(self) -> _builtins.bool:
        """
        Indicates whether subscriptions are consistent.
        """
        return pulumi.get(self, "subscription_consistency")


class AwaitableGetDmsRocketmqConsumersResult(GetDmsRocketmqConsumersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDmsRocketmqConsumersResult(
            clients=self.clients,
            group=self.group,
            id=self.id,
            instance_id=self.instance_id,
            is_detail=self.is_detail,
            online=self.online,
            region=self.region,
            subscription_consistency=self.subscription_consistency)


def get_dms_rocketmq_consumers(group: Optional[_builtins.str] = None,
                               instance_id: Optional[_builtins.str] = None,
                               is_detail: Optional[_builtins.bool] = None,
                               region: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDmsRocketmqConsumersResult:
    """
    Use this data source to get the list of RocketMQ consumers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    group = config.require_object("group")
    test = sbercloud.get_dms_rocketmq_consumers(instance_id=instance_id,
        group=group,
        is_detail=True)
    ```


    :param _builtins.str group: Specifies the consumer group name.
    :param _builtins.str instance_id: Specifies the instance ID.
    :param _builtins.bool is_detail: Specifies whether to query the consumer details.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['group'] = group
    __args__['instanceId'] = instance_id
    __args__['isDetail'] = is_detail
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getDmsRocketmqConsumers:getDmsRocketmqConsumers', __args__, opts=opts, typ=GetDmsRocketmqConsumersResult).value

    return AwaitableGetDmsRocketmqConsumersResult(
        clients=pulumi.get(__ret__, 'clients'),
        group=pulumi.get(__ret__, 'group'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        is_detail=pulumi.get(__ret__, 'is_detail'),
        online=pulumi.get(__ret__, 'online'),
        region=pulumi.get(__ret__, 'region'),
        subscription_consistency=pulumi.get(__ret__, 'subscription_consistency'))
def get_dms_rocketmq_consumers_output(group: Optional[pulumi.Input[_builtins.str]] = None,
                                      instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      is_detail: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDmsRocketmqConsumersResult]:
    """
    Use this data source to get the list of RocketMQ consumers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    group = config.require_object("group")
    test = sbercloud.get_dms_rocketmq_consumers(instance_id=instance_id,
        group=group,
        is_detail=True)
    ```


    :param _builtins.str group: Specifies the consumer group name.
    :param _builtins.str instance_id: Specifies the instance ID.
    :param _builtins.bool is_detail: Specifies whether to query the consumer details.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['group'] = group
    __args__['instanceId'] = instance_id
    __args__['isDetail'] = is_detail
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getDmsRocketmqConsumers:getDmsRocketmqConsumers', __args__, opts=opts, typ=GetDmsRocketmqConsumersResult)
    return __ret__.apply(lambda __response__: GetDmsRocketmqConsumersResult(
        clients=pulumi.get(__response__, 'clients'),
        group=pulumi.get(__response__, 'group'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        is_detail=pulumi.get(__response__, 'is_detail'),
        online=pulumi.get(__response__, 'online'),
        region=pulumi.get(__response__, 'region'),
        subscription_consistency=pulumi.get(__response__, 'subscription_consistency')))
