# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDmsRocketmqMessagesResult',
    'AwaitableGetDmsRocketmqMessagesResult',
    'get_dms_rocketmq_messages',
    'get_dms_rocketmq_messages_output',
]

@pulumi.output_type
class GetDmsRocketmqMessagesResult:
    """
    A collection of values returned by getDmsRocketmqMessages.
    """
    def __init__(__self__, end_time=None, id=None, instance_id=None, key=None, message_id=None, messages=None, region=None, start_time=None, topic=None):
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if message_id and not isinstance(message_id, str):
            raise TypeError("Expected argument 'message_id' to be a str")
        pulumi.set(__self__, "message_id", message_id)
        if messages and not isinstance(messages, list):
            raise TypeError("Expected argument 'messages' to be a list")
        pulumi.set(__self__, "messages", messages)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)
        if topic and not isinstance(topic, str):
            raise TypeError("Expected argument 'topic' to be a str")
        pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[_builtins.str]:
        """
        Indicates the message ID.
        """
        return pulumi.get(self, "message_id")

    @_builtins.property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.GetDmsRocketmqMessagesMessageResult']:
        """
        Indicates the message list.
        The messages structure is documented below.
        """
        return pulumi.get(self, "messages")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        return pulumi.get(self, "topic")


class AwaitableGetDmsRocketmqMessagesResult(GetDmsRocketmqMessagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDmsRocketmqMessagesResult(
            end_time=self.end_time,
            id=self.id,
            instance_id=self.instance_id,
            key=self.key,
            message_id=self.message_id,
            messages=self.messages,
            region=self.region,
            start_time=self.start_time,
            topic=self.topic)


def get_dms_rocketmq_messages(end_time: Optional[_builtins.str] = None,
                              instance_id: Optional[_builtins.str] = None,
                              key: Optional[_builtins.str] = None,
                              message_id: Optional[_builtins.str] = None,
                              region: Optional[_builtins.str] = None,
                              start_time: Optional[_builtins.str] = None,
                              topic: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDmsRocketmqMessagesResult:
    """
    Use this data source to get the list of RocketMQ instance messages.

    ## Example Usage

    ### Query message by topic

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    topic = config.require_object("topic")
    start_time = config.require_object("startTime")
    end_time = config.require_object("endTime")
    test = sbercloud.get_dms_rocketmq_messages(instance_id=instance_id,
        topic=topic,
        start_time=start_time,
        end_time=end_time)
    ```

    ### Query message by key

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    topic = config.require_object("topic")
    key = config.require_object("key")
    test = sbercloud.get_dms_rocketmq_messages(instance_id=instance_id,
        topic=topic,
        key=key)
    ```

    ### Query message by message ID

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    topic = config.require_object("topic")
    message_id = config.require_object("messageId")
    test = sbercloud.get_dms_rocketmq_messages(instance_id=instance_id,
        topic=topic,
        message_id=message_id)
    ```


    :param _builtins.str end_time: Specifies the end time, a Unix timestamp in millisecond.
    :param _builtins.str instance_id: Specifies the instance ID.
    :param _builtins.str key: Specifies the message key.
    :param _builtins.str message_id: Specifies the message ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str start_time: Specifies the start time, a Unix timestamp in millisecond.
    :param _builtins.str topic: Specifies the topic name.
    """
    __args__ = dict()
    __args__['endTime'] = end_time
    __args__['instanceId'] = instance_id
    __args__['key'] = key
    __args__['messageId'] = message_id
    __args__['region'] = region
    __args__['startTime'] = start_time
    __args__['topic'] = topic
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getDmsRocketmqMessages:getDmsRocketmqMessages', __args__, opts=opts, typ=GetDmsRocketmqMessagesResult).value

    return AwaitableGetDmsRocketmqMessagesResult(
        end_time=pulumi.get(__ret__, 'end_time'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        key=pulumi.get(__ret__, 'key'),
        message_id=pulumi.get(__ret__, 'message_id'),
        messages=pulumi.get(__ret__, 'messages'),
        region=pulumi.get(__ret__, 'region'),
        start_time=pulumi.get(__ret__, 'start_time'),
        topic=pulumi.get(__ret__, 'topic'))
def get_dms_rocketmq_messages_output(end_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     key: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     message_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     start_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     topic: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDmsRocketmqMessagesResult]:
    """
    Use this data source to get the list of RocketMQ instance messages.

    ## Example Usage

    ### Query message by topic

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    topic = config.require_object("topic")
    start_time = config.require_object("startTime")
    end_time = config.require_object("endTime")
    test = sbercloud.get_dms_rocketmq_messages(instance_id=instance_id,
        topic=topic,
        start_time=start_time,
        end_time=end_time)
    ```

    ### Query message by key

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    topic = config.require_object("topic")
    key = config.require_object("key")
    test = sbercloud.get_dms_rocketmq_messages(instance_id=instance_id,
        topic=topic,
        key=key)
    ```

    ### Query message by message ID

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    topic = config.require_object("topic")
    message_id = config.require_object("messageId")
    test = sbercloud.get_dms_rocketmq_messages(instance_id=instance_id,
        topic=topic,
        message_id=message_id)
    ```


    :param _builtins.str end_time: Specifies the end time, a Unix timestamp in millisecond.
    :param _builtins.str instance_id: Specifies the instance ID.
    :param _builtins.str key: Specifies the message key.
    :param _builtins.str message_id: Specifies the message ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str start_time: Specifies the start time, a Unix timestamp in millisecond.
    :param _builtins.str topic: Specifies the topic name.
    """
    __args__ = dict()
    __args__['endTime'] = end_time
    __args__['instanceId'] = instance_id
    __args__['key'] = key
    __args__['messageId'] = message_id
    __args__['region'] = region
    __args__['startTime'] = start_time
    __args__['topic'] = topic
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getDmsRocketmqMessages:getDmsRocketmqMessages', __args__, opts=opts, typ=GetDmsRocketmqMessagesResult)
    return __ret__.apply(lambda __response__: GetDmsRocketmqMessagesResult(
        end_time=pulumi.get(__response__, 'end_time'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        key=pulumi.get(__response__, 'key'),
        message_id=pulumi.get(__response__, 'message_id'),
        messages=pulumi.get(__response__, 'messages'),
        region=pulumi.get(__response__, 'region'),
        start_time=pulumi.get(__response__, 'start_time'),
        topic=pulumi.get(__response__, 'topic')))
