# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDmsRocketmqUsersResult',
    'AwaitableGetDmsRocketmqUsersResult',
    'get_dms_rocketmq_users',
    'get_dms_rocketmq_users_output',
]

@pulumi.output_type
class GetDmsRocketmqUsersResult:
    """
    A collection of values returned by getDmsRocketmqUsers.
    """
    def __init__(__self__, access_key=None, admin=None, default_group_perm=None, default_topic_perm=None, id=None, instance_id=None, region=None, users=None, white_remote_address=None):
        if access_key and not isinstance(access_key, str):
            raise TypeError("Expected argument 'access_key' to be a str")
        pulumi.set(__self__, "access_key", access_key)
        if admin and not isinstance(admin, bool):
            raise TypeError("Expected argument 'admin' to be a bool")
        pulumi.set(__self__, "admin", admin)
        if default_group_perm and not isinstance(default_group_perm, str):
            raise TypeError("Expected argument 'default_group_perm' to be a str")
        pulumi.set(__self__, "default_group_perm", default_group_perm)
        if default_topic_perm and not isinstance(default_topic_perm, str):
            raise TypeError("Expected argument 'default_topic_perm' to be a str")
        pulumi.set(__self__, "default_topic_perm", default_topic_perm)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)
        if white_remote_address and not isinstance(white_remote_address, str):
            raise TypeError("Expected argument 'white_remote_address' to be a str")
        pulumi.set(__self__, "white_remote_address", white_remote_address)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[_builtins.str]:
        """
        Indicates the name of the user.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter
    def admin(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the user is an administrator.
        """
        return pulumi.get(self, "admin")

    @_builtins.property
    @pulumi.getter(name="defaultGroupPerm")
    def default_group_perm(self) -> Optional[_builtins.str]:
        """
        Indicates the default consumer group permissions.
        Value options: **SUB**, **DENY**.
        """
        return pulumi.get(self, "default_group_perm")

    @_builtins.property
    @pulumi.getter(name="defaultTopicPerm")
    def default_topic_perm(self) -> Optional[_builtins.str]:
        """
        Indicates the default topic permissions.
        Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        """
        return pulumi.get(self, "default_topic_perm")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetDmsRocketmqUsersUserResult']:
        """
        The list of users.
        The users structure is documented below.
        """
        return pulumi.get(self, "users")

    @_builtins.property
    @pulumi.getter(name="whiteRemoteAddress")
    def white_remote_address(self) -> Optional[_builtins.str]:
        """
        Indicates the IP address whitelist.
        """
        return pulumi.get(self, "white_remote_address")


class AwaitableGetDmsRocketmqUsersResult(GetDmsRocketmqUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDmsRocketmqUsersResult(
            access_key=self.access_key,
            admin=self.admin,
            default_group_perm=self.default_group_perm,
            default_topic_perm=self.default_topic_perm,
            id=self.id,
            instance_id=self.instance_id,
            region=self.region,
            users=self.users,
            white_remote_address=self.white_remote_address)


def get_dms_rocketmq_users(access_key: Optional[_builtins.str] = None,
                           admin: Optional[_builtins.bool] = None,
                           default_group_perm: Optional[_builtins.str] = None,
                           default_topic_perm: Optional[_builtins.str] = None,
                           instance_id: Optional[_builtins.str] = None,
                           region: Optional[_builtins.str] = None,
                           white_remote_address: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDmsRocketmqUsersResult:
    """
    Use this data source to get the list of DMS rocketMQ users.


    :param _builtins.str access_key: Specifies the user name.
    :param _builtins.bool admin: Specifies whether the user is an administrator.
    :param _builtins.str default_group_perm: Specifies the default consumer group permissions.
           Value options: **SUB**, **DENY**.
    :param _builtins.str default_topic_perm: Specifies the default topic permissions.
           Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
    :param _builtins.str instance_id: Specifies the ID of the rocketMQ instance.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param _builtins.str white_remote_address: Specifies the IP address whitelist.
    """
    __args__ = dict()
    __args__['accessKey'] = access_key
    __args__['admin'] = admin
    __args__['defaultGroupPerm'] = default_group_perm
    __args__['defaultTopicPerm'] = default_topic_perm
    __args__['instanceId'] = instance_id
    __args__['region'] = region
    __args__['whiteRemoteAddress'] = white_remote_address
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getDmsRocketmqUsers:getDmsRocketmqUsers', __args__, opts=opts, typ=GetDmsRocketmqUsersResult).value

    return AwaitableGetDmsRocketmqUsersResult(
        access_key=pulumi.get(__ret__, 'access_key'),
        admin=pulumi.get(__ret__, 'admin'),
        default_group_perm=pulumi.get(__ret__, 'default_group_perm'),
        default_topic_perm=pulumi.get(__ret__, 'default_topic_perm'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        region=pulumi.get(__ret__, 'region'),
        users=pulumi.get(__ret__, 'users'),
        white_remote_address=pulumi.get(__ret__, 'white_remote_address'))
def get_dms_rocketmq_users_output(access_key: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  admin: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                  default_group_perm: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  default_topic_perm: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  white_remote_address: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDmsRocketmqUsersResult]:
    """
    Use this data source to get the list of DMS rocketMQ users.


    :param _builtins.str access_key: Specifies the user name.
    :param _builtins.bool admin: Specifies whether the user is an administrator.
    :param _builtins.str default_group_perm: Specifies the default consumer group permissions.
           Value options: **SUB**, **DENY**.
    :param _builtins.str default_topic_perm: Specifies the default topic permissions.
           Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
    :param _builtins.str instance_id: Specifies the ID of the rocketMQ instance.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param _builtins.str white_remote_address: Specifies the IP address whitelist.
    """
    __args__ = dict()
    __args__['accessKey'] = access_key
    __args__['admin'] = admin
    __args__['defaultGroupPerm'] = default_group_perm
    __args__['defaultTopicPerm'] = default_topic_perm
    __args__['instanceId'] = instance_id
    __args__['region'] = region
    __args__['whiteRemoteAddress'] = white_remote_address
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getDmsRocketmqUsers:getDmsRocketmqUsers', __args__, opts=opts, typ=GetDmsRocketmqUsersResult)
    return __ret__.apply(lambda __response__: GetDmsRocketmqUsersResult(
        access_key=pulumi.get(__response__, 'access_key'),
        admin=pulumi.get(__response__, 'admin'),
        default_group_perm=pulumi.get(__response__, 'default_group_perm'),
        default_topic_perm=pulumi.get(__response__, 'default_topic_perm'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        region=pulumi.get(__response__, 'region'),
        users=pulumi.get(__response__, 'users'),
        white_remote_address=pulumi.get(__response__, 'white_remote_address')))
