# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetElbCertificateResult',
    'AwaitableGetElbCertificateResult',
    'get_elb_certificate',
    'get_elb_certificate_output',
]

@pulumi.output_type
class GetElbCertificateResult:
    """
    A collection of values returned by getElbCertificate.
    """
    def __init__(__self__, description=None, domain=None, expiration=None, id=None, name=None, region=None, type=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if expiration and not isinstance(expiration, str):
            raise TypeError("Expected argument 'expiration' to be a str")
        pulumi.set(__self__, "expiration", expiration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Human-readable description for the Certificate.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain of the Certificate. This parameter is valid only when `type` is "server".
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> _builtins.str:
        """
        Indicates the time when the certificate expires.
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the certificate type. The value can be one of the following:
        """
        return pulumi.get(self, "type")


class AwaitableGetElbCertificateResult(GetElbCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetElbCertificateResult(
            description=self.description,
            domain=self.domain,
            expiration=self.expiration,
            id=self.id,
            name=self.name,
            region=self.region,
            type=self.type)


def get_elb_certificate(name: Optional[_builtins.str] = None,
                        region: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetElbCertificateResult:
    """
    Use this data source to get the certificate in SberCloud Dedicated Load Balance (Dedicated ELB).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    certificate_name = config.require_object("certificateName")
    test = sbercloud.get_elb_certificate(name=certificate_name)
    ```


    :param _builtins.str name: The name of certificate. The value is case sensitive and does not supports fuzzy matching.
           
           > **NOTE:** The certificate name is not unique. Only returns the last created one when matched multiple certificates.
    :param _builtins.str region: The region in which to obtain the Dedicated ELB certificate. If omitted, the
           provider-level region will be used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getElbCertificate:getElbCertificate', __args__, opts=opts, typ=GetElbCertificateResult).value

    return AwaitableGetElbCertificateResult(
        description=pulumi.get(__ret__, 'description'),
        domain=pulumi.get(__ret__, 'domain'),
        expiration=pulumi.get(__ret__, 'expiration'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        type=pulumi.get(__ret__, 'type'))
def get_elb_certificate_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                               region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetElbCertificateResult]:
    """
    Use this data source to get the certificate in SberCloud Dedicated Load Balance (Dedicated ELB).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    certificate_name = config.require_object("certificateName")
    test = sbercloud.get_elb_certificate(name=certificate_name)
    ```


    :param _builtins.str name: The name of certificate. The value is case sensitive and does not supports fuzzy matching.
           
           > **NOTE:** The certificate name is not unique. Only returns the last created one when matched multiple certificates.
    :param _builtins.str region: The region in which to obtain the Dedicated ELB certificate. If omitted, the
           provider-level region will be used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getElbCertificate:getElbCertificate', __args__, opts=opts, typ=GetElbCertificateResult)
    return __ret__.apply(lambda __response__: GetElbCertificateResult(
        description=pulumi.get(__response__, 'description'),
        domain=pulumi.get(__response__, 'domain'),
        expiration=pulumi.get(__response__, 'expiration'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        type=pulumi.get(__response__, 'type')))
