# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetElbFlavorsResult',
    'AwaitableGetElbFlavorsResult',
    'get_elb_flavors',
    'get_elb_flavors_output',
]

@pulumi.output_type
class GetElbFlavorsResult:
    """
    A collection of values returned by getElbFlavors.
    """
    def __init__(__self__, bandwidth=None, category=None, cps=None, flavor_id=None, flavor_sold_out=None, flavors=None, id=None, ids=None, list_all=None, max_connections=None, name=None, public_border_group=None, qps=None, region=None, shared=None, type=None):
        if bandwidth and not isinstance(bandwidth, int):
            raise TypeError("Expected argument 'bandwidth' to be a int")
        pulumi.set(__self__, "bandwidth", bandwidth)
        if category and not isinstance(category, int):
            raise TypeError("Expected argument 'category' to be a int")
        pulumi.set(__self__, "category", category)
        if cps and not isinstance(cps, int):
            raise TypeError("Expected argument 'cps' to be a int")
        pulumi.set(__self__, "cps", cps)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if flavor_sold_out and not isinstance(flavor_sold_out, str):
            raise TypeError("Expected argument 'flavor_sold_out' to be a str")
        pulumi.set(__self__, "flavor_sold_out", flavor_sold_out)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if list_all and not isinstance(list_all, str):
            raise TypeError("Expected argument 'list_all' to be a str")
        pulumi.set(__self__, "list_all", list_all)
        if max_connections and not isinstance(max_connections, int):
            raise TypeError("Expected argument 'max_connections' to be a int")
        pulumi.set(__self__, "max_connections", max_connections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_border_group and not isinstance(public_border_group, str):
            raise TypeError("Expected argument 'public_border_group' to be a str")
        pulumi.set(__self__, "public_border_group", public_border_group)
        if qps and not isinstance(qps, int):
            raise TypeError("Expected argument 'qps' to be a int")
        pulumi.set(__self__, "qps", qps)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if shared and not isinstance(shared, str):
            raise TypeError("Expected argument 'shared' to be a str")
        pulumi.set(__self__, "shared", shared)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[_builtins.int]:
        """
        Bandwidth size(Mbit/s) of the flavor.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def cps(self) -> Optional[_builtins.int]:
        """
        Cps of the flavor.
        """
        return pulumi.get(self, "cps")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="flavorSoldOut")
    def flavor_sold_out(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "flavor_sold_out")

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetElbFlavorsFlavorResult']:
        """
        A list of flavors. Each element contains the following attributes:
        """
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of flavor IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="listAll")
    def list_all(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "list_all")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[_builtins.int]:
        """
        Maximum connections of the flavor.
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the flavor.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicBorderGroup")
    def public_border_group(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "public_border_group")

    @_builtins.property
    @pulumi.getter
    def qps(self) -> Optional[_builtins.int]:
        """
        Qps of the L7 flavor.
        """
        return pulumi.get(self, "qps")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def shared(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "shared")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the flavor.
        """
        return pulumi.get(self, "type")


class AwaitableGetElbFlavorsResult(GetElbFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetElbFlavorsResult(
            bandwidth=self.bandwidth,
            category=self.category,
            cps=self.cps,
            flavor_id=self.flavor_id,
            flavor_sold_out=self.flavor_sold_out,
            flavors=self.flavors,
            id=self.id,
            ids=self.ids,
            list_all=self.list_all,
            max_connections=self.max_connections,
            name=self.name,
            public_border_group=self.public_border_group,
            qps=self.qps,
            region=self.region,
            shared=self.shared,
            type=self.type)


def get_elb_flavors(bandwidth: Optional[_builtins.int] = None,
                    category: Optional[_builtins.int] = None,
                    cps: Optional[_builtins.int] = None,
                    flavor_id: Optional[_builtins.str] = None,
                    flavor_sold_out: Optional[_builtins.str] = None,
                    list_all: Optional[_builtins.str] = None,
                    max_connections: Optional[_builtins.int] = None,
                    name: Optional[_builtins.str] = None,
                    public_border_group: Optional[_builtins.str] = None,
                    qps: Optional[_builtins.int] = None,
                    region: Optional[_builtins.str] = None,
                    shared: Optional[_builtins.str] = None,
                    type: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetElbFlavorsResult:
    """
    Use this data source to get the available ELB Flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudru as sbercloud
    import pulumi_sbercloud as sbercloud

    flavors = sbercloud.get_elb_flavors(type="L7",
        max_connections=200000,
        cps=2000,
        bandwidth=50)
    # Create Dedicated Load Balancer with the first matched flavor
    lb = sbercloud.ElbLoadbalancer("lb", l7_flavor_id=flavors.ids[0])
    ```


    :param _builtins.int bandwidth: Specifies the bandwidth size(Mbit/s) in the flavor.
    :param _builtins.int cps: Specifies the cps in the flavor.
    :param _builtins.int max_connections: Specifies the maximum connections in the flavor.
    :param _builtins.str name: Name of the flavor.
    :param _builtins.int qps: Specifies the qps in the L7 flavor.
    :param _builtins.str region: The region in which to obtain the flavors. If omitted, the provider-level region will be
           used.
    :param _builtins.str type: Specifies the flavor type. Valid values are L4 and L7.
    """
    __args__ = dict()
    __args__['bandwidth'] = bandwidth
    __args__['category'] = category
    __args__['cps'] = cps
    __args__['flavorId'] = flavor_id
    __args__['flavorSoldOut'] = flavor_sold_out
    __args__['listAll'] = list_all
    __args__['maxConnections'] = max_connections
    __args__['name'] = name
    __args__['publicBorderGroup'] = public_border_group
    __args__['qps'] = qps
    __args__['region'] = region
    __args__['shared'] = shared
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getElbFlavors:getElbFlavors', __args__, opts=opts, typ=GetElbFlavorsResult).value

    return AwaitableGetElbFlavorsResult(
        bandwidth=pulumi.get(__ret__, 'bandwidth'),
        category=pulumi.get(__ret__, 'category'),
        cps=pulumi.get(__ret__, 'cps'),
        flavor_id=pulumi.get(__ret__, 'flavor_id'),
        flavor_sold_out=pulumi.get(__ret__, 'flavor_sold_out'),
        flavors=pulumi.get(__ret__, 'flavors'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        list_all=pulumi.get(__ret__, 'list_all'),
        max_connections=pulumi.get(__ret__, 'max_connections'),
        name=pulumi.get(__ret__, 'name'),
        public_border_group=pulumi.get(__ret__, 'public_border_group'),
        qps=pulumi.get(__ret__, 'qps'),
        region=pulumi.get(__ret__, 'region'),
        shared=pulumi.get(__ret__, 'shared'),
        type=pulumi.get(__ret__, 'type'))
def get_elb_flavors_output(bandwidth: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                           category: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                           cps: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                           flavor_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           flavor_sold_out: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           list_all: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           max_connections: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                           name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           public_border_group: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           qps: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           shared: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetElbFlavorsResult]:
    """
    Use this data source to get the available ELB Flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudru as sbercloud
    import pulumi_sbercloud as sbercloud

    flavors = sbercloud.get_elb_flavors(type="L7",
        max_connections=200000,
        cps=2000,
        bandwidth=50)
    # Create Dedicated Load Balancer with the first matched flavor
    lb = sbercloud.ElbLoadbalancer("lb", l7_flavor_id=flavors.ids[0])
    ```


    :param _builtins.int bandwidth: Specifies the bandwidth size(Mbit/s) in the flavor.
    :param _builtins.int cps: Specifies the cps in the flavor.
    :param _builtins.int max_connections: Specifies the maximum connections in the flavor.
    :param _builtins.str name: Name of the flavor.
    :param _builtins.int qps: Specifies the qps in the L7 flavor.
    :param _builtins.str region: The region in which to obtain the flavors. If omitted, the provider-level region will be
           used.
    :param _builtins.str type: Specifies the flavor type. Valid values are L4 and L7.
    """
    __args__ = dict()
    __args__['bandwidth'] = bandwidth
    __args__['category'] = category
    __args__['cps'] = cps
    __args__['flavorId'] = flavor_id
    __args__['flavorSoldOut'] = flavor_sold_out
    __args__['listAll'] = list_all
    __args__['maxConnections'] = max_connections
    __args__['name'] = name
    __args__['publicBorderGroup'] = public_border_group
    __args__['qps'] = qps
    __args__['region'] = region
    __args__['shared'] = shared
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getElbFlavors:getElbFlavors', __args__, opts=opts, typ=GetElbFlavorsResult)
    return __ret__.apply(lambda __response__: GetElbFlavorsResult(
        bandwidth=pulumi.get(__response__, 'bandwidth'),
        category=pulumi.get(__response__, 'category'),
        cps=pulumi.get(__response__, 'cps'),
        flavor_id=pulumi.get(__response__, 'flavor_id'),
        flavor_sold_out=pulumi.get(__response__, 'flavor_sold_out'),
        flavors=pulumi.get(__response__, 'flavors'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        list_all=pulumi.get(__response__, 'list_all'),
        max_connections=pulumi.get(__response__, 'max_connections'),
        name=pulumi.get(__response__, 'name'),
        public_border_group=pulumi.get(__response__, 'public_border_group'),
        qps=pulumi.get(__response__, 'qps'),
        region=pulumi.get(__response__, 'region'),
        shared=pulumi.get(__response__, 'shared'),
        type=pulumi.get(__response__, 'type')))
