# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFgsApplicationTemplatesResult',
    'AwaitableGetFgsApplicationTemplatesResult',
    'get_fgs_application_templates',
    'get_fgs_application_templates_output',
]

@pulumi.output_type
class GetFgsApplicationTemplatesResult:
    """
    A collection of values returned by getFgsApplicationTemplates.
    """
    def __init__(__self__, category=None, id=None, region=None, runtime=None, templates=None):
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if runtime and not isinstance(runtime, str):
            raise TypeError("Expected argument 'runtime' to be a str")
        pulumi.set(__self__, "runtime", runtime)
        if templates and not isinstance(templates, list):
            raise TypeError("Expected argument 'templates' to be a list")
        pulumi.set(__self__, "templates", templates)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.str]:
        """
        The template category.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[_builtins.str]:
        """
        The template runtime.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter
    def templates(self) -> Sequence['outputs.GetFgsApplicationTemplatesTemplateResult']:
        """
        All application templates that match the filter parameters.  
        The templates structure is documented below.
        """
        return pulumi.get(self, "templates")


class AwaitableGetFgsApplicationTemplatesResult(GetFgsApplicationTemplatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFgsApplicationTemplatesResult(
            category=self.category,
            id=self.id,
            region=self.region,
            runtime=self.runtime,
            templates=self.templates)


def get_fgs_application_templates(category: Optional[_builtins.str] = None,
                                  region: Optional[_builtins.str] = None,
                                  runtime: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFgsApplicationTemplatesResult:
    """
    Use this data source to get the list of application templates within SberCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.get_fgs_application_templates(runtime="Python2.7")
    ```


    :param _builtins.str category: Specifies the category used to query the application templates.
    :param _builtins.str region: Specifies the region where the application templates are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str runtime: Specifies the runtime name used to query the application templates.  
           The valid values are as follows:
           + **Node.js6.10**
           + **Node.js8.10**
           + **Node.js10.16**
           + **Node.js12.13**
           + **Node.js14.18**
           + **Node.js16.17**
           + **Node.js18.15**
           + **Python2.7**
           + **Python3.6**
           + **Python3.9**
           + **Python3.10**
           + **Java8**
           + **Java11**
           + **Go1.x**
           + **C#(.NET Core 2.1)**
           + **C#(.NET Core 3.1)**
           + **http**
           + **PHP7.3**
           + **Custom**
    """
    __args__ = dict()
    __args__['category'] = category
    __args__['region'] = region
    __args__['runtime'] = runtime
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getFgsApplicationTemplates:getFgsApplicationTemplates', __args__, opts=opts, typ=GetFgsApplicationTemplatesResult).value

    return AwaitableGetFgsApplicationTemplatesResult(
        category=pulumi.get(__ret__, 'category'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        runtime=pulumi.get(__ret__, 'runtime'),
        templates=pulumi.get(__ret__, 'templates'))
def get_fgs_application_templates_output(category: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         runtime: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFgsApplicationTemplatesResult]:
    """
    Use this data source to get the list of application templates within SberCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.get_fgs_application_templates(runtime="Python2.7")
    ```


    :param _builtins.str category: Specifies the category used to query the application templates.
    :param _builtins.str region: Specifies the region where the application templates are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str runtime: Specifies the runtime name used to query the application templates.  
           The valid values are as follows:
           + **Node.js6.10**
           + **Node.js8.10**
           + **Node.js10.16**
           + **Node.js12.13**
           + **Node.js14.18**
           + **Node.js16.17**
           + **Node.js18.15**
           + **Python2.7**
           + **Python3.6**
           + **Python3.9**
           + **Python3.10**
           + **Java8**
           + **Java11**
           + **Go1.x**
           + **C#(.NET Core 2.1)**
           + **C#(.NET Core 3.1)**
           + **http**
           + **PHP7.3**
           + **Custom**
    """
    __args__ = dict()
    __args__['category'] = category
    __args__['region'] = region
    __args__['runtime'] = runtime
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getFgsApplicationTemplates:getFgsApplicationTemplates', __args__, opts=opts, typ=GetFgsApplicationTemplatesResult)
    return __ret__.apply(lambda __response__: GetFgsApplicationTemplatesResult(
        category=pulumi.get(__response__, 'category'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        runtime=pulumi.get(__response__, 'runtime'),
        templates=pulumi.get(__response__, 'templates')))
