# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFgsApplicationsResult',
    'AwaitableGetFgsApplicationsResult',
    'get_fgs_applications',
    'get_fgs_applications_output',
]

@pulumi.output_type
class GetFgsApplicationsResult:
    """
    A collection of values returned by getFgsApplications.
    """
    def __init__(__self__, application_id=None, applications=None, description=None, id=None, name=None, region=None, status=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if applications and not isinstance(applications, list):
            raise TypeError("Expected argument 'applications' to be a list")
        pulumi.set(__self__, "applications", applications)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Sequence['outputs.GetFgsApplicationsApplicationResult']:
        """
        All applications that match the filter parameters.
        The applications structure is documented below.
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of application.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of application.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of application.
        """
        return pulumi.get(self, "status")


class AwaitableGetFgsApplicationsResult(GetFgsApplicationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFgsApplicationsResult(
            application_id=self.application_id,
            applications=self.applications,
            description=self.description,
            id=self.id,
            name=self.name,
            region=self.region,
            status=self.status)


def get_fgs_applications(application_id: Optional[_builtins.str] = None,
                         description: Optional[_builtins.str] = None,
                         name: Optional[_builtins.str] = None,
                         region: Optional[_builtins.str] = None,
                         status: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFgsApplicationsResult:
    """
    Use this data source to get the list of applications within SberCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    name = config.require_object("name")
    test = sbercloud.get_fgs_applications(name=name)
    ```


    :param _builtins.str application_id: Specifies the application ID used to query specified application.
    :param _builtins.str description: Specifies the description of the application to be queried.
    :param _builtins.str name: Specifies the application name used to query specified application.
    :param _builtins.str region: Specifies the region where the applications are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the status of the application to be queried.  
           The valid values are as follows:
           + **success**: The application created successfully.
           + **repoFail**: The application repository creation failed.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['description'] = description
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getFgsApplications:getFgsApplications', __args__, opts=opts, typ=GetFgsApplicationsResult).value

    return AwaitableGetFgsApplicationsResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        applications=pulumi.get(__ret__, 'applications'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'))
def get_fgs_applications_output(application_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFgsApplicationsResult]:
    """
    Use this data source to get the list of applications within SberCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    name = config.require_object("name")
    test = sbercloud.get_fgs_applications(name=name)
    ```


    :param _builtins.str application_id: Specifies the application ID used to query specified application.
    :param _builtins.str description: Specifies the description of the application to be queried.
    :param _builtins.str name: Specifies the application name used to query specified application.
    :param _builtins.str region: Specifies the region where the applications are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the status of the application to be queried.  
           The valid values are as follows:
           + **success**: The application created successfully.
           + **repoFail**: The application repository creation failed.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['description'] = description
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getFgsApplications:getFgsApplications', __args__, opts=opts, typ=GetFgsApplicationsResult)
    return __ret__.apply(lambda __response__: GetFgsApplicationsResult(
        application_id=pulumi.get(__response__, 'application_id'),
        applications=pulumi.get(__response__, 'applications'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status')))
