# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFgsDependencyVersionsResult',
    'AwaitableGetFgsDependencyVersionsResult',
    'get_fgs_dependency_versions',
    'get_fgs_dependency_versions_output',
]

@pulumi.output_type
class GetFgsDependencyVersionsResult:
    """
    A collection of values returned by getFgsDependencyVersions.
    """
    def __init__(__self__, dependency_id=None, id=None, region=None, runtime=None, version=None, version_id=None, versions=None):
        if dependency_id and not isinstance(dependency_id, str):
            raise TypeError("Expected argument 'dependency_id' to be a str")
        pulumi.set(__self__, "dependency_id", dependency_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if runtime and not isinstance(runtime, str):
            raise TypeError("Expected argument 'runtime' to be a str")
        pulumi.set(__self__, "runtime", runtime)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)
        if version_id and not isinstance(version_id, str):
            raise TypeError("Expected argument 'version_id' to be a str")
        pulumi.set(__self__, "version_id", version_id)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="dependencyId")
    def dependency_id(self) -> _builtins.str:
        """
        The ID of the dependency package corresponding to the version.
        """
        return pulumi.get(self, "dependency_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[_builtins.str]:
        """
        The runtime of the dependency package version.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.int]:
        """
        The dependency package version.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetFgsDependencyVersionsVersionResult']:
        """
        All dependency package versions that match the filter parameters.  
        The versions structure is documented below.
        """
        return pulumi.get(self, "versions")


class AwaitableGetFgsDependencyVersionsResult(GetFgsDependencyVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFgsDependencyVersionsResult(
            dependency_id=self.dependency_id,
            id=self.id,
            region=self.region,
            runtime=self.runtime,
            version=self.version,
            version_id=self.version_id,
            versions=self.versions)


def get_fgs_dependency_versions(dependency_id: Optional[_builtins.str] = None,
                                region: Optional[_builtins.str] = None,
                                runtime: Optional[_builtins.str] = None,
                                version: Optional[_builtins.int] = None,
                                version_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFgsDependencyVersionsResult:
    """
    Use this data source to get the list of dependency package versions within SberCloud.

    ## Example Usage

    ### Query all versions under a specified dependency package

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    dependency_id = config.require_object("dependencyId")
    test = sbercloud.get_fgs_dependency_versions(dependency_id=dependency_id)
    ```

    ### Query a specified dependency package version

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    dependency_id = config.require_object("dependencyId")
    version_name = config.require_object("versionName")
    test = sbercloud.get_fgs_dependency_versions(dependency_id=dependency_id,
        version=version_name)
    ```


    :param _builtins.str dependency_id: Specifies the ID of the dependency package to which the versions belong.
    :param _builtins.str region: Specifies the region where the dependency package and the versions are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str runtime: Specifies the runtime of the dependency package version.  
           The valid values are as follows:
           + **Java8**
           + **Java11**
           + **Node.js6.10**
           + **Node.js8.10**
           + **Node.js10.16**
           + **Node.js12.13**
           + **Node.js14.18**
           + **Python2.7**
           + **Python3.6**
           + **Python3.9**
           + **Go1.8**
           + **Go1.x**
           + **C#(.NET Core 2.0)**
           + **C#(.NET Core 2.1)**
           + **C#(.NET Core 3.1)**
           + **Custom**
           + **PHP 7.3**
           + **http**
    :param _builtins.int version: Specifies the version of the dependency package.
    :param _builtins.str version_id: Specifies the ID of the dependency package version.
    """
    __args__ = dict()
    __args__['dependencyId'] = dependency_id
    __args__['region'] = region
    __args__['runtime'] = runtime
    __args__['version'] = version
    __args__['versionId'] = version_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getFgsDependencyVersions:getFgsDependencyVersions', __args__, opts=opts, typ=GetFgsDependencyVersionsResult).value

    return AwaitableGetFgsDependencyVersionsResult(
        dependency_id=pulumi.get(__ret__, 'dependency_id'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        runtime=pulumi.get(__ret__, 'runtime'),
        version=pulumi.get(__ret__, 'version'),
        version_id=pulumi.get(__ret__, 'version_id'),
        versions=pulumi.get(__ret__, 'versions'))
def get_fgs_dependency_versions_output(dependency_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       runtime: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       version: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                       version_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFgsDependencyVersionsResult]:
    """
    Use this data source to get the list of dependency package versions within SberCloud.

    ## Example Usage

    ### Query all versions under a specified dependency package

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    dependency_id = config.require_object("dependencyId")
    test = sbercloud.get_fgs_dependency_versions(dependency_id=dependency_id)
    ```

    ### Query a specified dependency package version

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    dependency_id = config.require_object("dependencyId")
    version_name = config.require_object("versionName")
    test = sbercloud.get_fgs_dependency_versions(dependency_id=dependency_id,
        version=version_name)
    ```


    :param _builtins.str dependency_id: Specifies the ID of the dependency package to which the versions belong.
    :param _builtins.str region: Specifies the region where the dependency package and the versions are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str runtime: Specifies the runtime of the dependency package version.  
           The valid values are as follows:
           + **Java8**
           + **Java11**
           + **Node.js6.10**
           + **Node.js8.10**
           + **Node.js10.16**
           + **Node.js12.13**
           + **Node.js14.18**
           + **Python2.7**
           + **Python3.6**
           + **Python3.9**
           + **Go1.8**
           + **Go1.x**
           + **C#(.NET Core 2.0)**
           + **C#(.NET Core 2.1)**
           + **C#(.NET Core 3.1)**
           + **Custom**
           + **PHP 7.3**
           + **http**
    :param _builtins.int version: Specifies the version of the dependency package.
    :param _builtins.str version_id: Specifies the ID of the dependency package version.
    """
    __args__ = dict()
    __args__['dependencyId'] = dependency_id
    __args__['region'] = region
    __args__['runtime'] = runtime
    __args__['version'] = version
    __args__['versionId'] = version_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getFgsDependencyVersions:getFgsDependencyVersions', __args__, opts=opts, typ=GetFgsDependencyVersionsResult)
    return __ret__.apply(lambda __response__: GetFgsDependencyVersionsResult(
        dependency_id=pulumi.get(__response__, 'dependency_id'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        runtime=pulumi.get(__response__, 'runtime'),
        version=pulumi.get(__response__, 'version'),
        version_id=pulumi.get(__response__, 'version_id'),
        versions=pulumi.get(__response__, 'versions')))
