# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFgsFunctionEventsResult',
    'AwaitableGetFgsFunctionEventsResult',
    'get_fgs_function_events',
    'get_fgs_function_events_output',
]

@pulumi.output_type
class GetFgsFunctionEventsResult:
    """
    A collection of values returned by getFgsFunctionEvents.
    """
    def __init__(__self__, events=None, function_urn=None, id=None, region=None):
        if events and not isinstance(events, list):
            raise TypeError("Expected argument 'events' to be a list")
        pulumi.set(__self__, "events", events)
        if function_urn and not isinstance(function_urn, str):
            raise TypeError("Expected argument 'function_urn' to be a str")
        pulumi.set(__self__, "function_urn", function_urn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def events(self) -> Sequence['outputs.GetFgsFunctionEventsEventResult']:
        """
        All events that match the filter parameters.
        """
        return pulumi.get(self, "events")

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> _builtins.str:
        return pulumi.get(self, "function_urn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetFgsFunctionEventsResult(GetFgsFunctionEventsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFgsFunctionEventsResult(
            events=self.events,
            function_urn=self.function_urn,
            id=self.id,
            region=self.region)


def get_fgs_function_events(function_urn: Optional[_builtins.str] = None,
                            region: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFgsFunctionEventsResult:
    """
    Use this data source to get the list of function events within SberCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    function_urn = config.require_object("functionUrn")
    test = sbercloud.get_fgs_function_events(function_urn=function_urn)
    ```


    :param _builtins.str function_urn: Specifies the function URN to which the events belong.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['functionUrn'] = function_urn
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getFgsFunctionEvents:getFgsFunctionEvents', __args__, opts=opts, typ=GetFgsFunctionEventsResult).value

    return AwaitableGetFgsFunctionEventsResult(
        events=pulumi.get(__ret__, 'events'),
        function_urn=pulumi.get(__ret__, 'function_urn'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_fgs_function_events_output(function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                                   region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFgsFunctionEventsResult]:
    """
    Use this data source to get the list of function events within SberCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    function_urn = config.require_object("functionUrn")
    test = sbercloud.get_fgs_function_events(function_urn=function_urn)
    ```


    :param _builtins.str function_urn: Specifies the function URN to which the events belong.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['functionUrn'] = function_urn
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getFgsFunctionEvents:getFgsFunctionEvents', __args__, opts=opts, typ=GetFgsFunctionEventsResult)
    return __ret__.apply(lambda __response__: GetFgsFunctionEventsResult(
        events=pulumi.get(__response__, 'events'),
        function_urn=pulumi.get(__response__, 'function_urn'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
