# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFgsFunctionsResult',
    'AwaitableGetFgsFunctionsResult',
    'get_fgs_functions',
    'get_fgs_functions_output',
]

@pulumi.output_type
class GetFgsFunctionsResult:
    """
    A collection of values returned by getFgsFunctions.
    """
    def __init__(__self__, enterprise_project_id=None, functions=None, id=None, name=None, package_name=None, region=None, runtime=None, urn=None):
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if functions and not isinstance(functions, list):
            raise TypeError("Expected argument 'functions' to be a list")
        pulumi.set(__self__, "functions", functions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if package_name and not isinstance(package_name, str):
            raise TypeError("Expected argument 'package_name' to be a str")
        pulumi.set(__self__, "package_name", package_name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if runtime and not isinstance(runtime, str):
            raise TypeError("Expected argument 'runtime' to be a str")
        pulumi.set(__self__, "runtime", runtime)
        if urn and not isinstance(urn, str):
            raise TypeError("Expected argument 'urn' to be a str")
        pulumi.set(__self__, "urn", urn)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        The enterprise project ID to which the function belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def functions(self) -> Sequence['outputs.GetFgsFunctionsFunctionResult']:
        """
        All functions that match the filter parameters.  
        The functions structure is documented below.
        """
        return pulumi.get(self, "functions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The function name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packageName")
    def package_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "package_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[_builtins.str]:
        """
        The dependency package runtime of the function.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter
    def urn(self) -> Optional[_builtins.str]:
        """
        The function URN.
        """
        return pulumi.get(self, "urn")


class AwaitableGetFgsFunctionsResult(GetFgsFunctionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFgsFunctionsResult(
            enterprise_project_id=self.enterprise_project_id,
            functions=self.functions,
            id=self.id,
            name=self.name,
            package_name=self.package_name,
            region=self.region,
            runtime=self.runtime,
            urn=self.urn)


def get_fgs_functions(enterprise_project_id: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      package_name: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      runtime: Optional[_builtins.str] = None,
                      urn: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFgsFunctionsResult:
    """
    Use this data source to filter FGS functions within SberCloud.

    ## Example Usage

    ### Obtain all public functions

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.get_fgs_functions()
    ```

    ### Obtain specific public function by package name

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.get_fgs_functions(package_name="default")
    ```


    :param _builtins.str enterprise_project_id: Specifies the ID of the enterprise project to which the functions belong.
    :param _builtins.str name: Specifies the function name used to query the specified function.
    :param _builtins.str package_name: Specifies the package name used to query the functions.
    :param _builtins.str region: Specifies the region in which to obtain the functions.
           If omitted, the provider-level region will be used.
    :param _builtins.str runtime: Specifies the dependency package runtime used to query the functions.  
           The valid values are as follows:
           + **Java8**
           + **Java11**
           + **Node.js6.10**
           + **Node.js8.10**
           + **Node.js10.16**
           + **Node.js12.13**
           + **Node.js14.18**
           + **Node.js16.17**
           + **Node.js18.15**
           + **Python2.7**
           + **Python3.6**
           + **Python3.9**
           + **Python3.10**
           + **Go1.x**
           + **C#(.NET Core 2.1)**
           + **C#(.NET Core 3.1)**
           + **Custom**
           + **PHP7.3**
           + **http**
           + **Custom Image**
           + **Cangjie1.0**
    :param _builtins.str urn: Specifies the function URN used to query the specified function.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['packageName'] = package_name
    __args__['region'] = region
    __args__['runtime'] = runtime
    __args__['urn'] = urn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getFgsFunctions:getFgsFunctions', __args__, opts=opts, typ=GetFgsFunctionsResult).value

    return AwaitableGetFgsFunctionsResult(
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        functions=pulumi.get(__ret__, 'functions'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        package_name=pulumi.get(__ret__, 'package_name'),
        region=pulumi.get(__ret__, 'region'),
        runtime=pulumi.get(__ret__, 'runtime'),
        urn=pulumi.get(__ret__, 'urn'))
def get_fgs_functions_output(enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             package_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             runtime: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             urn: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFgsFunctionsResult]:
    """
    Use this data source to filter FGS functions within SberCloud.

    ## Example Usage

    ### Obtain all public functions

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.get_fgs_functions()
    ```

    ### Obtain specific public function by package name

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.get_fgs_functions(package_name="default")
    ```


    :param _builtins.str enterprise_project_id: Specifies the ID of the enterprise project to which the functions belong.
    :param _builtins.str name: Specifies the function name used to query the specified function.
    :param _builtins.str package_name: Specifies the package name used to query the functions.
    :param _builtins.str region: Specifies the region in which to obtain the functions.
           If omitted, the provider-level region will be used.
    :param _builtins.str runtime: Specifies the dependency package runtime used to query the functions.  
           The valid values are as follows:
           + **Java8**
           + **Java11**
           + **Node.js6.10**
           + **Node.js8.10**
           + **Node.js10.16**
           + **Node.js12.13**
           + **Node.js14.18**
           + **Node.js16.17**
           + **Node.js18.15**
           + **Python2.7**
           + **Python3.6**
           + **Python3.9**
           + **Python3.10**
           + **Go1.x**
           + **C#(.NET Core 2.1)**
           + **C#(.NET Core 3.1)**
           + **Custom**
           + **PHP7.3**
           + **http**
           + **Custom Image**
           + **Cangjie1.0**
    :param _builtins.str urn: Specifies the function URN used to query the specified function.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['packageName'] = package_name
    __args__['region'] = region
    __args__['runtime'] = runtime
    __args__['urn'] = urn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getFgsFunctions:getFgsFunctions', __args__, opts=opts, typ=GetFgsFunctionsResult)
    return __ret__.apply(lambda __response__: GetFgsFunctionsResult(
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        functions=pulumi.get(__response__, 'functions'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        package_name=pulumi.get(__response__, 'package_name'),
        region=pulumi.get(__response__, 'region'),
        runtime=pulumi.get(__response__, 'runtime'),
        urn=pulumi.get(__response__, 'urn')))
