# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVpnConnectionHealthChecksResult',
    'AwaitableGetVpnConnectionHealthChecksResult',
    'get_vpn_connection_health_checks',
    'get_vpn_connection_health_checks_output',
]

@pulumi.output_type
class GetVpnConnectionHealthChecksResult:
    """
    A collection of values returned by getVpnConnectionHealthChecks.
    """
    def __init__(__self__, connection_health_checks=None, connection_id=None, destination_ip=None, id=None, region=None, source_ip=None, status=None):
        if connection_health_checks and not isinstance(connection_health_checks, list):
            raise TypeError("Expected argument 'connection_health_checks' to be a list")
        pulumi.set(__self__, "connection_health_checks", connection_health_checks)
        if connection_id and not isinstance(connection_id, str):
            raise TypeError("Expected argument 'connection_id' to be a str")
        pulumi.set(__self__, "connection_id", connection_id)
        if destination_ip and not isinstance(destination_ip, str):
            raise TypeError("Expected argument 'destination_ip' to be a str")
        pulumi.set(__self__, "destination_ip", destination_ip)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if source_ip and not isinstance(source_ip, str):
            raise TypeError("Expected argument 'source_ip' to be a str")
        pulumi.set(__self__, "source_ip", source_ip)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="connectionHealthChecks")
    def connection_health_checks(self) -> Sequence['outputs.GetVpnConnectionHealthChecksConnectionHealthCheckResult']:
        """
        All resource connection health checks that match the filter parameters.
        The connection_health_checks structure is documented below.
        """
        return pulumi.get(self, "connection_health_checks")

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[_builtins.str]:
        """
        The connection ID of the connection health check.
        """
        return pulumi.get(self, "connection_id")

    @_builtins.property
    @pulumi.getter(name="destinationIp")
    def destination_ip(self) -> Optional[_builtins.str]:
        """
        The destination IP address of the VPN connection.
        """
        return pulumi.get(self, "destination_ip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[_builtins.str]:
        """
        The source IP address of the VPN connection.
        """
        return pulumi.get(self, "source_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the connection health check.
        """
        return pulumi.get(self, "status")


class AwaitableGetVpnConnectionHealthChecksResult(GetVpnConnectionHealthChecksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpnConnectionHealthChecksResult(
            connection_health_checks=self.connection_health_checks,
            connection_id=self.connection_id,
            destination_ip=self.destination_ip,
            id=self.id,
            region=self.region,
            source_ip=self.source_ip,
            status=self.status)


def get_vpn_connection_health_checks(connection_id: Optional[_builtins.str] = None,
                                     destination_ip: Optional[_builtins.str] = None,
                                     region: Optional[_builtins.str] = None,
                                     source_ip: Optional[_builtins.str] = None,
                                     status: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpnConnectionHealthChecksResult:
    """
    Manages a VPN connection health checks data source within SberCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    connection_id = config.require_object("connectionId")
    status = config.require_object("status")
    source_ip = config.require_object("sourceIp")
    destination_ip = config.require_object("destinationIp")
    services = sbercloud.get_vpn_connection_health_checks(connection_id=connection_id,
        status=status,
        source_ip=source_ip,
        destination_ip=destination_ip)
    ```


    :param _builtins.str connection_id: Specifies the ID of the VPN connection.
    :param _builtins.str destination_ip: Specifies the destination IP of the VPN connection health check.
    :param _builtins.str region: Specifies the region in which to obtain the VPN connection health check.
           If omitted, the provider-level region will be used.
    :param _builtins.str source_ip: Specifies the source IP of the VPN connection health check.
    :param _builtins.str status: Specifies the status of the VPN connection health check.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    __args__['destinationIp'] = destination_ip
    __args__['region'] = region
    __args__['sourceIp'] = source_ip
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getVpnConnectionHealthChecks:getVpnConnectionHealthChecks', __args__, opts=opts, typ=GetVpnConnectionHealthChecksResult).value

    return AwaitableGetVpnConnectionHealthChecksResult(
        connection_health_checks=pulumi.get(__ret__, 'connection_health_checks'),
        connection_id=pulumi.get(__ret__, 'connection_id'),
        destination_ip=pulumi.get(__ret__, 'destination_ip'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        source_ip=pulumi.get(__ret__, 'source_ip'),
        status=pulumi.get(__ret__, 'status'))
def get_vpn_connection_health_checks_output(connection_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            destination_ip: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            source_ip: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpnConnectionHealthChecksResult]:
    """
    Manages a VPN connection health checks data source within SberCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    connection_id = config.require_object("connectionId")
    status = config.require_object("status")
    source_ip = config.require_object("sourceIp")
    destination_ip = config.require_object("destinationIp")
    services = sbercloud.get_vpn_connection_health_checks(connection_id=connection_id,
        status=status,
        source_ip=source_ip,
        destination_ip=destination_ip)
    ```


    :param _builtins.str connection_id: Specifies the ID of the VPN connection.
    :param _builtins.str destination_ip: Specifies the destination IP of the VPN connection health check.
    :param _builtins.str region: Specifies the region in which to obtain the VPN connection health check.
           If omitted, the provider-level region will be used.
    :param _builtins.str source_ip: Specifies the source IP of the VPN connection health check.
    :param _builtins.str status: Specifies the status of the VPN connection health check.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    __args__['destinationIp'] = destination_ip
    __args__['region'] = region
    __args__['sourceIp'] = source_ip
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getVpnConnectionHealthChecks:getVpnConnectionHealthChecks', __args__, opts=opts, typ=GetVpnConnectionHealthChecksResult)
    return __ret__.apply(lambda __response__: GetVpnConnectionHealthChecksResult(
        connection_health_checks=pulumi.get(__response__, 'connection_health_checks'),
        connection_id=pulumi.get(__response__, 'connection_id'),
        destination_ip=pulumi.get(__response__, 'destination_ip'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        source_ip=pulumi.get(__response__, 'source_ip'),
        status=pulumi.get(__response__, 'status')))
