# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVpnConnectionsResult',
    'AwaitableGetVpnConnectionsResult',
    'get_vpn_connections',
    'get_vpn_connections_output',
]

@pulumi.output_type
class GetVpnConnectionsResult:
    """
    A collection of values returned by getVpnConnections.
    """
    def __init__(__self__, connection_id=None, connections=None, gateway_id=None, gateway_ip=None, id=None, name=None, region=None, status=None, vpn_type=None):
        if connection_id and not isinstance(connection_id, str):
            raise TypeError("Expected argument 'connection_id' to be a str")
        pulumi.set(__self__, "connection_id", connection_id)
        if connections and not isinstance(connections, list):
            raise TypeError("Expected argument 'connections' to be a list")
        pulumi.set(__self__, "connections", connections)
        if gateway_id and not isinstance(gateway_id, str):
            raise TypeError("Expected argument 'gateway_id' to be a str")
        pulumi.set(__self__, "gateway_id", gateway_id)
        if gateway_ip and not isinstance(gateway_ip, str):
            raise TypeError("Expected argument 'gateway_ip' to be a str")
        pulumi.set(__self__, "gateway_ip", gateway_ip)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpn_type and not isinstance(vpn_type, str):
            raise TypeError("Expected argument 'vpn_type' to be a str")
        pulumi.set(__self__, "vpn_type", vpn_type)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "connection_id")

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Sequence['outputs.GetVpnConnectionsConnectionResult']:
        """
        All resource connection that match the filter parameters.
        The connections structure is documented below.
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[_builtins.str]:
        """
        Indicates the gateway ID of the connection.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> Optional[_builtins.str]:
        """
        Indicates the gateway IP of the connection.
        """
        return pulumi.get(self, "gateway_ip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Indicates the name of the connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Indicates the status of the connection.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> Optional[_builtins.str]:
        """
        Indicates the VPN type of the connection.
        """
        return pulumi.get(self, "vpn_type")


class AwaitableGetVpnConnectionsResult(GetVpnConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpnConnectionsResult(
            connection_id=self.connection_id,
            connections=self.connections,
            gateway_id=self.gateway_id,
            gateway_ip=self.gateway_ip,
            id=self.id,
            name=self.name,
            region=self.region,
            status=self.status,
            vpn_type=self.vpn_type)


def get_vpn_connections(connection_id: Optional[_builtins.str] = None,
                        gateway_id: Optional[_builtins.str] = None,
                        gateway_ip: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        region: Optional[_builtins.str] = None,
                        status: Optional[_builtins.str] = None,
                        vpn_type: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpnConnectionsResult:
    """
    Use this data source to get a list of VPN connections.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    status = config.require_object("status")
    name = config.require_object("name")
    vpn_type = config.require_object("vpnType")
    gateway_id = config.require_object("gatewayId")
    gateway_ip = config.require_object("gatewayIp")
    services = sbercloud.get_vpn_connections(status=status,
        name=name,
        vpn_type=vpn_type,
        gateway_id=gateway_id,
        gateway_ip=gateway_ip)
    ```


    :param _builtins.str connection_id: Specifies the ID of the VPN connection.
    :param _builtins.str gateway_id: Specifies the gateway ID of the VPN connection.
    :param _builtins.str gateway_ip: Specifies the gateway IP of the VPN connection.
    :param _builtins.str name: Specifies the name of the VPN connection.
    :param _builtins.str region: Specifies the region in which to obtain the VPN customer gateways.
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the status of the VPN connection.
    :param _builtins.str vpn_type: Specifies the VPN type of the VPN connection.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    __args__['gatewayId'] = gateway_id
    __args__['gatewayIp'] = gateway_ip
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    __args__['vpnType'] = vpn_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:index/getVpnConnections:getVpnConnections', __args__, opts=opts, typ=GetVpnConnectionsResult).value

    return AwaitableGetVpnConnectionsResult(
        connection_id=pulumi.get(__ret__, 'connection_id'),
        connections=pulumi.get(__ret__, 'connections'),
        gateway_id=pulumi.get(__ret__, 'gateway_id'),
        gateway_ip=pulumi.get(__ret__, 'gateway_ip'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        vpn_type=pulumi.get(__ret__, 'vpn_type'))
def get_vpn_connections_output(connection_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               gateway_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               gateway_ip: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               vpn_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpnConnectionsResult]:
    """
    Use this data source to get a list of VPN connections.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    status = config.require_object("status")
    name = config.require_object("name")
    vpn_type = config.require_object("vpnType")
    gateway_id = config.require_object("gatewayId")
    gateway_ip = config.require_object("gatewayIp")
    services = sbercloud.get_vpn_connections(status=status,
        name=name,
        vpn_type=vpn_type,
        gateway_id=gateway_id,
        gateway_ip=gateway_ip)
    ```


    :param _builtins.str connection_id: Specifies the ID of the VPN connection.
    :param _builtins.str gateway_id: Specifies the gateway ID of the VPN connection.
    :param _builtins.str gateway_ip: Specifies the gateway IP of the VPN connection.
    :param _builtins.str name: Specifies the name of the VPN connection.
    :param _builtins.str region: Specifies the region in which to obtain the VPN customer gateways.
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the status of the VPN connection.
    :param _builtins.str vpn_type: Specifies the VPN type of the VPN connection.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    __args__['gatewayId'] = gateway_id
    __args__['gatewayIp'] = gateway_ip
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    __args__['vpnType'] = vpn_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:index/getVpnConnections:getVpnConnections', __args__, opts=opts, typ=GetVpnConnectionsResult)
    return __ret__.apply(lambda __response__: GetVpnConnectionsResult(
        connection_id=pulumi.get(__response__, 'connection_id'),
        connections=pulumi.get(__response__, 'connections'),
        gateway_id=pulumi.get(__response__, 'gateway_id'),
        gateway_ip=pulumi.get(__response__, 'gateway_ip'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        vpn_type=pulumi.get(__response__, 'vpn_type')))
