# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccessKeyArgs', 'AccessKey']

@pulumi.input_type
class AccessKeyArgs:
    def __init__(__self__, *,
                 user_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 pgp_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_file: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccessKey resource.
        :param pulumi.Input[_builtins.str] user_id: Specifies the ID of the user who is requesting to create an access key.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the access key.
        :param pulumi.Input[_builtins.str] pgp_key: Either a base-64 encoded PGP public key, or a keybase username in the form
               `keybase:some_person_that_exists`. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] secret_file: Specifies the file name that can save access key and access secret key.
               Defaults to *./credentials-{{user name}}.csv*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] status: Specifies the status of the access key. It must be *active* or *inactive*. Default value
               is *active*.
        """
        pulumi.set(__self__, "user_id", user_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if pgp_key is not None:
            pulumi.set(__self__, "pgp_key", pgp_key)
        if secret_file is not None:
            pulumi.set(__self__, "secret_file", secret_file)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the user who is requesting to create an access key.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the access key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="pgpKey")
    def pgp_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Either a base-64 encoded PGP public key, or a keybase username in the form
        `keybase:some_person_that_exists`. Changing this creates a new resource.
        """
        return pulumi.get(self, "pgp_key")

    @pgp_key.setter
    def pgp_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pgp_key", value)

    @_builtins.property
    @pulumi.getter(name="secretFile")
    def secret_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file name that can save access key and access secret key.
        Defaults to *./credentials-{{user name}}.csv*. Changing this creates a new resource.
        """
        return pulumi.get(self, "secret_file")

    @secret_file.setter
    def secret_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_file", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the status of the access key. It must be *active* or *inactive*. Default value
        is *active*.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _AccessKeyState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 pgp_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_file: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessKey resources.
        :param pulumi.Input[_builtins.str] create_time: The time when the access key was created.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the access key.
        :param pulumi.Input[_builtins.str] key_fingerprint: The fingerprint of the PGP key used to encrypt the secret
        :param pulumi.Input[_builtins.str] pgp_key: Either a base-64 encoded PGP public key, or a keybase username in the form
               `keybase:some_person_that_exists`. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] secret: The access secret key. Setting the value only when writing to `secret_file` failed.
        :param pulumi.Input[_builtins.str] secret_file: Specifies the file name that can save access key and access secret key.
               Defaults to *./credentials-{{user name}}.csv*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] status: Specifies the status of the access key. It must be *active* or *inactive*. Default value
               is *active*.
        :param pulumi.Input[_builtins.str] user_id: Specifies the ID of the user who is requesting to create an access key.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] user_name: The name of IAM user.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_secret is not None:
            pulumi.set(__self__, "encrypted_secret", encrypted_secret)
        if key_fingerprint is not None:
            pulumi.set(__self__, "key_fingerprint", key_fingerprint)
        if pgp_key is not None:
            pulumi.set(__self__, "pgp_key", pgp_key)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if secret_file is not None:
            pulumi.set(__self__, "secret_file", secret_file)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the access key was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the access key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptedSecret")
    def encrypted_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "encrypted_secret")

    @encrypted_secret.setter
    def encrypted_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypted_secret", value)

    @_builtins.property
    @pulumi.getter(name="keyFingerprint")
    def key_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fingerprint of the PGP key used to encrypt the secret
        """
        return pulumi.get(self, "key_fingerprint")

    @key_fingerprint.setter
    def key_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="pgpKey")
    def pgp_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Either a base-64 encoded PGP public key, or a keybase username in the form
        `keybase:some_person_that_exists`. Changing this creates a new resource.
        """
        return pulumi.get(self, "pgp_key")

    @pgp_key.setter
    def pgp_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pgp_key", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access secret key. Setting the value only when writing to `secret_file` failed.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret", value)

    @_builtins.property
    @pulumi.getter(name="secretFile")
    def secret_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file name that can save access key and access secret key.
        Defaults to *./credentials-{{user name}}.csv*. Changing this creates a new resource.
        """
        return pulumi.get(self, "secret_file")

    @secret_file.setter
    def secret_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_file", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the status of the access key. It must be *active* or *inactive*. Default value
        is *active*.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the user who is requesting to create an access key.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of IAM user.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("sbercloud:Iam/accessKey:AccessKey")
class AccessKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 pgp_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_file: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a permanent Access Key resource within SberCloud IAM service.

        > **NOTE:** You _must_ have admin privileges in your SberCloud cloud to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        user1 = sbercloud.iam.User("user_1",
            name="user_1",
            description="A user",
            password="password123!")
        key1 = sbercloud.iam.AccessKey("key_1", user_id=user1.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the access key.
        :param pulumi.Input[_builtins.str] pgp_key: Either a base-64 encoded PGP public key, or a keybase username in the form
               `keybase:some_person_that_exists`. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] secret_file: Specifies the file name that can save access key and access secret key.
               Defaults to *./credentials-{{user name}}.csv*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] status: Specifies the status of the access key. It must be *active* or *inactive*. Default value
               is *active*.
        :param pulumi.Input[_builtins.str] user_id: Specifies the ID of the user who is requesting to create an access key.
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a permanent Access Key resource within SberCloud IAM service.

        > **NOTE:** You _must_ have admin privileges in your SberCloud cloud to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        user1 = sbercloud.iam.User("user_1",
            name="user_1",
            description="A user",
            password="password123!")
        key1 = sbercloud.iam.AccessKey("key_1", user_id=user1.id)
        ```

        :param str resource_name: The name of the resource.
        :param AccessKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 pgp_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_file: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessKeyArgs.__new__(AccessKeyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["pgp_key"] = pgp_key
            __props__.__dict__["secret_file"] = secret_file
            __props__.__dict__["status"] = status
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["encrypted_secret"] = None
            __props__.__dict__["key_fingerprint"] = None
            __props__.__dict__["secret"] = None
            __props__.__dict__["user_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AccessKey, __self__).__init__(
            'sbercloud:Iam/accessKey:AccessKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            encrypted_secret: Optional[pulumi.Input[_builtins.str]] = None,
            key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            pgp_key: Optional[pulumi.Input[_builtins.str]] = None,
            secret: Optional[pulumi.Input[_builtins.str]] = None,
            secret_file: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccessKey':
        """
        Get an existing AccessKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The time when the access key was created.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the access key.
        :param pulumi.Input[_builtins.str] key_fingerprint: The fingerprint of the PGP key used to encrypt the secret
        :param pulumi.Input[_builtins.str] pgp_key: Either a base-64 encoded PGP public key, or a keybase username in the form
               `keybase:some_person_that_exists`. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] secret: The access secret key. Setting the value only when writing to `secret_file` failed.
        :param pulumi.Input[_builtins.str] secret_file: Specifies the file name that can save access key and access secret key.
               Defaults to *./credentials-{{user name}}.csv*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] status: Specifies the status of the access key. It must be *active* or *inactive*. Default value
               is *active*.
        :param pulumi.Input[_builtins.str] user_id: Specifies the ID of the user who is requesting to create an access key.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] user_name: The name of IAM user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessKeyState.__new__(_AccessKeyState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["encrypted_secret"] = encrypted_secret
        __props__.__dict__["key_fingerprint"] = key_fingerprint
        __props__.__dict__["pgp_key"] = pgp_key
        __props__.__dict__["secret"] = secret
        __props__.__dict__["secret_file"] = secret_file
        __props__.__dict__["status"] = status
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["user_name"] = user_name
        return AccessKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the access key was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the access key.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encryptedSecret")
    def encrypted_secret(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "encrypted_secret")

    @_builtins.property
    @pulumi.getter(name="keyFingerprint")
    def key_fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The fingerprint of the PGP key used to encrypt the secret
        """
        return pulumi.get(self, "key_fingerprint")

    @_builtins.property
    @pulumi.getter(name="pgpKey")
    def pgp_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Either a base-64 encoded PGP public key, or a keybase username in the form
        `keybase:some_person_that_exists`. Changing this creates a new resource.
        """
        return pulumi.get(self, "pgp_key")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Output[_builtins.str]:
        """
        The access secret key. Setting the value only when writing to `secret_file` failed.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter(name="secretFile")
    def secret_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the file name that can save access key and access secret key.
        Defaults to *./credentials-{{user name}}.csv*. Changing this creates a new resource.
        """
        return pulumi.get(self, "secret_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the status of the access key. It must be *active* or *inactive*. Default value
        is *active*.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the user who is requesting to create an access key.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of IAM user.
        """
        return pulumi.get(self, "user_name")

