# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgencyArgs', 'Agency']

@pulumi.input_type
class AgencyArgs:
    def __init__(__self__, *,
                 all_resources_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 delegated_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delegated_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_roles: Optional[pulumi.Input[Sequence[pulumi.Input['AgencyProjectRoleArgs']]]] = None):
        """
        The set of arguments for constructing a Agency resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] all_resources_roles: Specifies an array of one or more role names which stand for the permissions
               to be granted to agency on all resources, including those in enterprise projects, region-specific projects,
               and global services under your account.
        :param pulumi.Input[_builtins.str] delegated_domain_name: Specifies the name of delegated user domain. This parameter
               and `delegated_service_name` are alternative.
        :param pulumi.Input[_builtins.str] delegated_service_name: Specifies the name of delegated cloud service. The value must start
               with *op_svc_*, for example, *op_svc_obs*. This parameter and `delegated_domain_name` are alternative.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the agency. The value is a string of
               0 to 255 characters, excluding these characters: '__@#$%^&*<>\\\\__'.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_roles: Specifies an array of one or more role names which stand for the permissionis to be
               granted to agency on domain.
        :param pulumi.Input[_builtins.str] duration: Specifies the validity period of an agency. The valid value are *ONEDAY* and *FOREVER*
               , defaults to *FOREVER*.
        :param pulumi.Input[_builtins.str] name: Specifies the name of agency. The name is a string of 1 to 64 characters.
               Changing this will create a new agency.
        :param pulumi.Input[Sequence[pulumi.Input['AgencyProjectRoleArgs']]] project_roles: Specifies an array of one or more roles and projects which are used to grant
               permissions to agency on project. The structure is documented below.
        """
        if all_resources_roles is not None:
            pulumi.set(__self__, "all_resources_roles", all_resources_roles)
        if delegated_domain_name is not None:
            pulumi.set(__self__, "delegated_domain_name", delegated_domain_name)
        if delegated_service_name is not None:
            pulumi.set(__self__, "delegated_service_name", delegated_service_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_roles is not None:
            pulumi.set(__self__, "domain_roles", domain_roles)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_roles is not None:
            pulumi.set(__self__, "project_roles", project_roles)

    @_builtins.property
    @pulumi.getter(name="allResourcesRoles")
    def all_resources_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of one or more role names which stand for the permissions
        to be granted to agency on all resources, including those in enterprise projects, region-specific projects,
        and global services under your account.
        """
        return pulumi.get(self, "all_resources_roles")

    @all_resources_roles.setter
    def all_resources_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "all_resources_roles", value)

    @_builtins.property
    @pulumi.getter(name="delegatedDomainName")
    def delegated_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of delegated user domain. This parameter
        and `delegated_service_name` are alternative.
        """
        return pulumi.get(self, "delegated_domain_name")

    @delegated_domain_name.setter
    def delegated_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delegated_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="delegatedServiceName")
    def delegated_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of delegated cloud service. The value must start
        with *op_svc_*, for example, *op_svc_obs*. This parameter and `delegated_domain_name` are alternative.
        """
        return pulumi.get(self, "delegated_service_name")

    @delegated_service_name.setter
    def delegated_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delegated_service_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supplementary information about the agency. The value is a string of
        0 to 255 characters, excluding these characters: '__@#$%^&*<>\\\\__'.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainRoles")
    def domain_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of one or more role names which stand for the permissionis to be
        granted to agency on domain.
        """
        return pulumi.get(self, "domain_roles")

    @domain_roles.setter
    def domain_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "domain_roles", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the validity period of an agency. The valid value are *ONEDAY* and *FOREVER*
        , defaults to *FOREVER*.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of agency. The name is a string of 1 to 64 characters.
        Changing this will create a new agency.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectRoles")
    def project_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgencyProjectRoleArgs']]]]:
        """
        Specifies an array of one or more roles and projects which are used to grant
        permissions to agency on project. The structure is documented below.
        """
        return pulumi.get(self, "project_roles")

    @project_roles.setter
    def project_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgencyProjectRoleArgs']]]]):
        pulumi.set(self, "project_roles", value)


@pulumi.input_type
class _AgencyState:
    def __init__(__self__, *,
                 all_resources_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delegated_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delegated_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_roles: Optional[pulumi.Input[Sequence[pulumi.Input['AgencyProjectRoleArgs']]]] = None):
        """
        Input properties used for looking up and filtering Agency resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] all_resources_roles: Specifies an array of one or more role names which stand for the permissions
               to be granted to agency on all resources, including those in enterprise projects, region-specific projects,
               and global services under your account.
        :param pulumi.Input[_builtins.str] create_time: The time when the agency was created.
        :param pulumi.Input[_builtins.str] delegated_domain_name: Specifies the name of delegated user domain. This parameter
               and `delegated_service_name` are alternative.
        :param pulumi.Input[_builtins.str] delegated_service_name: Specifies the name of delegated cloud service. The value must start
               with *op_svc_*, for example, *op_svc_obs*. This parameter and `delegated_domain_name` are alternative.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the agency. The value is a string of
               0 to 255 characters, excluding these characters: '__@#$%^&*<>\\\\__'.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_roles: Specifies an array of one or more role names which stand for the permissionis to be
               granted to agency on domain.
        :param pulumi.Input[_builtins.str] duration: Specifies the validity period of an agency. The valid value are *ONEDAY* and *FOREVER*
               , defaults to *FOREVER*.
        :param pulumi.Input[_builtins.str] expire_time: The expiration time of agency.
        :param pulumi.Input[_builtins.str] name: Specifies the name of agency. The name is a string of 1 to 64 characters.
               Changing this will create a new agency.
        :param pulumi.Input[Sequence[pulumi.Input['AgencyProjectRoleArgs']]] project_roles: Specifies an array of one or more roles and projects which are used to grant
               permissions to agency on project. The structure is documented below.
        """
        if all_resources_roles is not None:
            pulumi.set(__self__, "all_resources_roles", all_resources_roles)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delegated_domain_name is not None:
            pulumi.set(__self__, "delegated_domain_name", delegated_domain_name)
        if delegated_service_name is not None:
            pulumi.set(__self__, "delegated_service_name", delegated_service_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_roles is not None:
            pulumi.set(__self__, "domain_roles", domain_roles)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_roles is not None:
            pulumi.set(__self__, "project_roles", project_roles)

    @_builtins.property
    @pulumi.getter(name="allResourcesRoles")
    def all_resources_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of one or more role names which stand for the permissions
        to be granted to agency on all resources, including those in enterprise projects, region-specific projects,
        and global services under your account.
        """
        return pulumi.get(self, "all_resources_roles")

    @all_resources_roles.setter
    def all_resources_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "all_resources_roles", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the agency was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="delegatedDomainName")
    def delegated_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of delegated user domain. This parameter
        and `delegated_service_name` are alternative.
        """
        return pulumi.get(self, "delegated_domain_name")

    @delegated_domain_name.setter
    def delegated_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delegated_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="delegatedServiceName")
    def delegated_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of delegated cloud service. The value must start
        with *op_svc_*, for example, *op_svc_obs*. This parameter and `delegated_domain_name` are alternative.
        """
        return pulumi.get(self, "delegated_service_name")

    @delegated_service_name.setter
    def delegated_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delegated_service_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supplementary information about the agency. The value is a string of
        0 to 255 characters, excluding these characters: '__@#$%^&*<>\\\\__'.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainRoles")
    def domain_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of one or more role names which stand for the permissionis to be
        granted to agency on domain.
        """
        return pulumi.get(self, "domain_roles")

    @domain_roles.setter
    def domain_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "domain_roles", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the validity period of an agency. The valid value are *ONEDAY* and *FOREVER*
        , defaults to *FOREVER*.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time of agency.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of agency. The name is a string of 1 to 64 characters.
        Changing this will create a new agency.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectRoles")
    def project_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgencyProjectRoleArgs']]]]:
        """
        Specifies an array of one or more roles and projects which are used to grant
        permissions to agency on project. The structure is documented below.
        """
        return pulumi.get(self, "project_roles")

    @project_roles.setter
    def project_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgencyProjectRoleArgs']]]]):
        pulumi.set(self, "project_roles", value)


@pulumi.type_token("sbercloud:Iam/agency:Agency")
class Agency(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_resources_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 delegated_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delegated_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgencyProjectRoleArgs', 'AgencyProjectRoleArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages an agency resource within SberCloud.

        ## Example Usage

        ### Delegate another SberCloud account to perform operations on your resources

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        agency = sbercloud.iam.Agency("agency",
            name="test_agency",
            description="test agency",
            delegated_domain_name="***",
            project_roles=[{
                "project": "ru-moscow-1",
                "roles": ["Tenant Administrator"],
            }],
            domain_roles=["VPC Administrator"])
        ```

        ### Delegate a cloud service to access your resources in other cloud services

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        agency = sbercloud.iam.Agency("agency",
            name="test_agency",
            description="test agency",
            delegated_service_name="op_svc_evs",
            project_roles=[{
                "project": "ru-moscow-1",
                "roles": ["SFS Administrator"],
            }],
            domain_roles=["KMS Administrator"])
        ```

        ## Import

        Agencies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Iam/agency:Agency agency 0b97661f9900f23f4fc2c00971ea4dc0
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] all_resources_roles: Specifies an array of one or more role names which stand for the permissions
               to be granted to agency on all resources, including those in enterprise projects, region-specific projects,
               and global services under your account.
        :param pulumi.Input[_builtins.str] delegated_domain_name: Specifies the name of delegated user domain. This parameter
               and `delegated_service_name` are alternative.
        :param pulumi.Input[_builtins.str] delegated_service_name: Specifies the name of delegated cloud service. The value must start
               with *op_svc_*, for example, *op_svc_obs*. This parameter and `delegated_domain_name` are alternative.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the agency. The value is a string of
               0 to 255 characters, excluding these characters: '__@#$%^&*<>\\\\__'.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_roles: Specifies an array of one or more role names which stand for the permissionis to be
               granted to agency on domain.
        :param pulumi.Input[_builtins.str] duration: Specifies the validity period of an agency. The valid value are *ONEDAY* and *FOREVER*
               , defaults to *FOREVER*.
        :param pulumi.Input[_builtins.str] name: Specifies the name of agency. The name is a string of 1 to 64 characters.
               Changing this will create a new agency.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgencyProjectRoleArgs', 'AgencyProjectRoleArgsDict']]]] project_roles: Specifies an array of one or more roles and projects which are used to grant
               permissions to agency on project. The structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AgencyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an agency resource within SberCloud.

        ## Example Usage

        ### Delegate another SberCloud account to perform operations on your resources

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        agency = sbercloud.iam.Agency("agency",
            name="test_agency",
            description="test agency",
            delegated_domain_name="***",
            project_roles=[{
                "project": "ru-moscow-1",
                "roles": ["Tenant Administrator"],
            }],
            domain_roles=["VPC Administrator"])
        ```

        ### Delegate a cloud service to access your resources in other cloud services

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        agency = sbercloud.iam.Agency("agency",
            name="test_agency",
            description="test agency",
            delegated_service_name="op_svc_evs",
            project_roles=[{
                "project": "ru-moscow-1",
                "roles": ["SFS Administrator"],
            }],
            domain_roles=["KMS Administrator"])
        ```

        ## Import

        Agencies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Iam/agency:Agency agency 0b97661f9900f23f4fc2c00971ea4dc0
        ```

        :param str resource_name: The name of the resource.
        :param AgencyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgencyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_resources_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 delegated_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delegated_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgencyProjectRoleArgs', 'AgencyProjectRoleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgencyArgs.__new__(AgencyArgs)

            __props__.__dict__["all_resources_roles"] = all_resources_roles
            __props__.__dict__["delegated_domain_name"] = delegated_domain_name
            __props__.__dict__["delegated_service_name"] = delegated_service_name
            __props__.__dict__["description"] = description
            __props__.__dict__["domain_roles"] = domain_roles
            __props__.__dict__["duration"] = duration
            __props__.__dict__["name"] = name
            __props__.__dict__["project_roles"] = project_roles
            __props__.__dict__["create_time"] = None
            __props__.__dict__["expire_time"] = None
        super(Agency, __self__).__init__(
            'sbercloud:Iam/agency:Agency',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_resources_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            delegated_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            delegated_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            domain_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            duration: Optional[pulumi.Input[_builtins.str]] = None,
            expire_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgencyProjectRoleArgs', 'AgencyProjectRoleArgsDict']]]]] = None) -> 'Agency':
        """
        Get an existing Agency resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] all_resources_roles: Specifies an array of one or more role names which stand for the permissions
               to be granted to agency on all resources, including those in enterprise projects, region-specific projects,
               and global services under your account.
        :param pulumi.Input[_builtins.str] create_time: The time when the agency was created.
        :param pulumi.Input[_builtins.str] delegated_domain_name: Specifies the name of delegated user domain. This parameter
               and `delegated_service_name` are alternative.
        :param pulumi.Input[_builtins.str] delegated_service_name: Specifies the name of delegated cloud service. The value must start
               with *op_svc_*, for example, *op_svc_obs*. This parameter and `delegated_domain_name` are alternative.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the agency. The value is a string of
               0 to 255 characters, excluding these characters: '__@#$%^&*<>\\\\__'.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_roles: Specifies an array of one or more role names which stand for the permissionis to be
               granted to agency on domain.
        :param pulumi.Input[_builtins.str] duration: Specifies the validity period of an agency. The valid value are *ONEDAY* and *FOREVER*
               , defaults to *FOREVER*.
        :param pulumi.Input[_builtins.str] expire_time: The expiration time of agency.
        :param pulumi.Input[_builtins.str] name: Specifies the name of agency. The name is a string of 1 to 64 characters.
               Changing this will create a new agency.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgencyProjectRoleArgs', 'AgencyProjectRoleArgsDict']]]] project_roles: Specifies an array of one or more roles and projects which are used to grant
               permissions to agency on project. The structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgencyState.__new__(_AgencyState)

        __props__.__dict__["all_resources_roles"] = all_resources_roles
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delegated_domain_name"] = delegated_domain_name
        __props__.__dict__["delegated_service_name"] = delegated_service_name
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_roles"] = domain_roles
        __props__.__dict__["duration"] = duration
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["name"] = name
        __props__.__dict__["project_roles"] = project_roles
        return Agency(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allResourcesRoles")
    def all_resources_roles(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies an array of one or more role names which stand for the permissions
        to be granted to agency on all resources, including those in enterprise projects, region-specific projects,
        and global services under your account.
        """
        return pulumi.get(self, "all_resources_roles")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the agency was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="delegatedDomainName")
    def delegated_domain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of delegated user domain. This parameter
        and `delegated_service_name` are alternative.
        """
        return pulumi.get(self, "delegated_domain_name")

    @_builtins.property
    @pulumi.getter(name="delegatedServiceName")
    def delegated_service_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of delegated cloud service. The value must start
        with *op_svc_*, for example, *op_svc_obs*. This parameter and `delegated_domain_name` are alternative.
        """
        return pulumi.get(self, "delegated_service_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supplementary information about the agency. The value is a string of
        0 to 255 characters, excluding these characters: '__@#$%^&*<>\\\\__'.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainRoles")
    def domain_roles(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies an array of one or more role names which stand for the permissionis to be
        granted to agency on domain.
        """
        return pulumi.get(self, "domain_roles")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the validity period of an agency. The valid value are *ONEDAY* and *FOREVER*
        , defaults to *FOREVER*.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[_builtins.str]:
        """
        The expiration time of agency.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of agency. The name is a string of 1 to 64 characters.
        Changing this will create a new agency.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectRoles")
    def project_roles(self) -> pulumi.Output[Optional[Sequence['outputs.AgencyProjectRole']]]:
        """
        Specifies an array of one or more roles and projects which are used to grant
        permissions to agency on project. The structure is documented below.
        """
        return pulumi.get(self, "project_roles")

