# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCustomRoleResult',
    'AwaitableGetCustomRoleResult',
    'get_custom_role',
    'get_custom_role_output',
]

@pulumi.output_type
class GetCustomRoleResult:
    """
    A collection of values returned by getCustomRole.
    """
    def __init__(__self__, catalog=None, description=None, domain_id=None, id=None, name=None, policy=None, references=None, type=None):
        if catalog and not isinstance(catalog, str):
            raise TypeError("Expected argument 'catalog' to be a str")
        pulumi.set(__self__, "catalog", catalog)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)
        if references and not isinstance(references, int):
            raise TypeError("Expected argument 'references' to be a int")
        pulumi.set(__self__, "references", references)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def catalog(self) -> _builtins.str:
        """
        The catalog of the custom policy.
        """
        return pulumi.get(self, "catalog")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> _builtins.str:
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        Document of the custom policy.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def references(self) -> _builtins.int:
        return pulumi.get(self, "references")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


class AwaitableGetCustomRoleResult(GetCustomRoleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomRoleResult(
            catalog=self.catalog,
            description=self.description,
            domain_id=self.domain_id,
            id=self.id,
            name=self.name,
            policy=self.policy,
            references=self.references,
            type=self.type)


def get_custom_role(description: Optional[_builtins.str] = None,
                    domain_id: Optional[_builtins.str] = None,
                    id: Optional[_builtins.str] = None,
                    name: Optional[_builtins.str] = None,
                    references: Optional[_builtins.int] = None,
                    type: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomRoleResult:
    """
    Use this data source to get the ID of an IAM **custom policy**.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    role = sbercloud.Iam.get_custom_role(name="custom_role")
    ```


    :param _builtins.str description: Description of the custom policy.
    :param _builtins.str domain_id: The domain the policy belongs to.
    :param _builtins.str id: ID of the custom policy.
    :param _builtins.str name: Name of the custom policy.
    :param _builtins.int references: The number of citations for the custom policy.
    :param _builtins.str type: Display mode. Valid options are _AX_: Account level and _XA_: Project level.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['domainId'] = domain_id
    __args__['id'] = id
    __args__['name'] = name
    __args__['references'] = references
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Iam/getCustomRole:getCustomRole', __args__, opts=opts, typ=GetCustomRoleResult).value

    return AwaitableGetCustomRoleResult(
        catalog=pulumi.get(__ret__, 'catalog'),
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        policy=pulumi.get(__ret__, 'policy'),
        references=pulumi.get(__ret__, 'references'),
        type=pulumi.get(__ret__, 'type'))
def get_custom_role_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           domain_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           references: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                           type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomRoleResult]:
    """
    Use this data source to get the ID of an IAM **custom policy**.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    role = sbercloud.Iam.get_custom_role(name="custom_role")
    ```


    :param _builtins.str description: Description of the custom policy.
    :param _builtins.str domain_id: The domain the policy belongs to.
    :param _builtins.str id: ID of the custom policy.
    :param _builtins.str name: Name of the custom policy.
    :param _builtins.int references: The number of citations for the custom policy.
    :param _builtins.str type: Display mode. Valid options are _AX_: Account level and _XA_: Project level.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['domainId'] = domain_id
    __args__['id'] = id
    __args__['name'] = name
    __args__['references'] = references
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Iam/getCustomRole:getCustomRole', __args__, opts=opts, typ=GetCustomRoleResult)
    return __ret__.apply(lambda __response__: GetCustomRoleResult(
        catalog=pulumi.get(__response__, 'catalog'),
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        policy=pulumi.get(__response__, 'policy'),
        references=pulumi.get(__response__, 'references'),
        type=pulumi.get(__response__, 'type')))
