# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGroupResult',
    'AwaitableGetGroupResult',
    'get_group',
    'get_group_output',
]

@pulumi.output_type
class GetGroupResult:
    """
    A collection of values returned by getGroup.
    """
    def __init__(__self__, description=None, domain_id=None, id=None, name=None, users=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Indicates the description of the IAM user.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> _builtins.str:
        """
        Indicates the domain the group belongs to.
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Indicates the ID of the User.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Indicates the IAM user name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetGroupUserResult']:
        """
        Indicates the users the group contains. Structure is documented below.
        """
        return pulumi.get(self, "users")


class AwaitableGetGroupResult(GetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupResult(
            description=self.description,
            domain_id=self.domain_id,
            id=self.id,
            name=self.name,
            users=self.users)


def get_group(description: Optional[_builtins.str] = None,
              id: Optional[_builtins.str] = None,
              name: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupResult:
    """
    Use this data source to get details of the specified IAM user group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    group = sbercloud.Iam.get_group(name="my_group")
    ```


    :param _builtins.str description: Specifies the description of the identity group.
    :param _builtins.str id: Specifies the ID of the identity group.
    :param _builtins.str name: Specifies the name of the identity group.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Iam/getGroup:getGroup', __args__, opts=opts, typ=GetGroupResult).value

    return AwaitableGetGroupResult(
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        users=pulumi.get(__ret__, 'users'))
def get_group_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupResult]:
    """
    Use this data source to get details of the specified IAM user group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    group = sbercloud.Iam.get_group(name="my_group")
    ```


    :param _builtins.str description: Specifies the description of the identity group.
    :param _builtins.str id: Specifies the ID of the identity group.
    :param _builtins.str name: Specifies the name of the identity group.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Iam/getGroup:getGroup', __args__, opts=opts, typ=GetGroupResult)
    return __ret__.apply(lambda __response__: GetGroupResult(
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        users=pulumi.get(__response__, 'users')))
