# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRoleResult',
    'AwaitableGetRoleResult',
    'get_role',
    'get_role_output',
]

@pulumi.output_type
class GetRoleResult:
    """
    A collection of values returned by getRole.
    """
    def __init__(__self__, catalog=None, description=None, display_name=None, id=None, name=None, policy=None, type=None):
        if catalog and not isinstance(catalog, str):
            raise TypeError("Expected argument 'catalog' to be a str")
        pulumi.set(__self__, "catalog", catalog)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def catalog(self) -> _builtins.str:
        """
        The service catalog of the policy.
        """
        return pulumi.get(self, "catalog")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The content of the policy.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The display mode of the policy.
        """
        return pulumi.get(self, "type")


class AwaitableGetRoleResult(GetRoleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoleResult(
            catalog=self.catalog,
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            name=self.name,
            policy=self.policy,
            type=self.type)


def get_role(display_name: Optional[_builtins.str] = None,
             name: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoleResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    auth_admin = sbercloud.Iam.get_role(name="secu_admin")
    ```


    :param _builtins.str display_name: Specifies the display name of the role displayed on the console.
           It is recommended to use this parameter instead of `name` and required if `name` is not specified.
    :param _builtins.str name: Specifies the name of the role for internal use.
           It's required if `display_name` is not specified.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Iam/getRole:getRole', __args__, opts=opts, typ=GetRoleResult).value

    return AwaitableGetRoleResult(
        catalog=pulumi.get(__ret__, 'catalog'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        policy=pulumi.get(__ret__, 'policy'),
        type=pulumi.get(__ret__, 'type'))
def get_role_output(display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRoleResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    auth_admin = sbercloud.Iam.get_role(name="secu_admin")
    ```


    :param _builtins.str display_name: Specifies the display name of the role displayed on the console.
           It is recommended to use this parameter instead of `name` and required if `name` is not specified.
    :param _builtins.str name: Specifies the name of the role for internal use.
           It's required if `display_name` is not specified.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Iam/getRole:getRole', __args__, opts=opts, typ=GetRoleResult)
    return __ret__.apply(lambda __response__: GetRoleResult(
        catalog=pulumi.get(__response__, 'catalog'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        policy=pulumi.get(__response__, 'policy'),
        type=pulumi.get(__response__, 'type')))
