# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GroupMembershipArgs', 'GroupMembership']

@pulumi.input_type
class GroupMembershipArgs:
    def __init__(__self__, *,
                 group: pulumi.Input[_builtins.str],
                 users: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a GroupMembership resource.
        :param pulumi.Input[_builtins.str] group: The group ID of this membership.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: A List of user IDs to associate to the group.
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Input[_builtins.str]:
        """
        The group ID of this membership.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A List of user IDs to associate to the group.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _GroupMembershipState:
    def __init__(__self__, *,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering GroupMembership resources.
        :param pulumi.Input[_builtins.str] group: The group ID of this membership.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: A List of user IDs to associate to the group.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group ID of this membership.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A List of user IDs to associate to the group.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "users", value)


@pulumi.type_token("sbercloud:Iam/groupMembership:GroupMembership")
class GroupMembership(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a User Group Membership resource within SberCloud IAM service.

        Note: You _must_ have admin privileges in your SberCloud cloud to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        group1 = sbercloud.iam.Group("group_1",
            name="group1",
            description="This is a test group")
        user1 = sbercloud.iam.User("user_1",
            name="user1",
            enabled=True,
            password="password12345!")
        user2 = sbercloud.iam.User("user_2",
            name="user2",
            enabled=True,
            password="password12345!")
        membership1 = sbercloud.iam.GroupMembership("membership_1",
            group=group1.id,
            users=[
                user1.id,
                user2.id,
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group: The group ID of this membership.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: A List of user IDs to associate to the group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupMembershipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a User Group Membership resource within SberCloud IAM service.

        Note: You _must_ have admin privileges in your SberCloud cloud to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        group1 = sbercloud.iam.Group("group_1",
            name="group1",
            description="This is a test group")
        user1 = sbercloud.iam.User("user_1",
            name="user1",
            enabled=True,
            password="password12345!")
        user2 = sbercloud.iam.User("user_2",
            name="user2",
            enabled=True,
            password="password12345!")
        membership1 = sbercloud.iam.GroupMembership("membership_1",
            group=group1.id,
            users=[
                user1.id,
                user2.id,
            ])
        ```

        :param str resource_name: The name of the resource.
        :param GroupMembershipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupMembershipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupMembershipArgs.__new__(GroupMembershipArgs)

            if group is None and not opts.urn:
                raise TypeError("Missing required property 'group'")
            __props__.__dict__["group"] = group
            if users is None and not opts.urn:
                raise TypeError("Missing required property 'users'")
            __props__.__dict__["users"] = users
        super(GroupMembership, __self__).__init__(
            'sbercloud:Iam/groupMembership:GroupMembership',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group: Optional[pulumi.Input[_builtins.str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'GroupMembership':
        """
        Get an existing GroupMembership resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group: The group ID of this membership.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: A List of user IDs to associate to the group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupMembershipState.__new__(_GroupMembershipState)

        __props__.__dict__["group"] = group
        __props__.__dict__["users"] = users
        return GroupMembership(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Output[_builtins.str]:
        """
        The group ID of this membership.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A List of user IDs to associate to the group.
        """
        return pulumi.get(self, "users")

