# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProviderConversionArgs', 'ProviderConversion']

@pulumi.input_type
class ProviderConversionArgs:
    def __init__(__self__, *,
                 conversion_rules: pulumi.Input[Sequence[pulumi.Input['ProviderConversionConversionRuleArgs']]],
                 provider_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ProviderConversion resource.
        :param pulumi.Input[Sequence[pulumi.Input['ProviderConversionConversionRuleArgs']]] conversion_rules: Specifies the identity conversion rules of the identity provider.
               You can use identity conversion rules to map the identities of existing users to Huawei Cloud and manage their access
               to cloud resources.
               The object structure is documented below.
               
               <a name="conversion_rules"></a>
               The `conversion_rules` block supports:
        :param pulumi.Input[_builtins.str] provider_id: The ID of the identity provider used to manage the conversion rules.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "conversion_rules", conversion_rules)
        pulumi.set(__self__, "provider_id", provider_id)

    @_builtins.property
    @pulumi.getter(name="conversionRules")
    def conversion_rules(self) -> pulumi.Input[Sequence[pulumi.Input['ProviderConversionConversionRuleArgs']]]:
        """
        Specifies the identity conversion rules of the identity provider.
        You can use identity conversion rules to map the identities of existing users to Huawei Cloud and manage their access
        to cloud resources.
        The object structure is documented below.

        <a name="conversion_rules"></a>
        The `conversion_rules` block supports:
        """
        return pulumi.get(self, "conversion_rules")

    @conversion_rules.setter
    def conversion_rules(self, value: pulumi.Input[Sequence[pulumi.Input['ProviderConversionConversionRuleArgs']]]):
        pulumi.set(self, "conversion_rules", value)

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the identity provider used to manage the conversion rules.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provider_id", value)


@pulumi.input_type
class _ProviderConversionState:
    def __init__(__self__, *,
                 conversion_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderConversionConversionRuleArgs']]]] = None,
                 provider_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProviderConversion resources.
        :param pulumi.Input[Sequence[pulumi.Input['ProviderConversionConversionRuleArgs']]] conversion_rules: Specifies the identity conversion rules of the identity provider.
               You can use identity conversion rules to map the identities of existing users to Huawei Cloud and manage their access
               to cloud resources.
               The object structure is documented below.
               
               <a name="conversion_rules"></a>
               The `conversion_rules` block supports:
        :param pulumi.Input[_builtins.str] provider_id: The ID of the identity provider used to manage the conversion rules.
               Changing this parameter will create a new resource.
        """
        if conversion_rules is not None:
            pulumi.set(__self__, "conversion_rules", conversion_rules)
        if provider_id is not None:
            pulumi.set(__self__, "provider_id", provider_id)

    @_builtins.property
    @pulumi.getter(name="conversionRules")
    def conversion_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderConversionConversionRuleArgs']]]]:
        """
        Specifies the identity conversion rules of the identity provider.
        You can use identity conversion rules to map the identities of existing users to Huawei Cloud and manage their access
        to cloud resources.
        The object structure is documented below.

        <a name="conversion_rules"></a>
        The `conversion_rules` block supports:
        """
        return pulumi.get(self, "conversion_rules")

    @conversion_rules.setter
    def conversion_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderConversionConversionRuleArgs']]]]):
        pulumi.set(self, "conversion_rules", value)

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the identity provider used to manage the conversion rules.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_id", value)


@pulumi.type_token("sbercloud:Iam/providerConversion:ProviderConversion")
class ProviderConversion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conversion_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderConversionConversionRuleArgs', 'ProviderConversionConversionRuleArgsDict']]]]] = None,
                 provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage the conversion rules of identity provider within SberCloud IAM service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        provider_id = config.require_object("providerId")
        conversion = sbercloud.iam.ProviderConversion("conversion",
            provider_id=provider_id,
            conversion_rules=[
                {
                    "locals": [{
                        "username": "Tom",
                    }],
                    "remotes": [{
                        "attribute": "Tom",
                    }],
                },
                {
                    "locals": [{
                        "username": "FederationUser",
                    }],
                    "remotes": [{
                        "attribute": "username",
                        "condition": "any_one_of",
                        "values": [
                            "Tom",
                            "Jerry",
                        ],
                    }],
                },
            ])
        ```

        <!--markdownlint-disable MD033-->

        ## Import

        Identity provider conversion rules are imported using the `provider_id`, e.g.

        ```sh
        $ pulumi import sbercloud:Iam/providerConversion:ProviderConversion conversion example_com_provider_oidc
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProviderConversionConversionRuleArgs', 'ProviderConversionConversionRuleArgsDict']]]] conversion_rules: Specifies the identity conversion rules of the identity provider.
               You can use identity conversion rules to map the identities of existing users to Huawei Cloud and manage their access
               to cloud resources.
               The object structure is documented below.
               
               <a name="conversion_rules"></a>
               The `conversion_rules` block supports:
        :param pulumi.Input[_builtins.str] provider_id: The ID of the identity provider used to manage the conversion rules.
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProviderConversionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage the conversion rules of identity provider within SberCloud IAM service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        provider_id = config.require_object("providerId")
        conversion = sbercloud.iam.ProviderConversion("conversion",
            provider_id=provider_id,
            conversion_rules=[
                {
                    "locals": [{
                        "username": "Tom",
                    }],
                    "remotes": [{
                        "attribute": "Tom",
                    }],
                },
                {
                    "locals": [{
                        "username": "FederationUser",
                    }],
                    "remotes": [{
                        "attribute": "username",
                        "condition": "any_one_of",
                        "values": [
                            "Tom",
                            "Jerry",
                        ],
                    }],
                },
            ])
        ```

        <!--markdownlint-disable MD033-->

        ## Import

        Identity provider conversion rules are imported using the `provider_id`, e.g.

        ```sh
        $ pulumi import sbercloud:Iam/providerConversion:ProviderConversion conversion example_com_provider_oidc
        ```

        :param str resource_name: The name of the resource.
        :param ProviderConversionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderConversionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conversion_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderConversionConversionRuleArgs', 'ProviderConversionConversionRuleArgsDict']]]]] = None,
                 provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderConversionArgs.__new__(ProviderConversionArgs)

            if conversion_rules is None and not opts.urn:
                raise TypeError("Missing required property 'conversion_rules'")
            __props__.__dict__["conversion_rules"] = conversion_rules
            if provider_id is None and not opts.urn:
                raise TypeError("Missing required property 'provider_id'")
            __props__.__dict__["provider_id"] = provider_id
        super(ProviderConversion, __self__).__init__(
            'sbercloud:Iam/providerConversion:ProviderConversion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            conversion_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderConversionConversionRuleArgs', 'ProviderConversionConversionRuleArgsDict']]]]] = None,
            provider_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProviderConversion':
        """
        Get an existing ProviderConversion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProviderConversionConversionRuleArgs', 'ProviderConversionConversionRuleArgsDict']]]] conversion_rules: Specifies the identity conversion rules of the identity provider.
               You can use identity conversion rules to map the identities of existing users to Huawei Cloud and manage their access
               to cloud resources.
               The object structure is documented below.
               
               <a name="conversion_rules"></a>
               The `conversion_rules` block supports:
        :param pulumi.Input[_builtins.str] provider_id: The ID of the identity provider used to manage the conversion rules.
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProviderConversionState.__new__(_ProviderConversionState)

        __props__.__dict__["conversion_rules"] = conversion_rules
        __props__.__dict__["provider_id"] = provider_id
        return ProviderConversion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="conversionRules")
    def conversion_rules(self) -> pulumi.Output[Sequence['outputs.ProviderConversionConversionRule']]:
        """
        Specifies the identity conversion rules of the identity provider.
        You can use identity conversion rules to map the identities of existing users to Huawei Cloud and manage their access
        to cloud resources.
        The object structure is documented below.

        <a name="conversion_rules"></a>
        The `conversion_rules` block supports:
        """
        return pulumi.get(self, "conversion_rules")

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the identity provider used to manage the conversion rules.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "provider_id")

