# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RoleArgs', 'Role']

@pulumi.input_type
class RoleArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 policy: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Role resource.
        :param pulumi.Input[_builtins.str] description: Description of the custom policy.
        :param pulumi.Input[_builtins.str] policy: Document of the custom policy in JSON format.
        :param pulumi.Input[_builtins.str] type: Display mode. Valid options are _AX_: Account level and _XA_: Project level.
        :param pulumi.Input[_builtins.str] name: Name of the custom policy.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        Description of the custom policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Input[_builtins.str]:
        """
        Document of the custom policy in JSON format.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Display mode. Valid options are _AX_: Account level and _XA_: Project level.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the custom policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RoleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 references: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Role resources.
        :param pulumi.Input[_builtins.str] description: Description of the custom policy.
        :param pulumi.Input[_builtins.str] name: Name of the custom policy.
        :param pulumi.Input[_builtins.str] policy: Document of the custom policy in JSON format.
        :param pulumi.Input[_builtins.int] references: The number of references.
        :param pulumi.Input[_builtins.str] type: Display mode. Valid options are _AX_: Account level and _XA_: Project level.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if references is not None:
            pulumi.set(__self__, "references", references)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the custom policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the custom policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Document of the custom policy in JSON format.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def references(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of references.
        """
        return pulumi.get(self, "references")

    @references.setter
    def references(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "references", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display mode. Valid options are _AX_: Account level and _XA_: Project level.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("sbercloud:Iam/role:Role")
class Role(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a **Custom Policy** resource within SberCloud IAM service.

        ->**Note** You _must_ have admin privileges in your SberCloud cloud to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        role1 = sbercloud.iam.Role("role1",
            name="test",
            description="created by terraform",
            type="AX",
            policy=\"\"\"{
          "Version": "1.1",
          "Statement": [
            {
              "Action": [
                "obs:bucket:GetBucketAcl"
              ],
              "Effect": "Allow",
              "Resource": [
                "obs:*:*:bucket:*"
              ],
              "Condition": {
                "StringStartWith": {
                  "g:ProjectName": [
                    "ru-moscow-1"
                  ]
                }
              }
            }
          ]
        }
        \"\"\")
        ```

        ## Import

        Roles can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Iam/role:Role role1 89c60255-9bd6-460c-822a-e2b959ede9d2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the custom policy.
        :param pulumi.Input[_builtins.str] name: Name of the custom policy.
        :param pulumi.Input[_builtins.str] policy: Document of the custom policy in JSON format.
        :param pulumi.Input[_builtins.str] type: Display mode. Valid options are _AX_: Account level and _XA_: Project level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a **Custom Policy** resource within SberCloud IAM service.

        ->**Note** You _must_ have admin privileges in your SberCloud cloud to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        role1 = sbercloud.iam.Role("role1",
            name="test",
            description="created by terraform",
            type="AX",
            policy=\"\"\"{
          "Version": "1.1",
          "Statement": [
            {
              "Action": [
                "obs:bucket:GetBucketAcl"
              ],
              "Effect": "Allow",
              "Resource": [
                "obs:*:*:bucket:*"
              ],
              "Condition": {
                "StringStartWith": {
                  "g:ProjectName": [
                    "ru-moscow-1"
                  ]
                }
              }
            }
          ]
        }
        \"\"\")
        ```

        ## Import

        Roles can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Iam/role:Role role1 89c60255-9bd6-460c-822a-e2b959ede9d2
        ```

        :param str resource_name: The name of the resource.
        :param RoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleArgs.__new__(RoleArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["references"] = None
        super(Role, __self__).__init__(
            'sbercloud:Iam/role:Role',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy: Optional[pulumi.Input[_builtins.str]] = None,
            references: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Role':
        """
        Get an existing Role resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the custom policy.
        :param pulumi.Input[_builtins.str] name: Name of the custom policy.
        :param pulumi.Input[_builtins.str] policy: Document of the custom policy in JSON format.
        :param pulumi.Input[_builtins.int] references: The number of references.
        :param pulumi.Input[_builtins.str] type: Display mode. Valid options are _AX_: Account level and _XA_: Project level.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleState.__new__(_RoleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["policy"] = policy
        __props__.__dict__["references"] = references
        __props__.__dict__["type"] = type
        return Role(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the custom policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the custom policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[_builtins.str]:
        """
        Document of the custom policy in JSON format.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def references(self) -> pulumi.Output[_builtins.int]:
        """
        The number of references.
        """
        return pulumi.get(self, "references")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Display mode. Valid options are _AX_: Account level and _XA_: Project level.
        """
        return pulumi.get(self, "type")

