# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_identity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 login_protect_verification_method: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 phone: Optional[pulumi.Input[_builtins.str]] = None,
                 pwd_reset: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[_builtins.str] access_type: Specifies the access type of the user. Available values are:
               + default: support both programmatic and management console access.
               + programmatic: only support programmatic access.
               + console: only support management console access.
        :param pulumi.Input[_builtins.str] country_code: Specifies the country code. The country code of the Chinese mainland is 0086. This
               parameter must be used together with `phone`.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the user.
        :param pulumi.Input[_builtins.str] email: Specifies the email address with a maximum of 255 characters.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether the user is enabled or disabled. Valid values are `true` and `false`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the user. The user name consists of 5 to 32 characters. It can
               contain only uppercase letters, lowercase letters, digits, spaces, and special characters (-_) and cannot start with a
               digit.
        :param pulumi.Input[_builtins.str] password: Specifies the password for the user with 6 to 32 characters. It must contain at least
               two of the following character types: uppercase letters, lowercase letters, digits, and special characters.
        :param pulumi.Input[_builtins.str] phone: Specifies the mobile number with a maximum of 32 digits. This parameter must be used
               together with `country_code`.
        :param pulumi.Input[_builtins.bool] pwd_reset: Specifies whether or not the password should be reset. By default, the password is asked
               to reset at the first login.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if external_identity_id is not None:
            pulumi.set(__self__, "external_identity_id", external_identity_id)
        if external_identity_type is not None:
            pulumi.set(__self__, "external_identity_type", external_identity_type)
        if login_protect_verification_method is not None:
            pulumi.set(__self__, "login_protect_verification_method", login_protect_verification_method)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)
        if pwd_reset is not None:
            pulumi.set(__self__, "pwd_reset", pwd_reset)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the access type of the user. Available values are:
        + default: support both programmatic and management console access.
        + programmatic: only support programmatic access.
        + console: only support management console access.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the country code. The country code of the Chinese mainland is 0086. This
        parameter must be used together with `phone`.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country_code", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the email address with a maximum of 255 characters.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the user is enabled or disabled. Valid values are `true` and `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="externalIdentityId")
    def external_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "external_identity_id")

    @external_identity_id.setter
    def external_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_identity_id", value)

    @_builtins.property
    @pulumi.getter(name="externalIdentityType")
    def external_identity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "external_identity_type")

    @external_identity_type.setter
    def external_identity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_identity_type", value)

    @_builtins.property
    @pulumi.getter(name="loginProtectVerificationMethod")
    def login_protect_verification_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "login_protect_verification_method")

    @login_protect_verification_method.setter
    def login_protect_verification_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_protect_verification_method", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the user. The user name consists of 5 to 32 characters. It can
        contain only uppercase letters, lowercase letters, digits, spaces, and special characters (-_) and cannot start with a
        digit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password for the user with 6 to 32 characters. It must contain at least
        two of the following character types: uppercase letters, lowercase letters, digits, and special characters.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def phone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mobile number with a maximum of 32 digits. This parameter must be used
        together with `country_code`.
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phone", value)

    @_builtins.property
    @pulumi.getter(name="pwdReset")
    def pwd_reset(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether or not the password should be reset. By default, the password is asked
        to reset at the first login.
        """
        return pulumi.get(self, "pwd_reset")

    @pwd_reset.setter
    def pwd_reset(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pwd_reset", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_identity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 last_login: Optional[pulumi.Input[_builtins.str]] = None,
                 login_protect_verification_method: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_strength: Optional[pulumi.Input[_builtins.str]] = None,
                 phone: Optional[pulumi.Input[_builtins.str]] = None,
                 pwd_reset: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[_builtins.str] access_type: Specifies the access type of the user. Available values are:
               + default: support both programmatic and management console access.
               + programmatic: only support programmatic access.
               + console: only support management console access.
        :param pulumi.Input[_builtins.str] country_code: Specifies the country code. The country code of the Chinese mainland is 0086. This
               parameter must be used together with `phone`.
        :param pulumi.Input[_builtins.str] create_time: The time when the IAM user was created.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the user.
        :param pulumi.Input[_builtins.str] email: Specifies the email address with a maximum of 255 characters.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether the user is enabled or disabled. Valid values are `true` and `false`.
        :param pulumi.Input[_builtins.str] last_login: The tiem when the IAM user last login.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the user. The user name consists of 5 to 32 characters. It can
               contain only uppercase letters, lowercase letters, digits, spaces, and special characters (-_) and cannot start with a
               digit.
        :param pulumi.Input[_builtins.str] password: Specifies the password for the user with 6 to 32 characters. It must contain at least
               two of the following character types: uppercase letters, lowercase letters, digits, and special characters.
        :param pulumi.Input[_builtins.str] password_strength: Indicates the password strength.
        :param pulumi.Input[_builtins.str] phone: Specifies the mobile number with a maximum of 32 digits. This parameter must be used
               together with `country_code`.
        :param pulumi.Input[_builtins.bool] pwd_reset: Specifies whether or not the password should be reset. By default, the password is asked
               to reset at the first login.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if external_identity_id is not None:
            pulumi.set(__self__, "external_identity_id", external_identity_id)
        if external_identity_type is not None:
            pulumi.set(__self__, "external_identity_type", external_identity_type)
        if last_login is not None:
            pulumi.set(__self__, "last_login", last_login)
        if login_protect_verification_method is not None:
            pulumi.set(__self__, "login_protect_verification_method", login_protect_verification_method)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_strength is not None:
            pulumi.set(__self__, "password_strength", password_strength)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)
        if pwd_reset is not None:
            pulumi.set(__self__, "pwd_reset", pwd_reset)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the access type of the user. Available values are:
        + default: support both programmatic and management console access.
        + programmatic: only support programmatic access.
        + console: only support management console access.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the country code. The country code of the Chinese mainland is 0086. This
        parameter must be used together with `phone`.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country_code", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the IAM user was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the email address with a maximum of 255 characters.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the user is enabled or disabled. Valid values are `true` and `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="externalIdentityId")
    def external_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "external_identity_id")

    @external_identity_id.setter
    def external_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_identity_id", value)

    @_builtins.property
    @pulumi.getter(name="externalIdentityType")
    def external_identity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "external_identity_type")

    @external_identity_type.setter
    def external_identity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_identity_type", value)

    @_builtins.property
    @pulumi.getter(name="lastLogin")
    def last_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tiem when the IAM user last login.
        """
        return pulumi.get(self, "last_login")

    @last_login.setter
    def last_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_login", value)

    @_builtins.property
    @pulumi.getter(name="loginProtectVerificationMethod")
    def login_protect_verification_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "login_protect_verification_method")

    @login_protect_verification_method.setter
    def login_protect_verification_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_protect_verification_method", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the user. The user name consists of 5 to 32 characters. It can
        contain only uppercase letters, lowercase letters, digits, spaces, and special characters (-_) and cannot start with a
        digit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password for the user with 6 to 32 characters. It must contain at least
        two of the following character types: uppercase letters, lowercase letters, digits, and special characters.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordStrength")
    def password_strength(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the password strength.
        """
        return pulumi.get(self, "password_strength")

    @password_strength.setter
    def password_strength(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_strength", value)

    @_builtins.property
    @pulumi.getter
    def phone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mobile number with a maximum of 32 digits. This parameter must be used
        together with `country_code`.
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phone", value)

    @_builtins.property
    @pulumi.getter(name="pwdReset")
    def pwd_reset(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether or not the password should be reset. By default, the password is asked
        to reset at the first login.
        """
        return pulumi.get(self, "pwd_reset")

    @pwd_reset.setter
    def pwd_reset(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pwd_reset", value)


@pulumi.type_token("sbercloud:Iam/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_identity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 login_protect_verification_method: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 phone: Optional[pulumi.Input[_builtins.str]] = None,
                 pwd_reset: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a User resource within SberCloud IAM service.

        Note: You _must_ have admin privileges in your SberCloud cloud to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        user1 = sbercloud.iam.User("user_1",
            name="user_1",
            description="A user",
            password="password123!")
        ```

        ## Import

        Users can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Iam/user:User user_1 89c60255-9bd6-460c-822a-e2b959ede9d2
        ```

        But due to the security reason, `password` can not be imported, you can ignore it as below.

        resource "sbercloud_identity_user" "user_1" {

          ...

          lifecycle {

            ignore_changes = [
            
              "password",
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_type: Specifies the access type of the user. Available values are:
               + default: support both programmatic and management console access.
               + programmatic: only support programmatic access.
               + console: only support management console access.
        :param pulumi.Input[_builtins.str] country_code: Specifies the country code. The country code of the Chinese mainland is 0086. This
               parameter must be used together with `phone`.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the user.
        :param pulumi.Input[_builtins.str] email: Specifies the email address with a maximum of 255 characters.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether the user is enabled or disabled. Valid values are `true` and `false`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the user. The user name consists of 5 to 32 characters. It can
               contain only uppercase letters, lowercase letters, digits, spaces, and special characters (-_) and cannot start with a
               digit.
        :param pulumi.Input[_builtins.str] password: Specifies the password for the user with 6 to 32 characters. It must contain at least
               two of the following character types: uppercase letters, lowercase letters, digits, and special characters.
        :param pulumi.Input[_builtins.str] phone: Specifies the mobile number with a maximum of 32 digits. This parameter must be used
               together with `country_code`.
        :param pulumi.Input[_builtins.bool] pwd_reset: Specifies whether or not the password should be reset. By default, the password is asked
               to reset at the first login.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[UserArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a User resource within SberCloud IAM service.

        Note: You _must_ have admin privileges in your SberCloud cloud to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        user1 = sbercloud.iam.User("user_1",
            name="user_1",
            description="A user",
            password="password123!")
        ```

        ## Import

        Users can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Iam/user:User user_1 89c60255-9bd6-460c-822a-e2b959ede9d2
        ```

        But due to the security reason, `password` can not be imported, you can ignore it as below.

        resource "sbercloud_identity_user" "user_1" {

          ...

          lifecycle {

            ignore_changes = [
            
              "password",
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_identity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 login_protect_verification_method: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 phone: Optional[pulumi.Input[_builtins.str]] = None,
                 pwd_reset: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["access_type"] = access_type
            __props__.__dict__["country_code"] = country_code
            __props__.__dict__["description"] = description
            __props__.__dict__["email"] = email
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["external_identity_id"] = external_identity_id
            __props__.__dict__["external_identity_type"] = external_identity_type
            __props__.__dict__["login_protect_verification_method"] = login_protect_verification_method
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["phone"] = phone
            __props__.__dict__["pwd_reset"] = pwd_reset
            __props__.__dict__["create_time"] = None
            __props__.__dict__["last_login"] = None
            __props__.__dict__["password_strength"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'sbercloud:Iam/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_type: Optional[pulumi.Input[_builtins.str]] = None,
            country_code: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            external_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            external_identity_type: Optional[pulumi.Input[_builtins.str]] = None,
            last_login: Optional[pulumi.Input[_builtins.str]] = None,
            login_protect_verification_method: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            password_strength: Optional[pulumi.Input[_builtins.str]] = None,
            phone: Optional[pulumi.Input[_builtins.str]] = None,
            pwd_reset: Optional[pulumi.Input[_builtins.bool]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_type: Specifies the access type of the user. Available values are:
               + default: support both programmatic and management console access.
               + programmatic: only support programmatic access.
               + console: only support management console access.
        :param pulumi.Input[_builtins.str] country_code: Specifies the country code. The country code of the Chinese mainland is 0086. This
               parameter must be used together with `phone`.
        :param pulumi.Input[_builtins.str] create_time: The time when the IAM user was created.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the user.
        :param pulumi.Input[_builtins.str] email: Specifies the email address with a maximum of 255 characters.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether the user is enabled or disabled. Valid values are `true` and `false`.
        :param pulumi.Input[_builtins.str] last_login: The tiem when the IAM user last login.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the user. The user name consists of 5 to 32 characters. It can
               contain only uppercase letters, lowercase letters, digits, spaces, and special characters (-_) and cannot start with a
               digit.
        :param pulumi.Input[_builtins.str] password: Specifies the password for the user with 6 to 32 characters. It must contain at least
               two of the following character types: uppercase letters, lowercase letters, digits, and special characters.
        :param pulumi.Input[_builtins.str] password_strength: Indicates the password strength.
        :param pulumi.Input[_builtins.str] phone: Specifies the mobile number with a maximum of 32 digits. This parameter must be used
               together with `country_code`.
        :param pulumi.Input[_builtins.bool] pwd_reset: Specifies whether or not the password should be reset. By default, the password is asked
               to reset at the first login.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["access_type"] = access_type
        __props__.__dict__["country_code"] = country_code
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["email"] = email
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["external_identity_id"] = external_identity_id
        __props__.__dict__["external_identity_type"] = external_identity_type
        __props__.__dict__["last_login"] = last_login
        __props__.__dict__["login_protect_verification_method"] = login_protect_verification_method
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["password_strength"] = password_strength
        __props__.__dict__["phone"] = phone
        __props__.__dict__["pwd_reset"] = pwd_reset
        return User(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the access type of the user. Available values are:
        + default: support both programmatic and management console access.
        + programmatic: only support programmatic access.
        + console: only support management console access.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the country code. The country code of the Chinese mainland is 0086. This
        parameter must be used together with `phone`.
        """
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the IAM user was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the user.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the email address with a maximum of 255 characters.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the user is enabled or disabled. Valid values are `true` and `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="externalIdentityId")
    def external_identity_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "external_identity_id")

    @_builtins.property
    @pulumi.getter(name="externalIdentityType")
    def external_identity_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "external_identity_type")

    @_builtins.property
    @pulumi.getter(name="lastLogin")
    def last_login(self) -> pulumi.Output[_builtins.str]:
        """
        The tiem when the IAM user last login.
        """
        return pulumi.get(self, "last_login")

    @_builtins.property
    @pulumi.getter(name="loginProtectVerificationMethod")
    def login_protect_verification_method(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "login_protect_verification_method")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the user. The user name consists of 5 to 32 characters. It can
        contain only uppercase letters, lowercase letters, digits, spaces, and special characters (-_) and cannot start with a
        digit.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the password for the user with 6 to 32 characters. It must contain at least
        two of the following character types: uppercase letters, lowercase letters, digits, and special characters.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordStrength")
    def password_strength(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the password strength.
        """
        return pulumi.get(self, "password_strength")

    @_builtins.property
    @pulumi.getter
    def phone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the mobile number with a maximum of 32 digits. This parameter must be used
        together with `country_code`.
        """
        return pulumi.get(self, "phone")

    @_builtins.property
    @pulumi.getter(name="pwdReset")
    def pwd_reset(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether or not the password should be reset. By default, the password is asked
        to reset at the first login.
        """
        return pulumi.get(self, "pwd_reset")

