# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetImageResult',
    'AwaitableGetImageResult',
    'get_image',
    'get_image_output',
]

@pulumi.output_type
class GetImageResult:
    """
    A collection of values returned by getImage.
    """
    def __init__(__self__, active_at=None, architecture=None, backup_id=None, checksum=None, container_format=None, created_at=None, data_origin=None, description=None, disk_format=None, enterprise_project_id=None, file=None, flavor_id=None, id=None, image_id=None, image_type=None, is_whole_image=None, max_ram_mb=None, metadata=None, min_disk_gb=None, min_ram_mb=None, most_recent=None, name=None, name_regex=None, os=None, os_version=None, owner=None, protected=None, region=None, schema=None, size_bytes=None, size_max=None, size_min=None, sort_direction=None, sort_key=None, status=None, tag=None, updated_at=None, visibility=None):
        if active_at and not isinstance(active_at, str):
            raise TypeError("Expected argument 'active_at' to be a str")
        pulumi.set(__self__, "active_at", active_at)
        if architecture and not isinstance(architecture, str):
            raise TypeError("Expected argument 'architecture' to be a str")
        pulumi.set(__self__, "architecture", architecture)
        if backup_id and not isinstance(backup_id, str):
            raise TypeError("Expected argument 'backup_id' to be a str")
        pulumi.set(__self__, "backup_id", backup_id)
        if checksum and not isinstance(checksum, str):
            raise TypeError("Expected argument 'checksum' to be a str")
        pulumi.set(__self__, "checksum", checksum)
        if container_format and not isinstance(container_format, str):
            raise TypeError("Expected argument 'container_format' to be a str")
        pulumi.set(__self__, "container_format", container_format)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if data_origin and not isinstance(data_origin, str):
            raise TypeError("Expected argument 'data_origin' to be a str")
        pulumi.set(__self__, "data_origin", data_origin)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disk_format and not isinstance(disk_format, str):
            raise TypeError("Expected argument 'disk_format' to be a str")
        pulumi.set(__self__, "disk_format", disk_format)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if file and not isinstance(file, str):
            raise TypeError("Expected argument 'file' to be a str")
        pulumi.set(__self__, "file", file)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if image_type and not isinstance(image_type, str):
            raise TypeError("Expected argument 'image_type' to be a str")
        pulumi.set(__self__, "image_type", image_type)
        if is_whole_image and not isinstance(is_whole_image, bool):
            raise TypeError("Expected argument 'is_whole_image' to be a bool")
        pulumi.set(__self__, "is_whole_image", is_whole_image)
        if max_ram_mb and not isinstance(max_ram_mb, int):
            raise TypeError("Expected argument 'max_ram_mb' to be a int")
        pulumi.set(__self__, "max_ram_mb", max_ram_mb)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if min_disk_gb and not isinstance(min_disk_gb, int):
            raise TypeError("Expected argument 'min_disk_gb' to be a int")
        pulumi.set(__self__, "min_disk_gb", min_disk_gb)
        if min_ram_mb and not isinstance(min_ram_mb, int):
            raise TypeError("Expected argument 'min_ram_mb' to be a int")
        pulumi.set(__self__, "min_ram_mb", min_ram_mb)
        if most_recent and not isinstance(most_recent, bool):
            raise TypeError("Expected argument 'most_recent' to be a bool")
        pulumi.set(__self__, "most_recent", most_recent)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if os and not isinstance(os, str):
            raise TypeError("Expected argument 'os' to be a str")
        pulumi.set(__self__, "os", os)
        if os_version and not isinstance(os_version, str):
            raise TypeError("Expected argument 'os_version' to be a str")
        pulumi.set(__self__, "os_version", os_version)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if protected and not isinstance(protected, bool):
            raise TypeError("Expected argument 'protected' to be a bool")
        pulumi.set(__self__, "protected", protected)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)
        if size_bytes and not isinstance(size_bytes, int):
            raise TypeError("Expected argument 'size_bytes' to be a int")
        pulumi.set(__self__, "size_bytes", size_bytes)
        if size_max and not isinstance(size_max, int):
            raise TypeError("Expected argument 'size_max' to be a int")
        pulumi.set(__self__, "size_max", size_max)
        if size_min and not isinstance(size_min, int):
            raise TypeError("Expected argument 'size_min' to be a int")
        pulumi.set(__self__, "size_min", size_min)
        if sort_direction and not isinstance(sort_direction, str):
            raise TypeError("Expected argument 'sort_direction' to be a str")
        pulumi.set(__self__, "sort_direction", sort_direction)
        if sort_key and not isinstance(sort_key, str):
            raise TypeError("Expected argument 'sort_key' to be a str")
        pulumi.set(__self__, "sort_key", sort_key)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if visibility and not isinstance(visibility, str):
            raise TypeError("Expected argument 'visibility' to be a str")
        pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter(name="activeAt")
    def active_at(self) -> _builtins.str:
        return pulumi.get(self, "active_at")

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> _builtins.str:
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> _builtins.str:
        """
        The backup ID of the whole image in the CBR vault.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> _builtins.str:
        """
        The checksum of the data associated with the image.
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter(name="containerFormat")
    def container_format(self) -> _builtins.str:
        """
        The format of the image's container.
        """
        return pulumi.get(self, "container_format")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date when the image was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dataOrigin")
    def data_origin(self) -> _builtins.str:
        return pulumi.get(self, "data_origin")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskFormat")
    def disk_format(self) -> _builtins.str:
        """
        The format of the image's disk.
        """
        return pulumi.get(self, "disk_format")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def file(self) -> _builtins.str:
        """
        the trailing path after the glance endpoint that represent the location of the image or the path to retrieve
        it.
        """
        return pulumi.get(self, "file")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> _builtins.str:
        return pulumi.get(self, "image_type")

    @_builtins.property
    @pulumi.getter(name="isWholeImage")
    def is_whole_image(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_whole_image")

    @_builtins.property
    @pulumi.getter(name="maxRamMb")
    def max_ram_mb(self) -> _builtins.int:
        return pulumi.get(self, "max_ram_mb")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        The metadata associated with the image. Image metadata allow for meaningfully define the image properties
        and tags.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="minDiskGb")
    def min_disk_gb(self) -> _builtins.int:
        """
        The minimum amount of disk space required to use the image.
        """
        return pulumi.get(self, "min_disk_gb")

    @_builtins.property
    @pulumi.getter(name="minRamMb")
    def min_ram_mb(self) -> _builtins.int:
        """
        The minimum amount of ram required to use the image.
        """
        return pulumi.get(self, "min_ram_mb")

    @_builtins.property
    @pulumi.getter(name="mostRecent")
    def most_recent(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "most_recent")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def os(self) -> _builtins.str:
        return pulumi.get(self, "os")

    @_builtins.property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> _builtins.str:
        return pulumi.get(self, "os_version")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def protected(self) -> _builtins.bool:
        """
        Whether or not the image is protected.
        """
        return pulumi.get(self, "protected")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> _builtins.str:
        """
        The path to the JSON-schema that represent the image or image.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> _builtins.int:
        """
        The size of the image (in bytes).
        """
        return pulumi.get(self, "size_bytes")

    @_builtins.property
    @pulumi.getter(name="sizeMax")
    @_utilities.deprecated("""size_max is deprecated""")
    def size_max(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "size_max")

    @_builtins.property
    @pulumi.getter(name="sizeMin")
    @_utilities.deprecated("""size_min is deprecated""")
    def size_min(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "size_min")

    @_builtins.property
    @pulumi.getter(name="sortDirection")
    def sort_direction(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sort_direction")

    @_builtins.property
    @pulumi.getter(name="sortKey")
    def sort_key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sort_key")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the image.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date when the image was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> _builtins.str:
        return pulumi.get(self, "visibility")


class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            active_at=self.active_at,
            architecture=self.architecture,
            backup_id=self.backup_id,
            checksum=self.checksum,
            container_format=self.container_format,
            created_at=self.created_at,
            data_origin=self.data_origin,
            description=self.description,
            disk_format=self.disk_format,
            enterprise_project_id=self.enterprise_project_id,
            file=self.file,
            flavor_id=self.flavor_id,
            id=self.id,
            image_id=self.image_id,
            image_type=self.image_type,
            is_whole_image=self.is_whole_image,
            max_ram_mb=self.max_ram_mb,
            metadata=self.metadata,
            min_disk_gb=self.min_disk_gb,
            min_ram_mb=self.min_ram_mb,
            most_recent=self.most_recent,
            name=self.name,
            name_regex=self.name_regex,
            os=self.os,
            os_version=self.os_version,
            owner=self.owner,
            protected=self.protected,
            region=self.region,
            schema=self.schema,
            size_bytes=self.size_bytes,
            size_max=self.size_max,
            size_min=self.size_min,
            sort_direction=self.sort_direction,
            sort_key=self.sort_key,
            status=self.status,
            tag=self.tag,
            updated_at=self.updated_at,
            visibility=self.visibility)


def get_image(architecture: Optional[_builtins.str] = None,
              enterprise_project_id: Optional[_builtins.str] = None,
              flavor_id: Optional[_builtins.str] = None,
              image_id: Optional[_builtins.str] = None,
              image_type: Optional[_builtins.str] = None,
              is_whole_image: Optional[_builtins.bool] = None,
              most_recent: Optional[_builtins.bool] = None,
              name: Optional[_builtins.str] = None,
              name_regex: Optional[_builtins.str] = None,
              os: Optional[_builtins.str] = None,
              os_version: Optional[_builtins.str] = None,
              owner: Optional[_builtins.str] = None,
              region: Optional[_builtins.str] = None,
              size_max: Optional[_builtins.int] = None,
              size_min: Optional[_builtins.int] = None,
              sort_direction: Optional[_builtins.str] = None,
              sort_key: Optional[_builtins.str] = None,
              tag: Optional[_builtins.str] = None,
              visibility: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageResult:
    """
    Use this data source to get the ID of an available SberCloud image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    ubuntu = sbercloud.Ims.get_image(name="Ubuntu 18.04 server 64bit",
        visibility="public",
        most_recent=True)
    centos_1 = sbercloud.Ims.get_image(architecture="x86",
        os_version="CentOS 7.4 64bit",
        visibility="public",
        most_recent=True)
    centos_2 = sbercloud.Ims.get_image(architecture="x86",
        name_regex="^CentOS 7.4",
        visibility="public",
        most_recent=True)
    bms_image = sbercloud.Ims.get_image(architecture="x86",
        image_type="Ironic",
        os_version="CentOS 7.4 64bit",
        visibility="public",
        most_recent=True)
    ```


    :param _builtins.str architecture: Specifies the image architecture type. The value can be **x86** and **arm**.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID of the image.
    :param _builtins.str flavor_id: Specifies the ECS flavor ID used to filter out available images.
           You can specify only one flavor ID and only ECS flavor ID is valid, BMS flavor is not supported.
    :param _builtins.str image_type: Specifies the environment where the image is used. For a BMS image, the value is **Ironic**.
    :param _builtins.bool most_recent: If more than one result is returned, use the latest updated image.
    :param _builtins.str name: The name of the image. Cannot be used simultaneously with `name_regex`.
    :param _builtins.str name_regex: The regular expressian of the name of the image.
           Cannot be used simultaneously with `name`.
    :param _builtins.str os: Specifies the image OS type. The value can be **Windows**, **Ubuntu**,
           **RedHat**, **SUSE**, **CentOS**, **Debian**, **OpenSUSE**, **Oracle Linux**, **Fedora**, **Other**,
           **CoreOS**, or **EulerOS**.
    :param _builtins.str os_version: Specifies the OS version. For example, *CentOS 7.4 64bit* or *Ubuntu 18.04 server 64bit*.
    :param _builtins.str owner: The owner (UUID) of the image.
    :param _builtins.str region: The region in which to obtain the images. If omitted, the provider-level region will be
           used.
    :param _builtins.str sort_direction: Order the results in either `asc` or `desc`.
    :param _builtins.str sort_key: Sort images based on a certain key. Must be one of
           "name", "container_format", "disk_format", "status", "id" or "size". Defaults to `name`.
    :param _builtins.str tag: Search for images with a specific tag in "Key=Value" format.
    :param _builtins.str visibility: The visibility of the image. Must be one of
           **public**, **private**, **market** or **shared**.
    """
    __args__ = dict()
    __args__['architecture'] = architecture
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['flavorId'] = flavor_id
    __args__['imageId'] = image_id
    __args__['imageType'] = image_type
    __args__['isWholeImage'] = is_whole_image
    __args__['mostRecent'] = most_recent
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['os'] = os
    __args__['osVersion'] = os_version
    __args__['owner'] = owner
    __args__['region'] = region
    __args__['sizeMax'] = size_max
    __args__['sizeMin'] = size_min
    __args__['sortDirection'] = sort_direction
    __args__['sortKey'] = sort_key
    __args__['tag'] = tag
    __args__['visibility'] = visibility
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Ims/getImage:getImage', __args__, opts=opts, typ=GetImageResult).value

    return AwaitableGetImageResult(
        active_at=pulumi.get(__ret__, 'active_at'),
        architecture=pulumi.get(__ret__, 'architecture'),
        backup_id=pulumi.get(__ret__, 'backup_id'),
        checksum=pulumi.get(__ret__, 'checksum'),
        container_format=pulumi.get(__ret__, 'container_format'),
        created_at=pulumi.get(__ret__, 'created_at'),
        data_origin=pulumi.get(__ret__, 'data_origin'),
        description=pulumi.get(__ret__, 'description'),
        disk_format=pulumi.get(__ret__, 'disk_format'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        file=pulumi.get(__ret__, 'file'),
        flavor_id=pulumi.get(__ret__, 'flavor_id'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        image_type=pulumi.get(__ret__, 'image_type'),
        is_whole_image=pulumi.get(__ret__, 'is_whole_image'),
        max_ram_mb=pulumi.get(__ret__, 'max_ram_mb'),
        metadata=pulumi.get(__ret__, 'metadata'),
        min_disk_gb=pulumi.get(__ret__, 'min_disk_gb'),
        min_ram_mb=pulumi.get(__ret__, 'min_ram_mb'),
        most_recent=pulumi.get(__ret__, 'most_recent'),
        name=pulumi.get(__ret__, 'name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        os=pulumi.get(__ret__, 'os'),
        os_version=pulumi.get(__ret__, 'os_version'),
        owner=pulumi.get(__ret__, 'owner'),
        protected=pulumi.get(__ret__, 'protected'),
        region=pulumi.get(__ret__, 'region'),
        schema=pulumi.get(__ret__, 'schema'),
        size_bytes=pulumi.get(__ret__, 'size_bytes'),
        size_max=pulumi.get(__ret__, 'size_max'),
        size_min=pulumi.get(__ret__, 'size_min'),
        sort_direction=pulumi.get(__ret__, 'sort_direction'),
        sort_key=pulumi.get(__ret__, 'sort_key'),
        status=pulumi.get(__ret__, 'status'),
        tag=pulumi.get(__ret__, 'tag'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        visibility=pulumi.get(__ret__, 'visibility'))
def get_image_output(architecture: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     flavor_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     image_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     image_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     is_whole_image: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                     most_recent: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     os: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     os_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     owner: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     size_max: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                     size_min: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                     sort_direction: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     sort_key: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     tag: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     visibility: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageResult]:
    """
    Use this data source to get the ID of an available SberCloud image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    ubuntu = sbercloud.Ims.get_image(name="Ubuntu 18.04 server 64bit",
        visibility="public",
        most_recent=True)
    centos_1 = sbercloud.Ims.get_image(architecture="x86",
        os_version="CentOS 7.4 64bit",
        visibility="public",
        most_recent=True)
    centos_2 = sbercloud.Ims.get_image(architecture="x86",
        name_regex="^CentOS 7.4",
        visibility="public",
        most_recent=True)
    bms_image = sbercloud.Ims.get_image(architecture="x86",
        image_type="Ironic",
        os_version="CentOS 7.4 64bit",
        visibility="public",
        most_recent=True)
    ```


    :param _builtins.str architecture: Specifies the image architecture type. The value can be **x86** and **arm**.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID of the image.
    :param _builtins.str flavor_id: Specifies the ECS flavor ID used to filter out available images.
           You can specify only one flavor ID and only ECS flavor ID is valid, BMS flavor is not supported.
    :param _builtins.str image_type: Specifies the environment where the image is used. For a BMS image, the value is **Ironic**.
    :param _builtins.bool most_recent: If more than one result is returned, use the latest updated image.
    :param _builtins.str name: The name of the image. Cannot be used simultaneously with `name_regex`.
    :param _builtins.str name_regex: The regular expressian of the name of the image.
           Cannot be used simultaneously with `name`.
    :param _builtins.str os: Specifies the image OS type. The value can be **Windows**, **Ubuntu**,
           **RedHat**, **SUSE**, **CentOS**, **Debian**, **OpenSUSE**, **Oracle Linux**, **Fedora**, **Other**,
           **CoreOS**, or **EulerOS**.
    :param _builtins.str os_version: Specifies the OS version. For example, *CentOS 7.4 64bit* or *Ubuntu 18.04 server 64bit*.
    :param _builtins.str owner: The owner (UUID) of the image.
    :param _builtins.str region: The region in which to obtain the images. If omitted, the provider-level region will be
           used.
    :param _builtins.str sort_direction: Order the results in either `asc` or `desc`.
    :param _builtins.str sort_key: Sort images based on a certain key. Must be one of
           "name", "container_format", "disk_format", "status", "id" or "size". Defaults to `name`.
    :param _builtins.str tag: Search for images with a specific tag in "Key=Value" format.
    :param _builtins.str visibility: The visibility of the image. Must be one of
           **public**, **private**, **market** or **shared**.
    """
    __args__ = dict()
    __args__['architecture'] = architecture
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['flavorId'] = flavor_id
    __args__['imageId'] = image_id
    __args__['imageType'] = image_type
    __args__['isWholeImage'] = is_whole_image
    __args__['mostRecent'] = most_recent
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['os'] = os
    __args__['osVersion'] = os_version
    __args__['owner'] = owner
    __args__['region'] = region
    __args__['sizeMax'] = size_max
    __args__['sizeMin'] = size_min
    __args__['sortDirection'] = sort_direction
    __args__['sortKey'] = sort_key
    __args__['tag'] = tag
    __args__['visibility'] = visibility
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Ims/getImage:getImage', __args__, opts=opts, typ=GetImageResult)
    return __ret__.apply(lambda __response__: GetImageResult(
        active_at=pulumi.get(__response__, 'active_at'),
        architecture=pulumi.get(__response__, 'architecture'),
        backup_id=pulumi.get(__response__, 'backup_id'),
        checksum=pulumi.get(__response__, 'checksum'),
        container_format=pulumi.get(__response__, 'container_format'),
        created_at=pulumi.get(__response__, 'created_at'),
        data_origin=pulumi.get(__response__, 'data_origin'),
        description=pulumi.get(__response__, 'description'),
        disk_format=pulumi.get(__response__, 'disk_format'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        file=pulumi.get(__response__, 'file'),
        flavor_id=pulumi.get(__response__, 'flavor_id'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        image_type=pulumi.get(__response__, 'image_type'),
        is_whole_image=pulumi.get(__response__, 'is_whole_image'),
        max_ram_mb=pulumi.get(__response__, 'max_ram_mb'),
        metadata=pulumi.get(__response__, 'metadata'),
        min_disk_gb=pulumi.get(__response__, 'min_disk_gb'),
        min_ram_mb=pulumi.get(__response__, 'min_ram_mb'),
        most_recent=pulumi.get(__response__, 'most_recent'),
        name=pulumi.get(__response__, 'name'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        os=pulumi.get(__response__, 'os'),
        os_version=pulumi.get(__response__, 'os_version'),
        owner=pulumi.get(__response__, 'owner'),
        protected=pulumi.get(__response__, 'protected'),
        region=pulumi.get(__response__, 'region'),
        schema=pulumi.get(__response__, 'schema'),
        size_bytes=pulumi.get(__response__, 'size_bytes'),
        size_max=pulumi.get(__response__, 'size_max'),
        size_min=pulumi.get(__response__, 'size_min'),
        sort_direction=pulumi.get(__response__, 'sort_direction'),
        sort_key=pulumi.get(__response__, 'sort_key'),
        status=pulumi.get(__response__, 'status'),
        tag=pulumi.get(__response__, 'tag'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        visibility=pulumi.get(__response__, 'visibility')))
