# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[_builtins.str],
                 ttl_in_days: pulumi.Input[_builtins.int],
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[_builtins.str] group_name: Specifies the log group name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.int] ttl_in_days: Specifies the log expiration time(days), value range: 1-30.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID to which the log group belongs.
        :param pulumi.Input[_builtins.str] region: The region in which to create the log group resource. If omitted, the
               provider-level region will be used. Changing this creates a new log group resource.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "ttl_in_days", ttl_in_days)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the log group name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="ttlInDays")
    def ttl_in_days(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the log expiration time(days), value range: 1-30.
        """
        return pulumi.get(self, "ttl_in_days")

    @ttl_in_days.setter
    def ttl_in_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "ttl_in_days", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project ID to which the log group belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the log group resource. If omitted, the
        provider-level region will be used. Changing this creates a new log group resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl_in_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID to which the log group belongs.
        :param pulumi.Input[_builtins.str] group_name: Specifies the log group name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the log group resource. If omitted, the
               provider-level region will be used. Changing this creates a new log group resource.
        :param pulumi.Input[_builtins.int] ttl_in_days: Specifies the log expiration time(days), value range: 1-30.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl_in_days is not None:
            pulumi.set(__self__, "ttl_in_days", ttl_in_days)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project ID to which the log group belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the log group name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the log group resource. If omitted, the
        provider-level region will be used. Changing this creates a new log group resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="ttlInDays")
    def ttl_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the log expiration time(days), value range: 1-30.
        """
        return pulumi.get(self, "ttl_in_days")

    @ttl_in_days.setter
    def ttl_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl_in_days", value)


@pulumi.type_token("sbercloud:Lts/group:Group")
class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a log group resource within SberCloud.

        ## Example Usage

        ### create a log group

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        log_group1 = sbercloud.lts.Group("log_group1",
            group_name="log_group1",
            ttl_in_days=1)
        ```

        ## Import

        Log group can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Lts/group:Group group_1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID to which the log group belongs.
        :param pulumi.Input[_builtins.str] group_name: Specifies the log group name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the log group resource. If omitted, the
               provider-level region will be used. Changing this creates a new log group resource.
        :param pulumi.Input[_builtins.int] ttl_in_days: Specifies the log expiration time(days), value range: 1-30.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a log group resource within SberCloud.

        ## Example Usage

        ### create a log group

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        log_group1 = sbercloud.lts.Group("log_group1",
            group_name="log_group1",
            ttl_in_days=1)
        ```

        ## Import

        Log group can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Lts/group:Group group_1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if group_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_name'")
            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            if ttl_in_days is None and not opts.urn:
                raise TypeError("Missing required property 'ttl_in_days'")
            __props__.__dict__["ttl_in_days"] = ttl_in_days
            __props__.__dict__["created_at"] = None
        super(Group, __self__).__init__(
            'sbercloud:Lts/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            group_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ttl_in_days: Optional[pulumi.Input[_builtins.int]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID to which the log group belongs.
        :param pulumi.Input[_builtins.str] group_name: Specifies the log group name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the log group resource. If omitted, the
               provider-level region will be used. Changing this creates a new log group resource.
        :param pulumi.Input[_builtins.int] ttl_in_days: Specifies the log expiration time(days), value range: 1-30.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["ttl_in_days"] = ttl_in_days
        return Group(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project ID to which the log group belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the log group name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the log group resource. If omitted, the
        provider-level region will be used. Changing this creates a new log group resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="ttlInDays")
    def ttl_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the log expiration time(days), value range: 1-30.
        """
        return pulumi.get(self, "ttl_in_days")

