# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StreamArgs', 'Stream']

@pulumi.input_type
class StreamArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[_builtins.str],
                 stream_name: pulumi.Input[_builtins.str],
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_favorite: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl_in_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Stream resource.
        :param pulumi.Input[_builtins.str] group_id: Specifies the ID of a created log group. Changing this parameter will create
               a new resource.
        :param pulumi.Input[_builtins.str] stream_name: Specifies the log stream name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.bool] is_favorite: Whether to favorite the log stream.
        :param pulumi.Input[_builtins.str] region: The region in which to create the log stream resource. If omitted, the
               provider-level region will be used. Changing this creates a new log stream resource.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "stream_name", stream_name)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if is_favorite is not None:
            pulumi.set(__self__, "is_favorite", is_favorite)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl_in_days is not None:
            pulumi.set(__self__, "ttl_in_days", ttl_in_days)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a created log group. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the log stream name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stream_name", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="isFavorite")
    def is_favorite(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to favorite the log stream.
        """
        return pulumi.get(self, "is_favorite")

    @is_favorite.setter
    def is_favorite(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_favorite", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the log stream resource. If omitted, the
        provider-level region will be used. Changing this creates a new log stream resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="ttlInDays")
    def ttl_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ttl_in_days")

    @ttl_in_days.setter
    def ttl_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl_in_days", value)


@pulumi.input_type
class _StreamState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_count: Optional[pulumi.Input[_builtins.int]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_favorite: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl_in_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Stream resources.
        :param pulumi.Input[_builtins.int] filter_count: Number of log stream filters.
        :param pulumi.Input[_builtins.str] group_id: Specifies the ID of a created log group. Changing this parameter will create
               a new resource.
        :param pulumi.Input[_builtins.bool] is_favorite: Whether to favorite the log stream.
        :param pulumi.Input[_builtins.str] region: The region in which to create the log stream resource. If omitted, the
               provider-level region will be used. Changing this creates a new log stream resource.
        :param pulumi.Input[_builtins.str] stream_name: Specifies the log stream name. Changing this parameter will create a new
               resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if filter_count is not None:
            pulumi.set(__self__, "filter_count", filter_count)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if is_favorite is not None:
            pulumi.set(__self__, "is_favorite", is_favorite)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if stream_name is not None:
            pulumi.set(__self__, "stream_name", stream_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl_in_days is not None:
            pulumi.set(__self__, "ttl_in_days", ttl_in_days)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="filterCount")
    def filter_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of log stream filters.
        """
        return pulumi.get(self, "filter_count")

    @filter_count.setter
    def filter_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "filter_count", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a created log group. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="isFavorite")
    def is_favorite(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to favorite the log stream.
        """
        return pulumi.get(self, "is_favorite")

    @is_favorite.setter
    def is_favorite(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_favorite", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the log stream resource. If omitted, the
        provider-level region will be used. Changing this creates a new log stream resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the log stream name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="ttlInDays")
    def ttl_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ttl_in_days")

    @ttl_in_days.setter
    def ttl_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl_in_days", value)


@pulumi.type_token("sbercloud:Lts/stream:Stream")
class Stream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_favorite: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manage a log stream resource within SberCloud.

        ## Example Usage

        ### create a log stream

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test_group = sbercloud.lts.Group("test_group",
            group_name="test_group",
            ttl_in_days=1)
        test_stream = sbercloud.lts.Stream("test_stream",
            group_id=test_group.id,
            stream_name="testacc_stream")
        ```

        ## Import

        Log stream can be imported using the lts group ID and stream ID separated by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:Lts/stream:Stream stream_1 393f2bfd-2244-11ea-adb7-286ed488c87f/72855918-20b1-11ea-80e0-286ed488c880
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_id: Specifies the ID of a created log group. Changing this parameter will create
               a new resource.
        :param pulumi.Input[_builtins.bool] is_favorite: Whether to favorite the log stream.
        :param pulumi.Input[_builtins.str] region: The region in which to create the log stream resource. If omitted, the
               provider-level region will be used. Changing this creates a new log stream resource.
        :param pulumi.Input[_builtins.str] stream_name: Specifies the log stream name. Changing this parameter will create a new
               resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage a log stream resource within SberCloud.

        ## Example Usage

        ### create a log stream

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test_group = sbercloud.lts.Group("test_group",
            group_name="test_group",
            ttl_in_days=1)
        test_stream = sbercloud.lts.Stream("test_stream",
            group_id=test_group.id,
            stream_name="testacc_stream")
        ```

        ## Import

        Log stream can be imported using the lts group ID and stream ID separated by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:Lts/stream:Stream stream_1 393f2bfd-2244-11ea-adb7-286ed488c87f/72855918-20b1-11ea-80e0-286ed488c880
        ```

        :param str resource_name: The name of the resource.
        :param StreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_favorite: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamArgs.__new__(StreamArgs)

            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["is_favorite"] = is_favorite
            __props__.__dict__["region"] = region
            if stream_name is None and not opts.urn:
                raise TypeError("Missing required property 'stream_name'")
            __props__.__dict__["stream_name"] = stream_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["ttl_in_days"] = ttl_in_days
            __props__.__dict__["created_at"] = None
            __props__.__dict__["filter_count"] = None
        super(Stream, __self__).__init__(
            'sbercloud:Lts/stream:Stream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            filter_count: Optional[pulumi.Input[_builtins.int]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_favorite: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            stream_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ttl_in_days: Optional[pulumi.Input[_builtins.int]] = None) -> 'Stream':
        """
        Get an existing Stream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] filter_count: Number of log stream filters.
        :param pulumi.Input[_builtins.str] group_id: Specifies the ID of a created log group. Changing this parameter will create
               a new resource.
        :param pulumi.Input[_builtins.bool] is_favorite: Whether to favorite the log stream.
        :param pulumi.Input[_builtins.str] region: The region in which to create the log stream resource. If omitted, the
               provider-level region will be used. Changing this creates a new log stream resource.
        :param pulumi.Input[_builtins.str] stream_name: Specifies the log stream name. Changing this parameter will create a new
               resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamState.__new__(_StreamState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["filter_count"] = filter_count
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["is_favorite"] = is_favorite
        __props__.__dict__["region"] = region
        __props__.__dict__["stream_name"] = stream_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["ttl_in_days"] = ttl_in_days
        return Stream(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="filterCount")
    def filter_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of log stream filters.
        """
        return pulumi.get(self, "filter_count")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a created log group. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="isFavorite")
    def is_favorite(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to favorite the log stream.
        """
        return pulumi.get(self, "is_favorite")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the log stream resource. If omitted, the
        provider-level region will be used. Changing this creates a new log stream resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the log stream name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "stream_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="ttlInDays")
    def ttl_in_days(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "ttl_in_days")

