# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterAnalysisCoreNodesArgs',
    'ClusterAnalysisCoreNodesArgsDict',
    'ClusterAnalysisTaskNodesArgs',
    'ClusterAnalysisTaskNodesArgsDict',
    'ClusterBootstrapScriptArgs',
    'ClusterBootstrapScriptArgsDict',
    'ClusterComponentConfigArgs',
    'ClusterComponentConfigArgsDict',
    'ClusterComponentConfigConfigArgs',
    'ClusterComponentConfigConfigArgsDict',
    'ClusterCustomNodeArgs',
    'ClusterCustomNodeArgsDict',
    'ClusterExternalDatasourceArgs',
    'ClusterExternalDatasourceArgsDict',
    'ClusterMasterNodesArgs',
    'ClusterMasterNodesArgsDict',
    'ClusterSmnNotifyArgs',
    'ClusterSmnNotifyArgsDict',
    'ClusterStreamingCoreNodesArgs',
    'ClusterStreamingCoreNodesArgsDict',
    'ClusterStreamingTaskNodesArgs',
    'ClusterStreamingTaskNodesArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterAnalysisCoreNodesArgsDict(TypedDict):
        data_volume_count: pulumi.Input[_builtins.int]
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        flavor: pulumi.Input[_builtins.str]
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        node_number: pulumi.Input[_builtins.int]
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        root_volume_size: pulumi.Input[_builtins.int]
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        root_volume_type: pulumi.Input[_builtins.str]
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        assigned_roles: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        auto_renew: NotRequired[pulumi.Input[_builtins.str]]
        charging_mode: NotRequired[pulumi.Input[_builtins.str]]
        data_volume_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        data_volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        host_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The host list of this nodes group in the cluster.
        """
        period: NotRequired[pulumi.Input[_builtins.int]]
        period_unit: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    ClusterAnalysisCoreNodesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAnalysisCoreNodesArgs:
    def __init__(__self__, *,
                 data_volume_count: pulumi.Input[_builtins.int],
                 flavor: pulumi.Input[_builtins.str],
                 node_number: pulumi.Input[_builtins.int],
                 root_volume_size: pulumi.Input[_builtins.int],
                 root_volume_type: pulumi.Input[_builtins.str],
                 assigned_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 data_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 host_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.int] node_number: Specifies the number of nodes for the node group.
               
               > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
               less than the number of nodes originally created.
        :param pulumi.Input[_builtins.int] root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
               
               **Role expression definition:**
               
               + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
               + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
               for example: `DataNode:1,2`. The subscript starts from 1.
               + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
               role_name[instance_count], for example: `EsNode[9]`.
               
               > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
               store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        :param pulumi.Input[_builtins.int] data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param pulumi.Input[_builtins.str] data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)

    @_builtins.property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "data_volume_count")

    @data_volume_count.setter
    def data_volume_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_volume_count", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "node_number", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "root_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "root_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        return pulumi.get(self, "assigned_roles")

    @assigned_roles.setter
    def assigned_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "assigned_roles", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @data_volume_size.setter
    def data_volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @data_volume_type.setter
    def data_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @host_ips.setter
    def host_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_ips", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)


if not MYPY:
    class ClusterAnalysisTaskNodesArgsDict(TypedDict):
        data_volume_count: pulumi.Input[_builtins.int]
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        flavor: pulumi.Input[_builtins.str]
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        node_number: pulumi.Input[_builtins.int]
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        root_volume_size: pulumi.Input[_builtins.int]
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        root_volume_type: pulumi.Input[_builtins.str]
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        assigned_roles: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        data_volume_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        data_volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        host_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The host list of this nodes group in the cluster.
        """
elif False:
    ClusterAnalysisTaskNodesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAnalysisTaskNodesArgs:
    def __init__(__self__, *,
                 data_volume_count: pulumi.Input[_builtins.int],
                 flavor: pulumi.Input[_builtins.str],
                 node_number: pulumi.Input[_builtins.int],
                 root_volume_size: pulumi.Input[_builtins.int],
                 root_volume_type: pulumi.Input[_builtins.str],
                 assigned_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 data_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 host_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.int] data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.int] node_number: Specifies the number of nodes for the node group.
               
               > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
               less than the number of nodes originally created.
        :param pulumi.Input[_builtins.int] root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
               
               **Role expression definition:**
               
               + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
               + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
               for example: `DataNode:1,2`. The subscript starts from 1.
               + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
               role_name[instance_count], for example: `EsNode[9]`.
               
               > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
               store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        :param pulumi.Input[_builtins.int] data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param pulumi.Input[_builtins.str] data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @_builtins.property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "data_volume_count")

    @data_volume_count.setter
    def data_volume_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_volume_count", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "node_number", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "root_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "root_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        return pulumi.get(self, "assigned_roles")

    @assigned_roles.setter
    def assigned_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "assigned_roles", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @data_volume_size.setter
    def data_volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @data_volume_type.setter
    def data_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @host_ips.setter
    def host_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_ips", value)


if not MYPY:
    class ClusterBootstrapScriptArgsDict(TypedDict):
        fail_action: pulumi.Input[_builtins.str]
        """
        The action after the bootstrap action script fails to be executed.
        """
        name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the MapReduce cluster. The name can contain 2 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce cluster resource.
        """
        nodes: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Name of the node group where the bootstrap action script is executed.
        """
        uri: pulumi.Input[_builtins.str]
        """
        Path of a bootstrap action script. Set this parameter to an OBS bucket path or a local VM path.
        """
        active_master: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the bootstrap action script runs only on active master nodes.
        """
        before_component_start: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the bootstrap action script is executed before component start.
        """
        execute_need_sudo_root: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the bootstrap action script involves root user operations.
        """
        parameters: NotRequired[pulumi.Input[_builtins.str]]
        """
        Bootstrap action script parameters.
        """
        start_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The execution time of one bootstrap action script, in RFC-3339 format.
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        The status of one bootstrap action script.
        """
elif False:
    ClusterBootstrapScriptArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterBootstrapScriptArgs:
    def __init__(__self__, *,
                 fail_action: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 nodes: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 uri: pulumi.Input[_builtins.str],
                 active_master: Optional[pulumi.Input[_builtins.bool]] = None,
                 before_component_start: Optional[pulumi.Input[_builtins.bool]] = None,
                 execute_need_sudo_root: Optional[pulumi.Input[_builtins.bool]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] fail_action: The action after the bootstrap action script fails to be executed.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the MapReduce cluster. The name can contain 2 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nodes: Name of the node group where the bootstrap action script is executed.
        :param pulumi.Input[_builtins.str] uri: Path of a bootstrap action script. Set this parameter to an OBS bucket path or a local VM path.
        :param pulumi.Input[_builtins.bool] active_master: Whether the bootstrap action script runs only on active master nodes.
        :param pulumi.Input[_builtins.bool] before_component_start: Whether the bootstrap action script is executed before component start.
        :param pulumi.Input[_builtins.bool] execute_need_sudo_root: Whether the bootstrap action script involves root user operations.
        :param pulumi.Input[_builtins.str] parameters: Bootstrap action script parameters.
        :param pulumi.Input[_builtins.str] start_time: The execution time of one bootstrap action script, in RFC-3339 format.
        :param pulumi.Input[_builtins.str] state: The status of one bootstrap action script.
        """
        pulumi.set(__self__, "fail_action", fail_action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "uri", uri)
        if active_master is not None:
            pulumi.set(__self__, "active_master", active_master)
        if before_component_start is not None:
            pulumi.set(__self__, "before_component_start", before_component_start)
        if execute_need_sudo_root is not None:
            pulumi.set(__self__, "execute_need_sudo_root", execute_need_sudo_root)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="failAction")
    def fail_action(self) -> pulumi.Input[_builtins.str]:
        """
        The action after the bootstrap action script fails to be executed.
        """
        return pulumi.get(self, "fail_action")

    @fail_action.setter
    def fail_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fail_action", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the MapReduce cluster. The name can contain 2 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce cluster resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Name of the node group where the bootstrap action script is executed.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Input[_builtins.str]:
        """
        Path of a bootstrap action script. Set this parameter to an OBS bucket path or a local VM path.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter(name="activeMaster")
    def active_master(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the bootstrap action script runs only on active master nodes.
        """
        return pulumi.get(self, "active_master")

    @active_master.setter
    def active_master(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active_master", value)

    @_builtins.property
    @pulumi.getter(name="beforeComponentStart")
    def before_component_start(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the bootstrap action script is executed before component start.
        """
        return pulumi.get(self, "before_component_start")

    @before_component_start.setter
    def before_component_start(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "before_component_start", value)

    @_builtins.property
    @pulumi.getter(name="executeNeedSudoRoot")
    def execute_need_sudo_root(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the bootstrap action script involves root user operations.
        """
        return pulumi.get(self, "execute_need_sudo_root")

    @execute_need_sudo_root.setter
    def execute_need_sudo_root(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "execute_need_sudo_root", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bootstrap action script parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The execution time of one bootstrap action script, in RFC-3339 format.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of one bootstrap action script.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


if not MYPY:
    class ClusterComponentConfigArgsDict(TypedDict):
        configs: pulumi.Input[Sequence[pulumi.Input['ClusterComponentConfigConfigArgsDict']]]
        name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the MapReduce cluster. The name can contain 2 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce cluster resource.
        """
elif False:
    ClusterComponentConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterComponentConfigArgs:
    def __init__(__self__, *,
                 configs: pulumi.Input[Sequence[pulumi.Input['ClusterComponentConfigConfigArgs']]],
                 name: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: Specifies the name of the MapReduce cluster. The name can contain 2 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce cluster resource.
        """
        pulumi.set(__self__, "configs", configs)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterComponentConfigConfigArgs']]]:
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterComponentConfigConfigArgs']]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the MapReduce cluster. The name can contain 2 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce cluster resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class ClusterComponentConfigConfigArgsDict(TypedDict):
        config_file_name: pulumi.Input[_builtins.str]
        key: pulumi.Input[_builtins.str]
        value: pulumi.Input[_builtins.str]
elif False:
    ClusterComponentConfigConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterComponentConfigConfigArgs:
    def __init__(__self__, *,
                 config_file_name: pulumi.Input[_builtins.str],
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        pulumi.set(__self__, "config_file_name", config_file_name)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="configFileName")
    def config_file_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "config_file_name")

    @config_file_name.setter
    def config_file_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_file_name", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ClusterCustomNodeArgsDict(TypedDict):
        data_volume_count: pulumi.Input[_builtins.int]
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        flavor: pulumi.Input[_builtins.str]
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        group_name: pulumi.Input[_builtins.str]
        """
        Specifies the name of nodes for the node group.

        > **NOTE:** Only the custom_nodes has this argument
        """
        node_number: pulumi.Input[_builtins.int]
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        root_volume_size: pulumi.Input[_builtins.int]
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        root_volume_type: pulumi.Input[_builtins.str]
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        assigned_roles: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        auto_renew: NotRequired[pulumi.Input[_builtins.str]]
        charging_mode: NotRequired[pulumi.Input[_builtins.str]]
        data_volume_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        data_volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        host_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The host list of this nodes group in the cluster.
        """
        period: NotRequired[pulumi.Input[_builtins.int]]
        period_unit: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    ClusterCustomNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterCustomNodeArgs:
    def __init__(__self__, *,
                 data_volume_count: pulumi.Input[_builtins.int],
                 flavor: pulumi.Input[_builtins.str],
                 group_name: pulumi.Input[_builtins.str],
                 node_number: pulumi.Input[_builtins.int],
                 root_volume_size: pulumi.Input[_builtins.int],
                 root_volume_type: pulumi.Input[_builtins.str],
                 assigned_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 data_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 host_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] group_name: Specifies the name of nodes for the node group.
               
               > **NOTE:** Only the custom_nodes has this argument
        :param pulumi.Input[_builtins.int] node_number: Specifies the number of nodes for the node group.
               
               > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
               less than the number of nodes originally created.
        :param pulumi.Input[_builtins.int] root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
               
               **Role expression definition:**
               
               + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
               + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
               for example: `DataNode:1,2`. The subscript starts from 1.
               + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
               role_name[instance_count], for example: `EsNode[9]`.
               
               > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
               store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        :param pulumi.Input[_builtins.int] data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param pulumi.Input[_builtins.str] data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)

    @_builtins.property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "data_volume_count")

    @data_volume_count.setter
    def data_volume_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_volume_count", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of nodes for the node group.

        > **NOTE:** Only the custom_nodes has this argument
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "node_number", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "root_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "root_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        return pulumi.get(self, "assigned_roles")

    @assigned_roles.setter
    def assigned_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "assigned_roles", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @data_volume_size.setter
    def data_volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @data_volume_type.setter
    def data_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @host_ips.setter
    def host_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_ips", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)


if not MYPY:
    class ClusterExternalDatasourceArgsDict(TypedDict):
        component_name: pulumi.Input[_builtins.str]
        role_type: pulumi.Input[_builtins.str]
        source_type: pulumi.Input[_builtins.str]
        data_connection_id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    ClusterExternalDatasourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterExternalDatasourceArgs:
    def __init__(__self__, *,
                 component_name: pulumi.Input[_builtins.str],
                 role_type: pulumi.Input[_builtins.str],
                 source_type: pulumi.Input[_builtins.str],
                 data_connection_id: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "component_name", component_name)
        pulumi.set(__self__, "role_type", role_type)
        pulumi.set(__self__, "source_type", source_type)
        if data_connection_id is not None:
            pulumi.set(__self__, "data_connection_id", data_connection_id)

    @_builtins.property
    @pulumi.getter(name="componentName")
    def component_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "component_name")

    @component_name.setter
    def component_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "component_name", value)

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="dataConnectionId")
    def data_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "data_connection_id")

    @data_connection_id.setter
    def data_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_connection_id", value)


if not MYPY:
    class ClusterMasterNodesArgsDict(TypedDict):
        data_volume_count: pulumi.Input[_builtins.int]
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        flavor: pulumi.Input[_builtins.str]
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        node_number: pulumi.Input[_builtins.int]
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        root_volume_size: pulumi.Input[_builtins.int]
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        root_volume_type: pulumi.Input[_builtins.str]
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        assigned_roles: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        auto_renew: NotRequired[pulumi.Input[_builtins.str]]
        charging_mode: NotRequired[pulumi.Input[_builtins.str]]
        data_volume_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        data_volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        host_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The host list of this nodes group in the cluster.
        """
        period: NotRequired[pulumi.Input[_builtins.int]]
        period_unit: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    ClusterMasterNodesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMasterNodesArgs:
    def __init__(__self__, *,
                 data_volume_count: pulumi.Input[_builtins.int],
                 flavor: pulumi.Input[_builtins.str],
                 node_number: pulumi.Input[_builtins.int],
                 root_volume_size: pulumi.Input[_builtins.int],
                 root_volume_type: pulumi.Input[_builtins.str],
                 assigned_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 data_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 host_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.int] node_number: Specifies the number of nodes for the node group.
               
               > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
               less than the number of nodes originally created.
        :param pulumi.Input[_builtins.int] root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
               
               **Role expression definition:**
               
               + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
               + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
               for example: `DataNode:1,2`. The subscript starts from 1.
               + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
               role_name[instance_count], for example: `EsNode[9]`.
               
               > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
               store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        :param pulumi.Input[_builtins.int] data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param pulumi.Input[_builtins.str] data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)

    @_builtins.property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "data_volume_count")

    @data_volume_count.setter
    def data_volume_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_volume_count", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "node_number", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "root_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "root_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        return pulumi.get(self, "assigned_roles")

    @assigned_roles.setter
    def assigned_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "assigned_roles", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @data_volume_size.setter
    def data_volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @data_volume_type.setter
    def data_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @host_ips.setter
    def host_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_ips", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)


if not MYPY:
    class ClusterSmnNotifyArgsDict(TypedDict):
        subscription_name: pulumi.Input[_builtins.str]
        """
        The subscription rule name.
        """
        topic_urn: pulumi.Input[_builtins.str]
        """
        The Uniform Resource Name (URN) of the topic.
        """
elif False:
    ClusterSmnNotifyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterSmnNotifyArgs:
    def __init__(__self__, *,
                 subscription_name: pulumi.Input[_builtins.str],
                 topic_urn: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] subscription_name: The subscription rule name.
        :param pulumi.Input[_builtins.str] topic_urn: The Uniform Resource Name (URN) of the topic.
        """
        pulumi.set(__self__, "subscription_name", subscription_name)
        pulumi.set(__self__, "topic_urn", topic_urn)

    @_builtins.property
    @pulumi.getter(name="subscriptionName")
    def subscription_name(self) -> pulumi.Input[_builtins.str]:
        """
        The subscription rule name.
        """
        return pulumi.get(self, "subscription_name")

    @subscription_name.setter
    def subscription_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subscription_name", value)

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Input[_builtins.str]:
        """
        The Uniform Resource Name (URN) of the topic.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic_urn", value)


if not MYPY:
    class ClusterStreamingCoreNodesArgsDict(TypedDict):
        data_volume_count: pulumi.Input[_builtins.int]
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        flavor: pulumi.Input[_builtins.str]
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        node_number: pulumi.Input[_builtins.int]
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        root_volume_size: pulumi.Input[_builtins.int]
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        root_volume_type: pulumi.Input[_builtins.str]
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        assigned_roles: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        auto_renew: NotRequired[pulumi.Input[_builtins.str]]
        charging_mode: NotRequired[pulumi.Input[_builtins.str]]
        data_volume_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        data_volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        host_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The host list of this nodes group in the cluster.
        """
        period: NotRequired[pulumi.Input[_builtins.int]]
        period_unit: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    ClusterStreamingCoreNodesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterStreamingCoreNodesArgs:
    def __init__(__self__, *,
                 data_volume_count: pulumi.Input[_builtins.int],
                 flavor: pulumi.Input[_builtins.str],
                 node_number: pulumi.Input[_builtins.int],
                 root_volume_size: pulumi.Input[_builtins.int],
                 root_volume_type: pulumi.Input[_builtins.str],
                 assigned_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 data_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 host_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.int] node_number: Specifies the number of nodes for the node group.
               
               > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
               less than the number of nodes originally created.
        :param pulumi.Input[_builtins.int] root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
               
               **Role expression definition:**
               
               + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
               + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
               for example: `DataNode:1,2`. The subscript starts from 1.
               + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
               role_name[instance_count], for example: `EsNode[9]`.
               
               > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
               store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        :param pulumi.Input[_builtins.int] data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param pulumi.Input[_builtins.str] data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)

    @_builtins.property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "data_volume_count")

    @data_volume_count.setter
    def data_volume_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_volume_count", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "node_number", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "root_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "root_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        return pulumi.get(self, "assigned_roles")

    @assigned_roles.setter
    def assigned_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "assigned_roles", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @data_volume_size.setter
    def data_volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @data_volume_type.setter
    def data_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @host_ips.setter
    def host_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_ips", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)


if not MYPY:
    class ClusterStreamingTaskNodesArgsDict(TypedDict):
        data_volume_count: pulumi.Input[_builtins.int]
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        flavor: pulumi.Input[_builtins.str]
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        node_number: pulumi.Input[_builtins.int]
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        root_volume_size: pulumi.Input[_builtins.int]
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        root_volume_type: pulumi.Input[_builtins.str]
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        assigned_roles: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        data_volume_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        data_volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        host_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The host list of this nodes group in the cluster.
        """
elif False:
    ClusterStreamingTaskNodesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterStreamingTaskNodesArgs:
    def __init__(__self__, *,
                 data_volume_count: pulumi.Input[_builtins.int],
                 flavor: pulumi.Input[_builtins.str],
                 node_number: pulumi.Input[_builtins.int],
                 root_volume_size: pulumi.Input[_builtins.int],
                 root_volume_type: pulumi.Input[_builtins.str],
                 assigned_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 data_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 host_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.int] data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.int] node_number: Specifies the number of nodes for the node group.
               
               > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
               less than the number of nodes originally created.
        :param pulumi.Input[_builtins.int] root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param pulumi.Input[_builtins.str] root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
               
               **Role expression definition:**
               
               + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
               + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
               for example: `DataNode:1,2`. The subscript starts from 1.
               + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
               role_name[instance_count], for example: `EsNode[9]`.
               
               > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
               store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        :param pulumi.Input[_builtins.int] data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param pulumi.Input[_builtins.str] data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @_builtins.property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "data_volume_count")

    @data_volume_count.setter
    def data_volume_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_volume_count", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "node_number", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "root_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "root_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        return pulumi.get(self, "assigned_roles")

    @assigned_roles.setter
    def assigned_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "assigned_roles", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @data_volume_size.setter
    def data_volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @data_volume_type.setter
    def data_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @host_ips.setter
    def host_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_ips", value)


