# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 program_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 program_path: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 sql: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies an ID of the MapReduce cluster to which the job belongs to.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the MapReduce job. The name can contain 1 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce job resource.
               
               <!-- Placing the html block above list will lead to improperly rendered content -->
               * <a name="mapreduce_job_type">`type`</a> - (Required, String, ForceNew) Specifies the job type.
               The valid values are as follows:
               + Flink
               + HiveSql
               + HiveScript
               + MapReduce
               + SparkSubmit
               + SparkSql
               + SparkScript
               
               Changing this will create a new MapReduce job resource.
               
               > **NOTE:** Spark and Hive jobs can be added to only clusters including Spark and Hive components.
        :param pulumi.Input[_builtins.str] parameters: Specifies the parameters for the MapReduce job. Add an at sign (@) before
               each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
               This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
               MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] program_parameters: Specifies the the key/value pairs of the program parameters, such as
               thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
               can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
               **HiveScript**. Refer to the documents for each type of support key-values.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] program_path: Specifies the .jar package path or .py file path for program execution.
               The parameter must meet the following requirements:
               + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
               + The address cannot be empty or full of spaces.
               + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
               with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.
               
               Required if `type` is **MapReduce** or **SparkSubmit**. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the MapReduce job resource. If
               omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] service_parameters: Specifies the key/value pairs used to modify service configuration.
               Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] sql: Specifies the SQL command or file path. Only required if `type` is **HiveSql**
               or **SparkSql**. Changing this will create a new MapReduce job resource.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if program_parameters is not None:
            pulumi.set(__self__, "program_parameters", program_parameters)
        if program_path is not None:
            pulumi.set(__self__, "program_path", program_path)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_parameters is not None:
            pulumi.set(__self__, "service_parameters", service_parameters)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies an ID of the MapReduce cluster to which the job belongs to.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the MapReduce job. The name can contain 1 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce job resource.

        <!-- Placing the html block above list will lead to improperly rendered content -->
        * <a name="mapreduce_job_type">`type`</a> - (Required, String, ForceNew) Specifies the job type.
        The valid values are as follows:
        + Flink
        + HiveSql
        + HiveScript
        + MapReduce
        + SparkSubmit
        + SparkSql
        + SparkScript

        Changing this will create a new MapReduce job resource.

        > **NOTE:** Spark and Hive jobs can be added to only clusters including Spark and Hive components.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the parameters for the MapReduce job. Add an at sign (@) before
        each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
        This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
        MapReduce job resource.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="programParameters")
    def program_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the the key/value pairs of the program parameters, such as
        thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
        can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
        **HiveScript**. Refer to the documents for each type of support key-values.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "program_parameters")

    @program_parameters.setter
    def program_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "program_parameters", value)

    @_builtins.property
    @pulumi.getter(name="programPath")
    def program_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the .jar package path or .py file path for program execution.
        The parameter must meet the following requirements:
        + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
        + The address cannot be empty or full of spaces.
        + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
        with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.

        Required if `type` is **MapReduce** or **SparkSubmit**. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "program_path")

    @program_path.setter
    def program_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "program_path", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the MapReduce job resource. If
        omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceParameters")
    def service_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs used to modify service configuration.
        Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "service_parameters")

    @service_parameters.setter
    def service_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_parameters", value)

    @_builtins.property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SQL command or file path. Only required if `type` is **HiveSql**
        or **SparkSql**. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 finish_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 program_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 program_path: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 sql: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 submit_time: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies an ID of the MapReduce cluster to which the job belongs to.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] finish_time: The completion time of the MapReduce job.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the MapReduce job. The name can contain 1 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce job resource.
               
               <!-- Placing the html block above list will lead to improperly rendered content -->
               * <a name="mapreduce_job_type">`type`</a> - (Required, String, ForceNew) Specifies the job type.
               The valid values are as follows:
               + Flink
               + HiveSql
               + HiveScript
               + MapReduce
               + SparkSubmit
               + SparkSql
               + SparkScript
               
               Changing this will create a new MapReduce job resource.
               
               > **NOTE:** Spark and Hive jobs can be added to only clusters including Spark and Hive components.
        :param pulumi.Input[_builtins.str] parameters: Specifies the parameters for the MapReduce job. Add an at sign (@) before
               each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
               This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
               MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] program_parameters: Specifies the the key/value pairs of the program parameters, such as
               thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
               can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
               **HiveScript**. Refer to the documents for each type of support key-values.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] program_path: Specifies the .jar package path or .py file path for program execution.
               The parameter must meet the following requirements:
               + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
               + The address cannot be empty or full of spaces.
               + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
               with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.
               
               Required if `type` is **MapReduce** or **SparkSubmit**. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the MapReduce job resource. If
               omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] service_parameters: Specifies the key/value pairs used to modify service configuration.
               Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] sql: Specifies the SQL command or file path. Only required if `type` is **HiveSql**
               or **SparkSql**. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] start_time: The creation time of the MapReduce job.
        :param pulumi.Input[_builtins.str] status: Status of the MapReduce job.
        :param pulumi.Input[_builtins.str] submit_time: The submission time of the MapReduce job.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if finish_time is not None:
            pulumi.set(__self__, "finish_time", finish_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if program_parameters is not None:
            pulumi.set(__self__, "program_parameters", program_parameters)
        if program_path is not None:
            pulumi.set(__self__, "program_path", program_path)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_parameters is not None:
            pulumi.set(__self__, "service_parameters", service_parameters)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if submit_time is not None:
            pulumi.set(__self__, "submit_time", submit_time)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an ID of the MapReduce cluster to which the job belongs to.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The completion time of the MapReduce job.
        """
        return pulumi.get(self, "finish_time")

    @finish_time.setter
    def finish_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "finish_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the MapReduce job. The name can contain 1 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce job resource.

        <!-- Placing the html block above list will lead to improperly rendered content -->
        * <a name="mapreduce_job_type">`type`</a> - (Required, String, ForceNew) Specifies the job type.
        The valid values are as follows:
        + Flink
        + HiveSql
        + HiveScript
        + MapReduce
        + SparkSubmit
        + SparkSql
        + SparkScript

        Changing this will create a new MapReduce job resource.

        > **NOTE:** Spark and Hive jobs can be added to only clusters including Spark and Hive components.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the parameters for the MapReduce job. Add an at sign (@) before
        each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
        This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
        MapReduce job resource.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="programParameters")
    def program_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the the key/value pairs of the program parameters, such as
        thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
        can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
        **HiveScript**. Refer to the documents for each type of support key-values.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "program_parameters")

    @program_parameters.setter
    def program_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "program_parameters", value)

    @_builtins.property
    @pulumi.getter(name="programPath")
    def program_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the .jar package path or .py file path for program execution.
        The parameter must meet the following requirements:
        + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
        + The address cannot be empty or full of spaces.
        + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
        with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.

        Required if `type` is **MapReduce** or **SparkSubmit**. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "program_path")

    @program_path.setter
    def program_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "program_path", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the MapReduce job resource. If
        omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceParameters")
    def service_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs used to modify service configuration.
        Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "service_parameters")

    @service_parameters.setter
    def service_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_parameters", value)

    @_builtins.property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SQL command or file path. Only required if `type` is **HiveSql**
        or **SparkSql**. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the MapReduce job.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the MapReduce job.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="submitTime")
    def submit_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The submission time of the MapReduce job.
        """
        return pulumi.get(self, "submit_time")

    @submit_time.setter
    def submit_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "submit_time", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("sbercloud:Mrs/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 program_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 program_path: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 sql: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage a job resource within SberCloud MRS.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        job_name = config.require_object("jobName")
        program_path = config.require_object("programPath")
        access_key = config.require_object("accessKey")
        secret_key = config.require_object("secretKey")
        test1 = sbercloud.mrs.Job("test_1",
            cluster_id=cluster_id,
            type="SparkSubmit",
            name=job_name,
            program_path=program_path,
            parameters=f"{access_key} {secret_key} 1 obs://obs-demo-analysis/input obs://obs-demo-analysis/output",
            program_parameters={
                "--class": "com.sbercloud.bigdata.spark.examples.DriverBehavior",
            })
        ```

        ## Import

        MapReduce jobs can be imported using their `id` and the IDs of the MapReduce cluster to which the job belongs, separated
        by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:Mrs/job:Job test <cluster_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies an ID of the MapReduce cluster to which the job belongs to.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the MapReduce job. The name can contain 1 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce job resource.
               
               <!-- Placing the html block above list will lead to improperly rendered content -->
               * <a name="mapreduce_job_type">`type`</a> - (Required, String, ForceNew) Specifies the job type.
               The valid values are as follows:
               + Flink
               + HiveSql
               + HiveScript
               + MapReduce
               + SparkSubmit
               + SparkSql
               + SparkScript
               
               Changing this will create a new MapReduce job resource.
               
               > **NOTE:** Spark and Hive jobs can be added to only clusters including Spark and Hive components.
        :param pulumi.Input[_builtins.str] parameters: Specifies the parameters for the MapReduce job. Add an at sign (@) before
               each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
               This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
               MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] program_parameters: Specifies the the key/value pairs of the program parameters, such as
               thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
               can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
               **HiveScript**. Refer to the documents for each type of support key-values.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] program_path: Specifies the .jar package path or .py file path for program execution.
               The parameter must meet the following requirements:
               + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
               + The address cannot be empty or full of spaces.
               + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
               with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.
               
               Required if `type` is **MapReduce** or **SparkSubmit**. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the MapReduce job resource. If
               omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] service_parameters: Specifies the key/value pairs used to modify service configuration.
               Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] sql: Specifies the SQL command or file path. Only required if `type` is **HiveSql**
               or **SparkSql**. Changing this will create a new MapReduce job resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage a job resource within SberCloud MRS.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        job_name = config.require_object("jobName")
        program_path = config.require_object("programPath")
        access_key = config.require_object("accessKey")
        secret_key = config.require_object("secretKey")
        test1 = sbercloud.mrs.Job("test_1",
            cluster_id=cluster_id,
            type="SparkSubmit",
            name=job_name,
            program_path=program_path,
            parameters=f"{access_key} {secret_key} 1 obs://obs-demo-analysis/input obs://obs-demo-analysis/output",
            program_parameters={
                "--class": "com.sbercloud.bigdata.spark.examples.DriverBehavior",
            })
        ```

        ## Import

        MapReduce jobs can be imported using their `id` and the IDs of the MapReduce cluster to which the job belongs, separated
        by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:Mrs/job:Job test <cluster_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 program_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 program_path: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 sql: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["program_parameters"] = program_parameters
            __props__.__dict__["program_path"] = program_path
            __props__.__dict__["region"] = region
            __props__.__dict__["service_parameters"] = service_parameters
            __props__.__dict__["sql"] = sql
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["finish_time"] = None
            __props__.__dict__["start_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["submit_time"] = None
        super(Job, __self__).__init__(
            'sbercloud:Mrs/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            finish_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[_builtins.str]] = None,
            program_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            program_path: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            sql: Optional[pulumi.Input[_builtins.str]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            submit_time: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies an ID of the MapReduce cluster to which the job belongs to.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] finish_time: The completion time of the MapReduce job.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the MapReduce job. The name can contain 1 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce job resource.
               
               <!-- Placing the html block above list will lead to improperly rendered content -->
               * <a name="mapreduce_job_type">`type`</a> - (Required, String, ForceNew) Specifies the job type.
               The valid values are as follows:
               + Flink
               + HiveSql
               + HiveScript
               + MapReduce
               + SparkSubmit
               + SparkSql
               + SparkScript
               
               Changing this will create a new MapReduce job resource.
               
               > **NOTE:** Spark and Hive jobs can be added to only clusters including Spark and Hive components.
        :param pulumi.Input[_builtins.str] parameters: Specifies the parameters for the MapReduce job. Add an at sign (@) before
               each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
               This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
               MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] program_parameters: Specifies the the key/value pairs of the program parameters, such as
               thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
               can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
               **HiveScript**. Refer to the documents for each type of support key-values.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] program_path: Specifies the .jar package path or .py file path for program execution.
               The parameter must meet the following requirements:
               + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
               + The address cannot be empty or full of spaces.
               + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
               with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.
               
               Required if `type` is **MapReduce** or **SparkSubmit**. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the MapReduce job resource. If
               omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] service_parameters: Specifies the key/value pairs used to modify service configuration.
               Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] sql: Specifies the SQL command or file path. Only required if `type` is **HiveSql**
               or **SparkSql**. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[_builtins.str] start_time: The creation time of the MapReduce job.
        :param pulumi.Input[_builtins.str] status: Status of the MapReduce job.
        :param pulumi.Input[_builtins.str] submit_time: The submission time of the MapReduce job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["finish_time"] = finish_time
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["program_parameters"] = program_parameters
        __props__.__dict__["program_path"] = program_path
        __props__.__dict__["region"] = region
        __props__.__dict__["service_parameters"] = service_parameters
        __props__.__dict__["sql"] = sql
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["status"] = status
        __props__.__dict__["submit_time"] = submit_time
        __props__.__dict__["type"] = type
        return Job(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies an ID of the MapReduce cluster to which the job belongs to.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> pulumi.Output[_builtins.str]:
        """
        The completion time of the MapReduce job.
        """
        return pulumi.get(self, "finish_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the MapReduce job. The name can contain 1 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce job resource.

        <!-- Placing the html block above list will lead to improperly rendered content -->
        * <a name="mapreduce_job_type">`type`</a> - (Required, String, ForceNew) Specifies the job type.
        The valid values are as follows:
        + Flink
        + HiveSql
        + HiveScript
        + MapReduce
        + SparkSubmit
        + SparkSql
        + SparkScript

        Changing this will create a new MapReduce job resource.

        > **NOTE:** Spark and Hive jobs can be added to only clusters including Spark and Hive components.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the parameters for the MapReduce job. Add an at sign (@) before
        each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
        This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
        MapReduce job resource.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="programParameters")
    def program_parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the the key/value pairs of the program parameters, such as
        thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
        can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
        **HiveScript**. Refer to the documents for each type of support key-values.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "program_parameters")

    @_builtins.property
    @pulumi.getter(name="programPath")
    def program_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the .jar package path or .py file path for program execution.
        The parameter must meet the following requirements:
        + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
        + The address cannot be empty or full of spaces.
        + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
        with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.

        Required if `type` is **MapReduce** or **SparkSubmit**. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "program_path")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the MapReduce job resource. If
        omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceParameters")
    def service_parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs used to modify service configuration.
        Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "service_parameters")

    @_builtins.property
    @pulumi.getter
    def sql(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the SQL command or file path. Only required if `type` is **HiveSql**
        or **SparkSql**. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "sql")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the MapReduce job.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the MapReduce job.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="submitTime")
    def submit_time(self) -> pulumi.Output[_builtins.str]:
        """
        The submission time of the MapReduce job.
        """
        return pulumi.get(self, "submit_time")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "type")

