# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterAnalysisCoreNodes',
    'ClusterAnalysisTaskNodes',
    'ClusterBootstrapScript',
    'ClusterComponentConfig',
    'ClusterComponentConfigConfig',
    'ClusterCustomNode',
    'ClusterExternalDatasource',
    'ClusterMasterNodes',
    'ClusterSmnNotify',
    'ClusterStreamingCoreNodes',
    'ClusterStreamingTaskNodes',
]

@pulumi.output_type
class ClusterAnalysisCoreNodes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeCount":
            suggest = "data_volume_count"
        elif key == "nodeNumber":
            suggest = "node_number"
        elif key == "rootVolumeSize":
            suggest = "root_volume_size"
        elif key == "rootVolumeType":
            suggest = "root_volume_type"
        elif key == "assignedRoles":
            suggest = "assigned_roles"
        elif key == "autoRenew":
            suggest = "auto_renew"
        elif key == "chargingMode":
            suggest = "charging_mode"
        elif key == "dataVolumeSize":
            suggest = "data_volume_size"
        elif key == "dataVolumeType":
            suggest = "data_volume_type"
        elif key == "hostIps":
            suggest = "host_ips"
        elif key == "periodUnit":
            suggest = "period_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAnalysisCoreNodes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAnalysisCoreNodes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAnalysisCoreNodes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_count: _builtins.int,
                 flavor: _builtins.str,
                 node_number: _builtins.int,
                 root_volume_size: _builtins.int,
                 root_volume_type: _builtins.str,
                 assigned_roles: Optional[Sequence[_builtins.str]] = None,
                 auto_renew: Optional[_builtins.str] = None,
                 charging_mode: Optional[_builtins.str] = None,
                 data_volume_size: Optional[_builtins.int] = None,
                 data_volume_type: Optional[_builtins.str] = None,
                 host_ips: Optional[Sequence[_builtins.str]] = None,
                 period: Optional[_builtins.int] = None,
                 period_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.int data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               
               Changing this will create a new MapReduce cluster resource.
        :param _builtins.str flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param _builtins.int node_number: Specifies the number of nodes for the node group.
               
               > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
               less than the number of nodes originally created.
        :param _builtins.int root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param _builtins.str root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param Sequence[_builtins.str] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
               
               **Role expression definition:**
               
               + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
               + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
               for example: `DataNode:1,2`. The subscript starts from 1.
               + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
               role_name[instance_count], for example: `EsNode[9]`.
               
               > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
               store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        :param _builtins.int data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param _builtins.str data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param Sequence[_builtins.str] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)

    @_builtins.property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> _builtins.int:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "data_volume_count")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> _builtins.str:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> _builtins.int:
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        return pulumi.get(self, "node_number")

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> _builtins.int:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> _builtins.str:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @_builtins.property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        return pulumi.get(self, "assigned_roles")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[_builtins.int]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @_builtins.property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[_builtins.str]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @_builtins.property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "period_unit")


@pulumi.output_type
class ClusterAnalysisTaskNodes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeCount":
            suggest = "data_volume_count"
        elif key == "nodeNumber":
            suggest = "node_number"
        elif key == "rootVolumeSize":
            suggest = "root_volume_size"
        elif key == "rootVolumeType":
            suggest = "root_volume_type"
        elif key == "assignedRoles":
            suggest = "assigned_roles"
        elif key == "dataVolumeSize":
            suggest = "data_volume_size"
        elif key == "dataVolumeType":
            suggest = "data_volume_type"
        elif key == "hostIps":
            suggest = "host_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAnalysisTaskNodes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAnalysisTaskNodes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAnalysisTaskNodes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_count: _builtins.int,
                 flavor: _builtins.str,
                 node_number: _builtins.int,
                 root_volume_size: _builtins.int,
                 root_volume_type: _builtins.str,
                 assigned_roles: Optional[Sequence[_builtins.str]] = None,
                 data_volume_size: Optional[_builtins.int] = None,
                 data_volume_type: Optional[_builtins.str] = None,
                 host_ips: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.int data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               
               Changing this will create a new MapReduce cluster resource.
        :param _builtins.str flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param _builtins.int node_number: Specifies the number of nodes for the node group.
               
               > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
               less than the number of nodes originally created.
        :param _builtins.int root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param _builtins.str root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param Sequence[_builtins.str] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
               
               **Role expression definition:**
               
               + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
               + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
               for example: `DataNode:1,2`. The subscript starts from 1.
               + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
               role_name[instance_count], for example: `EsNode[9]`.
               
               > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
               store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        :param _builtins.int data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param _builtins.str data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param Sequence[_builtins.str] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @_builtins.property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> _builtins.int:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "data_volume_count")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> _builtins.str:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> _builtins.int:
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        return pulumi.get(self, "node_number")

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> _builtins.int:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> _builtins.str:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @_builtins.property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        return pulumi.get(self, "assigned_roles")

    @_builtins.property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[_builtins.int]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @_builtins.property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[_builtins.str]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @_builtins.property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")


@pulumi.output_type
class ClusterBootstrapScript(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failAction":
            suggest = "fail_action"
        elif key == "activeMaster":
            suggest = "active_master"
        elif key == "beforeComponentStart":
            suggest = "before_component_start"
        elif key == "executeNeedSudoRoot":
            suggest = "execute_need_sudo_root"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBootstrapScript. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBootstrapScript.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBootstrapScript.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fail_action: _builtins.str,
                 name: _builtins.str,
                 nodes: Sequence[_builtins.str],
                 uri: _builtins.str,
                 active_master: Optional[_builtins.bool] = None,
                 before_component_start: Optional[_builtins.bool] = None,
                 execute_need_sudo_root: Optional[_builtins.bool] = None,
                 parameters: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str fail_action: The action after the bootstrap action script fails to be executed.
        :param _builtins.str name: Specifies the name of the MapReduce cluster. The name can contain 2 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce cluster resource.
        :param Sequence[_builtins.str] nodes: Name of the node group where the bootstrap action script is executed.
        :param _builtins.str uri: Path of a bootstrap action script. Set this parameter to an OBS bucket path or a local VM path.
        :param _builtins.bool active_master: Whether the bootstrap action script runs only on active master nodes.
        :param _builtins.bool before_component_start: Whether the bootstrap action script is executed before component start.
        :param _builtins.bool execute_need_sudo_root: Whether the bootstrap action script involves root user operations.
        :param _builtins.str parameters: Bootstrap action script parameters.
        :param _builtins.str start_time: The execution time of one bootstrap action script, in RFC-3339 format.
        :param _builtins.str state: The status of one bootstrap action script.
        """
        pulumi.set(__self__, "fail_action", fail_action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "uri", uri)
        if active_master is not None:
            pulumi.set(__self__, "active_master", active_master)
        if before_component_start is not None:
            pulumi.set(__self__, "before_component_start", before_component_start)
        if execute_need_sudo_root is not None:
            pulumi.set(__self__, "execute_need_sudo_root", execute_need_sudo_root)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="failAction")
    def fail_action(self) -> _builtins.str:
        """
        The action after the bootstrap action script fails to be executed.
        """
        return pulumi.get(self, "fail_action")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the MapReduce cluster. The name can contain 2 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce cluster resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Sequence[_builtins.str]:
        """
        Name of the node group where the bootstrap action script is executed.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        Path of a bootstrap action script. Set this parameter to an OBS bucket path or a local VM path.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter(name="activeMaster")
    def active_master(self) -> Optional[_builtins.bool]:
        """
        Whether the bootstrap action script runs only on active master nodes.
        """
        return pulumi.get(self, "active_master")

    @_builtins.property
    @pulumi.getter(name="beforeComponentStart")
    def before_component_start(self) -> Optional[_builtins.bool]:
        """
        Whether the bootstrap action script is executed before component start.
        """
        return pulumi.get(self, "before_component_start")

    @_builtins.property
    @pulumi.getter(name="executeNeedSudoRoot")
    def execute_need_sudo_root(self) -> Optional[_builtins.bool]:
        """
        Whether the bootstrap action script involves root user operations.
        """
        return pulumi.get(self, "execute_need_sudo_root")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[_builtins.str]:
        """
        Bootstrap action script parameters.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        The execution time of one bootstrap action script, in RFC-3339 format.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The status of one bootstrap action script.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ClusterComponentConfig(dict):
    def __init__(__self__, *,
                 configs: Sequence['outputs.ClusterComponentConfigConfig'],
                 name: _builtins.str):
        """
        :param _builtins.str name: Specifies the name of the MapReduce cluster. The name can contain 2 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce cluster resource.
        """
        pulumi.set(__self__, "configs", configs)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.ClusterComponentConfigConfig']:
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the MapReduce cluster. The name can contain 2 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce cluster resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ClusterComponentConfigConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configFileName":
            suggest = "config_file_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterComponentConfigConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterComponentConfigConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterComponentConfigConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_file_name: _builtins.str,
                 key: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "config_file_name", config_file_name)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="configFileName")
    def config_file_name(self) -> _builtins.str:
        return pulumi.get(self, "config_file_name")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ClusterCustomNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeCount":
            suggest = "data_volume_count"
        elif key == "groupName":
            suggest = "group_name"
        elif key == "nodeNumber":
            suggest = "node_number"
        elif key == "rootVolumeSize":
            suggest = "root_volume_size"
        elif key == "rootVolumeType":
            suggest = "root_volume_type"
        elif key == "assignedRoles":
            suggest = "assigned_roles"
        elif key == "autoRenew":
            suggest = "auto_renew"
        elif key == "chargingMode":
            suggest = "charging_mode"
        elif key == "dataVolumeSize":
            suggest = "data_volume_size"
        elif key == "dataVolumeType":
            suggest = "data_volume_type"
        elif key == "hostIps":
            suggest = "host_ips"
        elif key == "periodUnit":
            suggest = "period_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCustomNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCustomNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCustomNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_count: _builtins.int,
                 flavor: _builtins.str,
                 group_name: _builtins.str,
                 node_number: _builtins.int,
                 root_volume_size: _builtins.int,
                 root_volume_type: _builtins.str,
                 assigned_roles: Optional[Sequence[_builtins.str]] = None,
                 auto_renew: Optional[_builtins.str] = None,
                 charging_mode: Optional[_builtins.str] = None,
                 data_volume_size: Optional[_builtins.int] = None,
                 data_volume_type: Optional[_builtins.str] = None,
                 host_ips: Optional[Sequence[_builtins.str]] = None,
                 period: Optional[_builtins.int] = None,
                 period_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.int data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               
               Changing this will create a new MapReduce cluster resource.
        :param _builtins.str flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param _builtins.str group_name: Specifies the name of nodes for the node group.
               
               > **NOTE:** Only the custom_nodes has this argument
        :param _builtins.int node_number: Specifies the number of nodes for the node group.
               
               > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
               less than the number of nodes originally created.
        :param _builtins.int root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param _builtins.str root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param Sequence[_builtins.str] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
               
               **Role expression definition:**
               
               + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
               + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
               for example: `DataNode:1,2`. The subscript starts from 1.
               + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
               role_name[instance_count], for example: `EsNode[9]`.
               
               > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
               store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        :param _builtins.int data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param _builtins.str data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param Sequence[_builtins.str] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)

    @_builtins.property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> _builtins.int:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "data_volume_count")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> _builtins.str:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> _builtins.str:
        """
        Specifies the name of nodes for the node group.

        > **NOTE:** Only the custom_nodes has this argument
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> _builtins.int:
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        return pulumi.get(self, "node_number")

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> _builtins.int:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> _builtins.str:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @_builtins.property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        return pulumi.get(self, "assigned_roles")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[_builtins.int]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @_builtins.property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[_builtins.str]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @_builtins.property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "period_unit")


@pulumi.output_type
class ClusterExternalDatasource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentName":
            suggest = "component_name"
        elif key == "roleType":
            suggest = "role_type"
        elif key == "sourceType":
            suggest = "source_type"
        elif key == "dataConnectionId":
            suggest = "data_connection_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterExternalDatasource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterExternalDatasource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterExternalDatasource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_name: _builtins.str,
                 role_type: _builtins.str,
                 source_type: _builtins.str,
                 data_connection_id: Optional[_builtins.str] = None):
        pulumi.set(__self__, "component_name", component_name)
        pulumi.set(__self__, "role_type", role_type)
        pulumi.set(__self__, "source_type", source_type)
        if data_connection_id is not None:
            pulumi.set(__self__, "data_connection_id", data_connection_id)

    @_builtins.property
    @pulumi.getter(name="componentName")
    def component_name(self) -> _builtins.str:
        return pulumi.get(self, "component_name")

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> _builtins.str:
        return pulumi.get(self, "role_type")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="dataConnectionId")
    def data_connection_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "data_connection_id")


@pulumi.output_type
class ClusterMasterNodes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeCount":
            suggest = "data_volume_count"
        elif key == "nodeNumber":
            suggest = "node_number"
        elif key == "rootVolumeSize":
            suggest = "root_volume_size"
        elif key == "rootVolumeType":
            suggest = "root_volume_type"
        elif key == "assignedRoles":
            suggest = "assigned_roles"
        elif key == "autoRenew":
            suggest = "auto_renew"
        elif key == "chargingMode":
            suggest = "charging_mode"
        elif key == "dataVolumeSize":
            suggest = "data_volume_size"
        elif key == "dataVolumeType":
            suggest = "data_volume_type"
        elif key == "hostIps":
            suggest = "host_ips"
        elif key == "periodUnit":
            suggest = "period_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterNodes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterNodes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterNodes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_count: _builtins.int,
                 flavor: _builtins.str,
                 node_number: _builtins.int,
                 root_volume_size: _builtins.int,
                 root_volume_type: _builtins.str,
                 assigned_roles: Optional[Sequence[_builtins.str]] = None,
                 auto_renew: Optional[_builtins.str] = None,
                 charging_mode: Optional[_builtins.str] = None,
                 data_volume_size: Optional[_builtins.int] = None,
                 data_volume_type: Optional[_builtins.str] = None,
                 host_ips: Optional[Sequence[_builtins.str]] = None,
                 period: Optional[_builtins.int] = None,
                 period_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.int data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               
               Changing this will create a new MapReduce cluster resource.
        :param _builtins.str flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param _builtins.int node_number: Specifies the number of nodes for the node group.
               
               > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
               less than the number of nodes originally created.
        :param _builtins.int root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param _builtins.str root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param Sequence[_builtins.str] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
               
               **Role expression definition:**
               
               + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
               + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
               for example: `DataNode:1,2`. The subscript starts from 1.
               + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
               role_name[instance_count], for example: `EsNode[9]`.
               
               > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
               store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        :param _builtins.int data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param _builtins.str data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param Sequence[_builtins.str] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)

    @_builtins.property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> _builtins.int:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "data_volume_count")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> _builtins.str:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> _builtins.int:
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        return pulumi.get(self, "node_number")

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> _builtins.int:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> _builtins.str:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @_builtins.property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        return pulumi.get(self, "assigned_roles")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[_builtins.int]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @_builtins.property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[_builtins.str]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @_builtins.property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "period_unit")


@pulumi.output_type
class ClusterSmnNotify(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subscriptionName":
            suggest = "subscription_name"
        elif key == "topicUrn":
            suggest = "topic_urn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterSmnNotify. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterSmnNotify.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterSmnNotify.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subscription_name: _builtins.str,
                 topic_urn: _builtins.str):
        """
        :param _builtins.str subscription_name: The subscription rule name.
        :param _builtins.str topic_urn: The Uniform Resource Name (URN) of the topic.
        """
        pulumi.set(__self__, "subscription_name", subscription_name)
        pulumi.set(__self__, "topic_urn", topic_urn)

    @_builtins.property
    @pulumi.getter(name="subscriptionName")
    def subscription_name(self) -> _builtins.str:
        """
        The subscription rule name.
        """
        return pulumi.get(self, "subscription_name")

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> _builtins.str:
        """
        The Uniform Resource Name (URN) of the topic.
        """
        return pulumi.get(self, "topic_urn")


@pulumi.output_type
class ClusterStreamingCoreNodes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeCount":
            suggest = "data_volume_count"
        elif key == "nodeNumber":
            suggest = "node_number"
        elif key == "rootVolumeSize":
            suggest = "root_volume_size"
        elif key == "rootVolumeType":
            suggest = "root_volume_type"
        elif key == "assignedRoles":
            suggest = "assigned_roles"
        elif key == "autoRenew":
            suggest = "auto_renew"
        elif key == "chargingMode":
            suggest = "charging_mode"
        elif key == "dataVolumeSize":
            suggest = "data_volume_size"
        elif key == "dataVolumeType":
            suggest = "data_volume_type"
        elif key == "hostIps":
            suggest = "host_ips"
        elif key == "periodUnit":
            suggest = "period_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStreamingCoreNodes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStreamingCoreNodes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStreamingCoreNodes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_count: _builtins.int,
                 flavor: _builtins.str,
                 node_number: _builtins.int,
                 root_volume_size: _builtins.int,
                 root_volume_type: _builtins.str,
                 assigned_roles: Optional[Sequence[_builtins.str]] = None,
                 auto_renew: Optional[_builtins.str] = None,
                 charging_mode: Optional[_builtins.str] = None,
                 data_volume_size: Optional[_builtins.int] = None,
                 data_volume_type: Optional[_builtins.str] = None,
                 host_ips: Optional[Sequence[_builtins.str]] = None,
                 period: Optional[_builtins.int] = None,
                 period_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.int data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               
               Changing this will create a new MapReduce cluster resource.
        :param _builtins.str flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param _builtins.int node_number: Specifies the number of nodes for the node group.
               
               > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
               less than the number of nodes originally created.
        :param _builtins.int root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param _builtins.str root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param Sequence[_builtins.str] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
               
               **Role expression definition:**
               
               + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
               + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
               for example: `DataNode:1,2`. The subscript starts from 1.
               + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
               role_name[instance_count], for example: `EsNode[9]`.
               
               > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
               store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        :param _builtins.int data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param _builtins.str data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param Sequence[_builtins.str] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)

    @_builtins.property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> _builtins.int:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "data_volume_count")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> _builtins.str:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> _builtins.int:
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        return pulumi.get(self, "node_number")

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> _builtins.int:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> _builtins.str:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @_builtins.property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        return pulumi.get(self, "assigned_roles")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[_builtins.int]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @_builtins.property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[_builtins.str]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @_builtins.property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "period_unit")


@pulumi.output_type
class ClusterStreamingTaskNodes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeCount":
            suggest = "data_volume_count"
        elif key == "nodeNumber":
            suggest = "node_number"
        elif key == "rootVolumeSize":
            suggest = "root_volume_size"
        elif key == "rootVolumeType":
            suggest = "root_volume_type"
        elif key == "assignedRoles":
            suggest = "assigned_roles"
        elif key == "dataVolumeSize":
            suggest = "data_volume_size"
        elif key == "dataVolumeType":
            suggest = "data_volume_type"
        elif key == "hostIps":
            suggest = "host_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStreamingTaskNodes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStreamingTaskNodes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStreamingTaskNodes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_count: _builtins.int,
                 flavor: _builtins.str,
                 node_number: _builtins.int,
                 root_volume_size: _builtins.int,
                 root_volume_type: _builtins.str,
                 assigned_roles: Optional[Sequence[_builtins.str]] = None,
                 data_volume_size: Optional[_builtins.int] = None,
                 data_volume_type: Optional[_builtins.str] = None,
                 host_ips: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.int data_volume_count: Specifies the data disk number of the nodes. The number configuration
               of each node are as follows:
               + master_nodes: 1.
               + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
               + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
               
               Changing this will create a new MapReduce cluster resource.
        :param _builtins.str flavor: Specifies the instance specifications for each nodes in node group.
               Changing this will create a new MapReduce cluster resource.
        :param _builtins.int node_number: Specifies the number of nodes for the node group.
               
               > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
               less than the number of nodes originally created.
        :param _builtins.int root_volume_size: Specifies the system disk size of the nodes. Changing this will create
               a new MapReduce cluster resource.
        :param _builtins.str root_volume_type: Specifies the system disk flavor of the nodes. Changing this will
               create a new MapReduce cluster resource.
        :param Sequence[_builtins.str] assigned_roles: Specifies the roles deployed in a node group.This argument is mandatory
               when the cluster type is CUSTOM. Each character string represents a role expression.
               
               **Role expression definition:**
               
               + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
               + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
               for example: `DataNode:1,2`. The subscript starts from 1.
               + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
               role_name[instance_count], for example: `EsNode[9]`.
               
               > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
               store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        :param _builtins.int data_volume_size: Specifies the data disk size of the nodes,in GB. The value range is 10
               to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
               cluster resource.
        :param _builtins.str data_volume_type: Specifies the data disk flavor of the nodes.
               Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
               The following disk types are supported:
               + `SATA`: common I/O disk
               + `SAS`: high I/O disk
               + `SSD`: ultra-high I/O disk
        :param Sequence[_builtins.str] host_ips: The host list of this nodes group in the cluster.
        """
        pulumi.set(__self__, "data_volume_count", data_volume_count)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "root_volume_size", root_volume_size)
        pulumi.set(__self__, "root_volume_type", root_volume_type)
        if assigned_roles is not None:
            pulumi.set(__self__, "assigned_roles", assigned_roles)
        if data_volume_size is not None:
            pulumi.set(__self__, "data_volume_size", data_volume_size)
        if data_volume_type is not None:
            pulumi.set(__self__, "data_volume_type", data_volume_type)
        if host_ips is not None:
            pulumi.set(__self__, "host_ips", host_ips)

    @_builtins.property
    @pulumi.getter(name="dataVolumeCount")
    def data_volume_count(self) -> _builtins.int:
        """
        Specifies the data disk number of the nodes. The number configuration
        of each node are as follows:
        + master_nodes: 1.
        + analysis_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_core_nodes: minimum is one and the maximum is subject to the configuration of the corresponding flavor.
        + analysis_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.
        + streaming_task_nodes: minimum is zero and the maximum is subject to the configuration of the corresponding flavor.

        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "data_volume_count")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> _builtins.str:
        """
        Specifies the instance specifications for each nodes in node group.
        Changing this will create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> _builtins.int:
        """
        Specifies the number of nodes for the node group.

        > **NOTE:** Only the core group and task group updations are allowed. The number of nodes after scaling cannot be
        less than the number of nodes originally created.
        """
        return pulumi.get(self, "node_number")

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> _builtins.int:
        """
        Specifies the system disk size of the nodes. Changing this will create
        a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_size")

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> _builtins.str:
        """
        Specifies the system disk flavor of the nodes. Changing this will
        create a new MapReduce cluster resource.
        """
        return pulumi.get(self, "root_volume_type")

    @_builtins.property
    @pulumi.getter(name="assignedRoles")
    def assigned_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the roles deployed in a node group.This argument is mandatory
        when the cluster type is CUSTOM. Each character string represents a role expression.

        **Role expression definition:**

        + If the role is deployed on all nodes in the node group, set this parameter to role_name, for example: `DataNode`.
        + If the role is deployed on a specified subscript node in the node group: role_name:index1,index2..., indexN,
        for example: `DataNode:1,2`. The subscript starts from 1.
        + Some roles support multi-instance deployment (that is, multiple instances of the same role are deployed on a node):
        role_name[instance_count], for example: `EsNode[9]`.

        > `DBService` is a basic component of a cluster. Components such as Hive, Hue, Oozie, Loader, and Redis, and Loader
        store their metadata in DBService, and provide the metadata backup and restoration functions by using DBService.
        """
        return pulumi.get(self, "assigned_roles")

    @_builtins.property
    @pulumi.getter(name="dataVolumeSize")
    def data_volume_size(self) -> Optional[_builtins.int]:
        """
        Specifies the data disk size of the nodes,in GB. The value range is 10
        to 32768. Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce
        cluster resource.
        """
        return pulumi.get(self, "data_volume_size")

    @_builtins.property
    @pulumi.getter(name="dataVolumeType")
    def data_volume_type(self) -> Optional[_builtins.str]:
        """
        Specifies the data disk flavor of the nodes.
        Required if `data_volume_count` is greater than zero. Changing this will create a new MapReduce cluster resource.
        The following disk types are supported:
        + `SATA`: common I/O disk
        + `SAS`: high I/O disk
        + `SSD`: ultra-high I/O disk
        """
        return pulumi.get(self, "data_volume_type")

    @_builtins.property
    @pulumi.getter(name="hostIps")
    def host_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        The host list of this nodes group in the cluster.
        """
        return pulumi.get(self, "host_ips")


