# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DnatRuleArgs', 'DnatRule']

@pulumi.input_type
class DnatRuleArgs:
    def __init__(__self__, *,
                 nat_gateway_id: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_service_port: Optional[pulumi.Input[_builtins.int]] = None,
                 external_service_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 floating_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 global_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_service_port: Optional[pulumi.Input[_builtins.int]] = None,
                 internal_service_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DnatRule resource.
        :param pulumi.Input[_builtins.str] nat_gateway_id: ID of the nat gateway this dnat rule belongs to.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol type. Currently,
               TCP, UDP, and ANY are supported.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DNAT rule.  
               The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        :param pulumi.Input[_builtins.int] external_service_port: Specifies port used by ECSs or
               BMSs to provide services for external systems.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] external_service_port_range: Specifies port range used by ECSs or BMSs to provide
               services for external systems.
               This parameter and `internal_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
               The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
               Required if `internal_service_port_range` is set.
        :param pulumi.Input[_builtins.str] floating_ip_id: Specifies the ID of the floating IP address.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] global_eip_id: The ID of the global EIP connected by the DNAT rule.
        :param pulumi.Input[_builtins.int] internal_service_port: Specifies port used by ECSs or BMSs
               to provide services for external systems. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] internal_service_port_range: Specifies port range used by Floating IP provide services
               for external systems.
               This parameter and `external_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
               The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
        :param pulumi.Input[_builtins.str] port_id: Specifies the port ID of an ECS or a BMS.
               This parameter and private_ip are alternative. Changing this creates a
               new dnat rule.
        :param pulumi.Input[_builtins.str] private_ip: Specifies the private IP address of a
               user, for example, the IP address of a VPC for dedicated connection.
               This parameter and port_id are alternative.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the dnat rule resource. If omitted, the provider-level region will be used. Changing this creates a new Dnat rule resource.
        """
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_service_port is not None:
            pulumi.set(__self__, "external_service_port", external_service_port)
        if external_service_port_range is not None:
            pulumi.set(__self__, "external_service_port_range", external_service_port_range)
        if floating_ip_id is not None:
            pulumi.set(__self__, "floating_ip_id", floating_ip_id)
        if global_eip_id is not None:
            pulumi.set(__self__, "global_eip_id", global_eip_id)
        if internal_service_port is not None:
            pulumi.set(__self__, "internal_service_port", internal_service_port)
        if internal_service_port_range is not None:
            pulumi.set(__self__, "internal_service_port_range", internal_service_port_range)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the nat gateway this dnat rule belongs to.
        Changing this creates a new dnat rule.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nat_gateway_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the protocol type. Currently,
        TCP, UDP, and ANY are supported.
        Changing this creates a new dnat rule.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the DNAT rule.  
        The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalServicePort")
    def external_service_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies port used by ECSs or
        BMSs to provide services for external systems.
        Changing this creates a new dnat rule.
        """
        return pulumi.get(self, "external_service_port")

    @external_service_port.setter
    def external_service_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "external_service_port", value)

    @_builtins.property
    @pulumi.getter(name="externalServicePortRange")
    def external_service_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies port range used by ECSs or BMSs to provide
        services for external systems.
        This parameter and `internal_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
        The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
        Required if `internal_service_port_range` is set.
        """
        return pulumi.get(self, "external_service_port_range")

    @external_service_port_range.setter
    def external_service_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_service_port_range", value)

    @_builtins.property
    @pulumi.getter(name="floatingIpId")
    def floating_ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the floating IP address.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "floating_ip_id")

    @floating_ip_id.setter
    def floating_ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "floating_ip_id", value)

    @_builtins.property
    @pulumi.getter(name="globalEipId")
    def global_eip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the global EIP connected by the DNAT rule.
        """
        return pulumi.get(self, "global_eip_id")

    @global_eip_id.setter
    def global_eip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_eip_id", value)

    @_builtins.property
    @pulumi.getter(name="internalServicePort")
    def internal_service_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies port used by ECSs or BMSs
        to provide services for external systems. Changing this creates a new resource.
        """
        return pulumi.get(self, "internal_service_port")

    @internal_service_port.setter
    def internal_service_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internal_service_port", value)

    @_builtins.property
    @pulumi.getter(name="internalServicePortRange")
    def internal_service_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies port range used by Floating IP provide services
        for external systems.
        This parameter and `external_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
        The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
        """
        return pulumi.get(self, "internal_service_port_range")

    @internal_service_port_range.setter
    def internal_service_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_service_port_range", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the port ID of an ECS or a BMS.
        This parameter and private_ip are alternative. Changing this creates a
        new dnat rule.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the private IP address of a
        user, for example, the IP address of a VPC for dedicated connection.
        This parameter and port_id are alternative.
        Changing this creates a new dnat rule.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the dnat rule resource. If omitted, the provider-level region will be used. Changing this creates a new Dnat rule resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DnatRuleState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_service_port: Optional[pulumi.Input[_builtins.int]] = None,
                 external_service_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 floating_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 floating_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 global_eip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 global_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_service_port: Optional[pulumi.Input[_builtins.int]] = None,
                 internal_service_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DnatRule resources.
        :param pulumi.Input[_builtins.str] created_at: Dnat rule creation time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DNAT rule.  
               The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        :param pulumi.Input[_builtins.int] external_service_port: Specifies port used by ECSs or
               BMSs to provide services for external systems.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] external_service_port_range: Specifies port range used by ECSs or BMSs to provide
               services for external systems.
               This parameter and `internal_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
               The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
               Required if `internal_service_port_range` is set.
        :param pulumi.Input[_builtins.str] floating_ip_address: The actual floating IP address.
        :param pulumi.Input[_builtins.str] floating_ip_id: Specifies the ID of the floating IP address.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] global_eip_address: The global EIP address connected by the DNAT rule.
        :param pulumi.Input[_builtins.str] global_eip_id: The ID of the global EIP connected by the DNAT rule.
        :param pulumi.Input[_builtins.int] internal_service_port: Specifies port used by ECSs or BMSs
               to provide services for external systems. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] internal_service_port_range: Specifies port range used by Floating IP provide services
               for external systems.
               This parameter and `external_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
               The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
        :param pulumi.Input[_builtins.str] nat_gateway_id: ID of the nat gateway this dnat rule belongs to.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] port_id: Specifies the port ID of an ECS or a BMS.
               This parameter and private_ip are alternative. Changing this creates a
               new dnat rule.
        :param pulumi.Input[_builtins.str] private_ip: Specifies the private IP address of a
               user, for example, the IP address of a VPC for dedicated connection.
               This parameter and port_id are alternative.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol type. Currently,
               TCP, UDP, and ANY are supported.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the dnat rule resource. If omitted, the provider-level region will be used. Changing this creates a new Dnat rule resource.
        :param pulumi.Input[_builtins.str] status: Dnat rule status.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_service_port is not None:
            pulumi.set(__self__, "external_service_port", external_service_port)
        if external_service_port_range is not None:
            pulumi.set(__self__, "external_service_port_range", external_service_port_range)
        if floating_ip_address is not None:
            pulumi.set(__self__, "floating_ip_address", floating_ip_address)
        if floating_ip_id is not None:
            pulumi.set(__self__, "floating_ip_id", floating_ip_id)
        if global_eip_address is not None:
            pulumi.set(__self__, "global_eip_address", global_eip_address)
        if global_eip_id is not None:
            pulumi.set(__self__, "global_eip_id", global_eip_id)
        if internal_service_port is not None:
            pulumi.set(__self__, "internal_service_port", internal_service_port)
        if internal_service_port_range is not None:
            pulumi.set(__self__, "internal_service_port_range", internal_service_port_range)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dnat rule creation time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the DNAT rule.  
        The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalServicePort")
    def external_service_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies port used by ECSs or
        BMSs to provide services for external systems.
        Changing this creates a new dnat rule.
        """
        return pulumi.get(self, "external_service_port")

    @external_service_port.setter
    def external_service_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "external_service_port", value)

    @_builtins.property
    @pulumi.getter(name="externalServicePortRange")
    def external_service_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies port range used by ECSs or BMSs to provide
        services for external systems.
        This parameter and `internal_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
        The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
        Required if `internal_service_port_range` is set.
        """
        return pulumi.get(self, "external_service_port_range")

    @external_service_port_range.setter
    def external_service_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_service_port_range", value)

    @_builtins.property
    @pulumi.getter(name="floatingIpAddress")
    def floating_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The actual floating IP address.
        """
        return pulumi.get(self, "floating_ip_address")

    @floating_ip_address.setter
    def floating_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "floating_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="floatingIpId")
    def floating_ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the floating IP address.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "floating_ip_id")

    @floating_ip_id.setter
    def floating_ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "floating_ip_id", value)

    @_builtins.property
    @pulumi.getter(name="globalEipAddress")
    def global_eip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The global EIP address connected by the DNAT rule.
        """
        return pulumi.get(self, "global_eip_address")

    @global_eip_address.setter
    def global_eip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_eip_address", value)

    @_builtins.property
    @pulumi.getter(name="globalEipId")
    def global_eip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the global EIP connected by the DNAT rule.
        """
        return pulumi.get(self, "global_eip_id")

    @global_eip_id.setter
    def global_eip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_eip_id", value)

    @_builtins.property
    @pulumi.getter(name="internalServicePort")
    def internal_service_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies port used by ECSs or BMSs
        to provide services for external systems. Changing this creates a new resource.
        """
        return pulumi.get(self, "internal_service_port")

    @internal_service_port.setter
    def internal_service_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internal_service_port", value)

    @_builtins.property
    @pulumi.getter(name="internalServicePortRange")
    def internal_service_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies port range used by Floating IP provide services
        for external systems.
        This parameter and `external_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
        The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
        """
        return pulumi.get(self, "internal_service_port_range")

    @internal_service_port_range.setter
    def internal_service_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_service_port_range", value)

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the nat gateway this dnat rule belongs to.
        Changing this creates a new dnat rule.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the port ID of an ECS or a BMS.
        This parameter and private_ip are alternative. Changing this creates a
        new dnat rule.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the private IP address of a
        user, for example, the IP address of a VPC for dedicated connection.
        This parameter and port_id are alternative.
        Changing this creates a new dnat rule.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol type. Currently,
        TCP, UDP, and ANY are supported.
        Changing this creates a new dnat rule.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the dnat rule resource. If omitted, the provider-level region will be used. Changing this creates a new Dnat rule resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dnat rule status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("sbercloud:Nat/dnatRule:DnatRule")
class DnatRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_service_port: Optional[pulumi.Input[_builtins.int]] = None,
                 external_service_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 floating_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 global_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_service_port: Optional[pulumi.Input[_builtins.int]] = None,
                 internal_service_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Dnat rule resource within SberCloud Nat.

        ## Example Usage

        ### Dnat

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        dnat1 = sbercloud.nat.DnatRule("dnat_1",
            floating_ip_id="2bd659ab-bbf7-43d7-928b-9ee6a10de3ef",
            nat_gateway_id="bf99c679-9f41-4dac-8513-9c9228e713e1",
            private_ip="10.0.0.12",
            protocol="tcp",
            internal_service_port=993,
            external_service_port=242)
        ```

        ## Import

        Dnat can be imported using the following format:

        ```sh
        $ pulumi import sbercloud:Nat/dnatRule:DnatRule dnat_1 f4f783a7-b908-4215-b018-724960e5df4a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DNAT rule.  
               The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        :param pulumi.Input[_builtins.int] external_service_port: Specifies port used by ECSs or
               BMSs to provide services for external systems.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] external_service_port_range: Specifies port range used by ECSs or BMSs to provide
               services for external systems.
               This parameter and `internal_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
               The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
               Required if `internal_service_port_range` is set.
        :param pulumi.Input[_builtins.str] floating_ip_id: Specifies the ID of the floating IP address.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] global_eip_id: The ID of the global EIP connected by the DNAT rule.
        :param pulumi.Input[_builtins.int] internal_service_port: Specifies port used by ECSs or BMSs
               to provide services for external systems. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] internal_service_port_range: Specifies port range used by Floating IP provide services
               for external systems.
               This parameter and `external_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
               The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
        :param pulumi.Input[_builtins.str] nat_gateway_id: ID of the nat gateway this dnat rule belongs to.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] port_id: Specifies the port ID of an ECS or a BMS.
               This parameter and private_ip are alternative. Changing this creates a
               new dnat rule.
        :param pulumi.Input[_builtins.str] private_ip: Specifies the private IP address of a
               user, for example, the IP address of a VPC for dedicated connection.
               This parameter and port_id are alternative.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol type. Currently,
               TCP, UDP, and ANY are supported.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the dnat rule resource. If omitted, the provider-level region will be used. Changing this creates a new Dnat rule resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnatRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dnat rule resource within SberCloud Nat.

        ## Example Usage

        ### Dnat

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        dnat1 = sbercloud.nat.DnatRule("dnat_1",
            floating_ip_id="2bd659ab-bbf7-43d7-928b-9ee6a10de3ef",
            nat_gateway_id="bf99c679-9f41-4dac-8513-9c9228e713e1",
            private_ip="10.0.0.12",
            protocol="tcp",
            internal_service_port=993,
            external_service_port=242)
        ```

        ## Import

        Dnat can be imported using the following format:

        ```sh
        $ pulumi import sbercloud:Nat/dnatRule:DnatRule dnat_1 f4f783a7-b908-4215-b018-724960e5df4a
        ```

        :param str resource_name: The name of the resource.
        :param DnatRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnatRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_service_port: Optional[pulumi.Input[_builtins.int]] = None,
                 external_service_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 floating_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 global_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_service_port: Optional[pulumi.Input[_builtins.int]] = None,
                 internal_service_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnatRuleArgs.__new__(DnatRuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["external_service_port"] = external_service_port
            __props__.__dict__["external_service_port_range"] = external_service_port_range
            __props__.__dict__["floating_ip_id"] = floating_ip_id
            __props__.__dict__["global_eip_id"] = global_eip_id
            __props__.__dict__["internal_service_port"] = internal_service_port
            __props__.__dict__["internal_service_port_range"] = internal_service_port_range
            if nat_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'nat_gateway_id'")
            __props__.__dict__["nat_gateway_id"] = nat_gateway_id
            __props__.__dict__["port_id"] = port_id
            __props__.__dict__["private_ip"] = private_ip
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["created_at"] = None
            __props__.__dict__["floating_ip_address"] = None
            __props__.__dict__["global_eip_address"] = None
            __props__.__dict__["status"] = None
        super(DnatRule, __self__).__init__(
            'sbercloud:Nat/dnatRule:DnatRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            external_service_port: Optional[pulumi.Input[_builtins.int]] = None,
            external_service_port_range: Optional[pulumi.Input[_builtins.str]] = None,
            floating_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            floating_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
            global_eip_address: Optional[pulumi.Input[_builtins.str]] = None,
            global_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
            internal_service_port: Optional[pulumi.Input[_builtins.int]] = None,
            internal_service_port_range: Optional[pulumi.Input[_builtins.str]] = None,
            nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            port_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'DnatRule':
        """
        Get an existing DnatRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Dnat rule creation time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DNAT rule.  
               The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        :param pulumi.Input[_builtins.int] external_service_port: Specifies port used by ECSs or
               BMSs to provide services for external systems.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] external_service_port_range: Specifies port range used by ECSs or BMSs to provide
               services for external systems.
               This parameter and `internal_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
               The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
               Required if `internal_service_port_range` is set.
        :param pulumi.Input[_builtins.str] floating_ip_address: The actual floating IP address.
        :param pulumi.Input[_builtins.str] floating_ip_id: Specifies the ID of the floating IP address.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] global_eip_address: The global EIP address connected by the DNAT rule.
        :param pulumi.Input[_builtins.str] global_eip_id: The ID of the global EIP connected by the DNAT rule.
        :param pulumi.Input[_builtins.int] internal_service_port: Specifies port used by ECSs or BMSs
               to provide services for external systems. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] internal_service_port_range: Specifies port range used by Floating IP provide services
               for external systems.
               This parameter and `external_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
               The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
        :param pulumi.Input[_builtins.str] nat_gateway_id: ID of the nat gateway this dnat rule belongs to.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] port_id: Specifies the port ID of an ECS or a BMS.
               This parameter and private_ip are alternative. Changing this creates a
               new dnat rule.
        :param pulumi.Input[_builtins.str] private_ip: Specifies the private IP address of a
               user, for example, the IP address of a VPC for dedicated connection.
               This parameter and port_id are alternative.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol type. Currently,
               TCP, UDP, and ANY are supported.
               Changing this creates a new dnat rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the dnat rule resource. If omitted, the provider-level region will be used. Changing this creates a new Dnat rule resource.
        :param pulumi.Input[_builtins.str] status: Dnat rule status.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnatRuleState.__new__(_DnatRuleState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["external_service_port"] = external_service_port
        __props__.__dict__["external_service_port_range"] = external_service_port_range
        __props__.__dict__["floating_ip_address"] = floating_ip_address
        __props__.__dict__["floating_ip_id"] = floating_ip_id
        __props__.__dict__["global_eip_address"] = global_eip_address
        __props__.__dict__["global_eip_id"] = global_eip_id
        __props__.__dict__["internal_service_port"] = internal_service_port
        __props__.__dict__["internal_service_port_range"] = internal_service_port_range
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        return DnatRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Dnat rule creation time.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the DNAT rule.  
        The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalServicePort")
    def external_service_port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies port used by ECSs or
        BMSs to provide services for external systems.
        Changing this creates a new dnat rule.
        """
        return pulumi.get(self, "external_service_port")

    @_builtins.property
    @pulumi.getter(name="externalServicePortRange")
    def external_service_port_range(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies port range used by ECSs or BMSs to provide
        services for external systems.
        This parameter and `internal_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
        The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
        Required if `internal_service_port_range` is set.
        """
        return pulumi.get(self, "external_service_port_range")

    @_builtins.property
    @pulumi.getter(name="floatingIpAddress")
    def floating_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The actual floating IP address.
        """
        return pulumi.get(self, "floating_ip_address")

    @_builtins.property
    @pulumi.getter(name="floatingIpId")
    def floating_ip_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the floating IP address.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "floating_ip_id")

    @_builtins.property
    @pulumi.getter(name="globalEipAddress")
    def global_eip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The global EIP address connected by the DNAT rule.
        """
        return pulumi.get(self, "global_eip_address")

    @_builtins.property
    @pulumi.getter(name="globalEipId")
    def global_eip_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the global EIP connected by the DNAT rule.
        """
        return pulumi.get(self, "global_eip_id")

    @_builtins.property
    @pulumi.getter(name="internalServicePort")
    def internal_service_port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies port used by ECSs or BMSs
        to provide services for external systems. Changing this creates a new resource.
        """
        return pulumi.get(self, "internal_service_port")

    @_builtins.property
    @pulumi.getter(name="internalServicePortRange")
    def internal_service_port_range(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies port range used by Floating IP provide services
        for external systems.
        This parameter and `external_service_port_range` are mapped **1:1** in sequence(, ranges must have the same length).
        The valid value for range is **1~65535** and the port ranges can only be concatenated with the `-` character.
        """
        return pulumi.get(self, "internal_service_port_range")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the nat gateway this dnat rule belongs to.
        Changing this creates a new dnat rule.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the port ID of an ECS or a BMS.
        This parameter and private_ip are alternative. Changing this creates a
        new dnat rule.
        """
        return pulumi.get(self, "port_id")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the private IP address of a
        user, for example, the IP address of a VPC for dedicated connection.
        This parameter and port_id are alternative.
        Changing this creates a new dnat rule.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the protocol type. Currently,
        TCP, UDP, and ANY are supported.
        Changing this creates a new dnat rule.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the dnat rule resource. If omitted, the provider-level region will be used. Changing this creates a new Dnat rule resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Dnat rule status.
        """
        return pulumi.get(self, "status")

