# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ngport_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 session_conf: Optional[pulumi.Input['GatewaySessionConfArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[_builtins.str] spec: Specifies the nat gateway type.
               The value can be:
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the subnet ID of the downstream interface (the next hop of the
               DVR) of the NAT gateway.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC to which the NAT gateway belongs.  
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the nat
               gateway. The value contains 0 to 255 characters, and angle brackets (<)
               and (>) are not allowed.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the
               enterprise project id of the nat gateway. The value can contains maximum of
               36 characters which it is string "0" or in UUID format with hyphens (-).
               Changing this creates a new nat gateway.
        :param pulumi.Input[_builtins.str] name: Specifies the nat gateway name. The name can
               contain only digits, letters, underscores (_), and hyphens(-).
        :param pulumi.Input[_builtins.str] ngport_ip_address: The IP address used for the NG port of the NAT gateway.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to
               create the Nat gateway resource. If omitted, the provider-level region will
               be used. Changing this creates a new nat gateway.
        :param pulumi.Input['GatewaySessionConfArgs'] session_conf: The session configuration of the NAT gateway.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the NAT geteway.
        """
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ngport_ip_address is not None:
            pulumi.set(__self__, "ngport_ip_address", ngport_ip_address)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if session_conf is not None:
            pulumi.set(__self__, "session_conf", session_conf)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the nat gateway type.
        The value can be:
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the subnet ID of the downstream interface (the next hop of the
        DVR) of the NAT gateway.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the VPC to which the NAT gateway belongs.  
        Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the nat
        gateway. The value contains 0 to 255 characters, and angle brackets (<)
        and (>) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the
        enterprise project id of the nat gateway. The value can contains maximum of
        36 characters which it is string "0" or in UUID format with hyphens (-).
        Changing this creates a new nat gateway.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the nat gateway name. The name can
        contain only digits, letters, underscores (_), and hyphens(-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ngportIpAddress")
    def ngport_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address used for the NG port of the NAT gateway.
        """
        return pulumi.get(self, "ngport_ip_address")

    @ngport_ip_address.setter
    def ngport_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ngport_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to
        create the Nat gateway resource. If omitted, the provider-level region will
        be used. Changing this creates a new nat gateway.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sessionConf")
    def session_conf(self) -> Optional[pulumi.Input['GatewaySessionConfArgs']]:
        """
        The session configuration of the NAT gateway.
        """
        return pulumi.get(self, "session_conf")

    @session_conf.setter
    def session_conf(self, value: Optional[pulumi.Input['GatewaySessionConfArgs']]):
        pulumi.set(self, "session_conf", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the NAT geteway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_info: Optional[pulumi.Input[_builtins.str]] = None,
                 bps_max: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dnat_rules_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ngport_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 pps_max: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 session_conf: Optional[pulumi.Input['GatewaySessionConfArgs']] = None,
                 snat_rule_public_ip_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input[_builtins.str] billing_info: The order information of the NAT gateway.
        :param pulumi.Input[_builtins.int] bps_max: The bandwidth that the NAT gateway can receive or send per second.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the NAT gateway.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the nat
               gateway. The value contains 0 to 255 characters, and angle brackets (<)
               and (>) are not allowed.
        :param pulumi.Input[_builtins.int] dnat_rules_limit: The maximum number of DNAT rules on the NAT gateway.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the
               enterprise project id of the nat gateway. The value can contains maximum of
               36 characters which it is string "0" or in UUID format with hyphens (-).
               Changing this creates a new nat gateway.
        :param pulumi.Input[_builtins.str] name: Specifies the nat gateway name. The name can
               contain only digits, letters, underscores (_), and hyphens(-).
        :param pulumi.Input[_builtins.str] ngport_ip_address: The IP address used for the NG port of the NAT gateway.
        :param pulumi.Input[_builtins.int] pps_max: The number of packets that the NAT gateway can receive or send per second.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to
               create the Nat gateway resource. If omitted, the provider-level region will
               be used. Changing this creates a new nat gateway.
        :param pulumi.Input['GatewaySessionConfArgs'] session_conf: The session configuration of the NAT gateway.
        :param pulumi.Input[_builtins.int] snat_rule_public_ip_limit: The maximum number of SNAT rules on the NAT gateway.
        :param pulumi.Input[_builtins.str] spec: Specifies the nat gateway type.
               The value can be:
        :param pulumi.Input[_builtins.str] status: The status of the nat gateway.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the subnet ID of the downstream interface (the next hop of the
               DVR) of the NAT gateway.
               Changing this will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the NAT geteway.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC to which the NAT gateway belongs.  
               Changing this will create a new resource.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if billing_info is not None:
            pulumi.set(__self__, "billing_info", billing_info)
        if bps_max is not None:
            pulumi.set(__self__, "bps_max", bps_max)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dnat_rules_limit is not None:
            pulumi.set(__self__, "dnat_rules_limit", dnat_rules_limit)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ngport_ip_address is not None:
            pulumi.set(__self__, "ngport_ip_address", ngport_ip_address)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if pps_max is not None:
            pulumi.set(__self__, "pps_max", pps_max)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if session_conf is not None:
            pulumi.set(__self__, "session_conf", session_conf)
        if snat_rule_public_ip_limit is not None:
            pulumi.set(__self__, "snat_rule_public_ip_limit", snat_rule_public_ip_limit)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="billingInfo")
    def billing_info(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The order information of the NAT gateway.
        """
        return pulumi.get(self, "billing_info")

    @billing_info.setter
    def billing_info(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_info", value)

    @_builtins.property
    @pulumi.getter(name="bpsMax")
    def bps_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth that the NAT gateway can receive or send per second.
        """
        return pulumi.get(self, "bps_max")

    @bps_max.setter
    def bps_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bps_max", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the NAT gateway.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the nat
        gateway. The value contains 0 to 255 characters, and angle brackets (<)
        and (>) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnatRulesLimit")
    def dnat_rules_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of DNAT rules on the NAT gateway.
        """
        return pulumi.get(self, "dnat_rules_limit")

    @dnat_rules_limit.setter
    def dnat_rules_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dnat_rules_limit", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the
        enterprise project id of the nat gateway. The value can contains maximum of
        36 characters which it is string "0" or in UUID format with hyphens (-).
        Changing this creates a new nat gateway.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the nat gateway name. The name can
        contain only digits, letters, underscores (_), and hyphens(-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ngportIpAddress")
    def ngport_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address used for the NG port of the NAT gateway.
        """
        return pulumi.get(self, "ngport_ip_address")

    @ngport_ip_address.setter
    def ngport_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ngport_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="ppsMax")
    def pps_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of packets that the NAT gateway can receive or send per second.
        """
        return pulumi.get(self, "pps_max")

    @pps_max.setter
    def pps_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "pps_max", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to
        create the Nat gateway resource. If omitted, the provider-level region will
        be used. Changing this creates a new nat gateway.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sessionConf")
    def session_conf(self) -> Optional[pulumi.Input['GatewaySessionConfArgs']]:
        """
        The session configuration of the NAT gateway.
        """
        return pulumi.get(self, "session_conf")

    @session_conf.setter
    def session_conf(self, value: Optional[pulumi.Input['GatewaySessionConfArgs']]):
        pulumi.set(self, "session_conf", value)

    @_builtins.property
    @pulumi.getter(name="snatRulePublicIpLimit")
    def snat_rule_public_ip_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of SNAT rules on the NAT gateway.
        """
        return pulumi.get(self, "snat_rule_public_ip_limit")

    @snat_rule_public_ip_limit.setter
    def snat_rule_public_ip_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snat_rule_public_ip_limit", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the nat gateway type.
        The value can be:
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the nat gateway.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the subnet ID of the downstream interface (the next hop of the
        DVR) of the NAT gateway.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the NAT geteway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the VPC to which the NAT gateway belongs.  
        Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Nat/gateway:Gateway")
class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ngport_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 session_conf: Optional[pulumi.Input[Union['GatewaySessionConfArgs', 'GatewaySessionConfArgsDict']]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Nat gateway resource within SberCloud Nat

        ## Import

        Nat gateway can be imported using the following format:

        ```sh
        $ pulumi import sbercloud:Nat/gateway:Gateway nat_1 d126fb87-43ce-4867-a2ff-cf34af3765d9
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the nat
               gateway. The value contains 0 to 255 characters, and angle brackets (<)
               and (>) are not allowed.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the
               enterprise project id of the nat gateway. The value can contains maximum of
               36 characters which it is string "0" or in UUID format with hyphens (-).
               Changing this creates a new nat gateway.
        :param pulumi.Input[_builtins.str] name: Specifies the nat gateway name. The name can
               contain only digits, letters, underscores (_), and hyphens(-).
        :param pulumi.Input[_builtins.str] ngport_ip_address: The IP address used for the NG port of the NAT gateway.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to
               create the Nat gateway resource. If omitted, the provider-level region will
               be used. Changing this creates a new nat gateway.
        :param pulumi.Input[Union['GatewaySessionConfArgs', 'GatewaySessionConfArgsDict']] session_conf: The session configuration of the NAT gateway.
        :param pulumi.Input[_builtins.str] spec: Specifies the nat gateway type.
               The value can be:
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the subnet ID of the downstream interface (the next hop of the
               DVR) of the NAT gateway.
               Changing this will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the NAT geteway.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC to which the NAT gateway belongs.  
               Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Nat gateway resource within SberCloud Nat

        ## Import

        Nat gateway can be imported using the following format:

        ```sh
        $ pulumi import sbercloud:Nat/gateway:Gateway nat_1 d126fb87-43ce-4867-a2ff-cf34af3765d9
        ```

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ngport_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 session_conf: Optional[pulumi.Input[Union['GatewaySessionConfArgs', 'GatewaySessionConfArgsDict']]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["ngport_ip_address"] = ngport_ip_address
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["region"] = region
            __props__.__dict__["session_conf"] = session_conf
            if spec is None and not opts.urn:
                raise TypeError("Missing required property 'spec'")
            __props__.__dict__["spec"] = spec
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["billing_info"] = None
            __props__.__dict__["bps_max"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["dnat_rules_limit"] = None
            __props__.__dict__["pps_max"] = None
            __props__.__dict__["snat_rule_public_ip_limit"] = None
            __props__.__dict__["status"] = None
        super(Gateway, __self__).__init__(
            'sbercloud:Nat/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            billing_info: Optional[pulumi.Input[_builtins.str]] = None,
            bps_max: Optional[pulumi.Input[_builtins.int]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dnat_rules_limit: Optional[pulumi.Input[_builtins.int]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ngport_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            pps_max: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            session_conf: Optional[pulumi.Input[Union['GatewaySessionConfArgs', 'GatewaySessionConfArgsDict']]] = None,
            snat_rule_public_ip_limit: Optional[pulumi.Input[_builtins.int]] = None,
            spec: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] billing_info: The order information of the NAT gateway.
        :param pulumi.Input[_builtins.int] bps_max: The bandwidth that the NAT gateway can receive or send per second.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the NAT gateway.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the nat
               gateway. The value contains 0 to 255 characters, and angle brackets (<)
               and (>) are not allowed.
        :param pulumi.Input[_builtins.int] dnat_rules_limit: The maximum number of DNAT rules on the NAT gateway.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the
               enterprise project id of the nat gateway. The value can contains maximum of
               36 characters which it is string "0" or in UUID format with hyphens (-).
               Changing this creates a new nat gateway.
        :param pulumi.Input[_builtins.str] name: Specifies the nat gateway name. The name can
               contain only digits, letters, underscores (_), and hyphens(-).
        :param pulumi.Input[_builtins.str] ngport_ip_address: The IP address used for the NG port of the NAT gateway.
        :param pulumi.Input[_builtins.int] pps_max: The number of packets that the NAT gateway can receive or send per second.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to
               create the Nat gateway resource. If omitted, the provider-level region will
               be used. Changing this creates a new nat gateway.
        :param pulumi.Input[Union['GatewaySessionConfArgs', 'GatewaySessionConfArgsDict']] session_conf: The session configuration of the NAT gateway.
        :param pulumi.Input[_builtins.int] snat_rule_public_ip_limit: The maximum number of SNAT rules on the NAT gateway.
        :param pulumi.Input[_builtins.str] spec: Specifies the nat gateway type.
               The value can be:
        :param pulumi.Input[_builtins.str] status: The status of the nat gateway.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the subnet ID of the downstream interface (the next hop of the
               DVR) of the NAT gateway.
               Changing this will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the NAT geteway.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC to which the NAT gateway belongs.  
               Changing this will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["billing_info"] = billing_info
        __props__.__dict__["bps_max"] = bps_max
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["dnat_rules_limit"] = dnat_rules_limit
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["ngport_ip_address"] = ngport_ip_address
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["pps_max"] = pps_max
        __props__.__dict__["region"] = region
        __props__.__dict__["session_conf"] = session_conf
        __props__.__dict__["snat_rule_public_ip_limit"] = snat_rule_public_ip_limit
        __props__.__dict__["spec"] = spec
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="billingInfo")
    def billing_info(self) -> pulumi.Output[_builtins.str]:
        """
        The order information of the NAT gateway.
        """
        return pulumi.get(self, "billing_info")

    @_builtins.property
    @pulumi.getter(name="bpsMax")
    def bps_max(self) -> pulumi.Output[_builtins.int]:
        """
        The bandwidth that the NAT gateway can receive or send per second.
        """
        return pulumi.get(self, "bps_max")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the NAT gateway.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the nat
        gateway. The value contains 0 to 255 characters, and angle brackets (<)
        and (>) are not allowed.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnatRulesLimit")
    def dnat_rules_limit(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of DNAT rules on the NAT gateway.
        """
        return pulumi.get(self, "dnat_rules_limit")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the
        enterprise project id of the nat gateway. The value can contains maximum of
        36 characters which it is string "0" or in UUID format with hyphens (-).
        Changing this creates a new nat gateway.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the nat gateway name. The name can
        contain only digits, letters, underscores (_), and hyphens(-).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ngportIpAddress")
    def ngport_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address used for the NG port of the NAT gateway.
        """
        return pulumi.get(self, "ngport_ip_address")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="ppsMax")
    def pps_max(self) -> pulumi.Output[_builtins.int]:
        """
        The number of packets that the NAT gateway can receive or send per second.
        """
        return pulumi.get(self, "pps_max")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to
        create the Nat gateway resource. If omitted, the provider-level region will
        be used. Changing this creates a new nat gateway.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sessionConf")
    def session_conf(self) -> pulumi.Output['outputs.GatewaySessionConf']:
        """
        The session configuration of the NAT gateway.
        """
        return pulumi.get(self, "session_conf")

    @_builtins.property
    @pulumi.getter(name="snatRulePublicIpLimit")
    def snat_rule_public_ip_limit(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of SNAT rules on the NAT gateway.
        """
        return pulumi.get(self, "snat_rule_public_ip_limit")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the nat gateway type.
        The value can be:
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the nat gateway.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the subnet ID of the downstream interface (the next hop of the
        DVR) of the NAT gateway.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the NAT geteway.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the VPC to which the NAT gateway belongs.  
        Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

