# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetGatewayResult',
    'AwaitableGetGatewayResult',
    'get_gateway',
    'get_gateway_output',
]

@pulumi.output_type
class GetGatewayResult:
    """
    A collection of values returned by getGateway.
    """
    def __init__(__self__, description=None, enterprise_project_id=None, id=None, internal_network_id=None, name=None, region=None, router_id=None, spec=None, status=None, subnet_id=None, vpc_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_network_id and not isinstance(internal_network_id, str):
            raise TypeError("Expected argument 'internal_network_id' to be a str")
        pulumi.set(__self__, "internal_network_id", internal_network_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if router_id and not isinstance(router_id, str):
            raise TypeError("Expected argument 'router_id' to be a str")
        pulumi.set(__self__, "router_id", router_id)
        if spec and not isinstance(spec, str):
            raise TypeError("Expected argument 'spec' to be a str")
        pulumi.set(__self__, "spec", spec)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internalNetworkId")
    @_utilities.deprecated("""use subnet_id instead""")
    def internal_network_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "internal_network_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routerId")
    @_utilities.deprecated("""use vpc_id instead""")
    def router_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> _builtins.str:
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetGatewayResult(GetGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayResult(
            description=self.description,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            internal_network_id=self.internal_network_id,
            name=self.name,
            region=self.region,
            router_id=self.router_id,
            spec=self.spec,
            status=self.status,
            subnet_id=self.subnet_id,
            vpc_id=self.vpc_id)


def get_gateway(description: Optional[_builtins.str] = None,
                enterprise_project_id: Optional[_builtins.str] = None,
                id: Optional[_builtins.str] = None,
                internal_network_id: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                router_id: Optional[_builtins.str] = None,
                spec: Optional[_builtins.str] = None,
                status: Optional[_builtins.str] = None,
                subnet_id: Optional[_builtins.str] = None,
                vpc_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayResult:
    """
    Use this data source to get the information of an available SberCloud NAT gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    natgateway = sbercloud.Nat.get_gateway(name="tf_test_natgateway")
    ```


    :param _builtins.str description: Specifies the description of the nat
           gateway. The value contains 0 to 255 characters, and angle brackets (<)
           and (>) are not allowed.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project
           ID of the NAT gateway.
    :param _builtins.str id: Specifies the ID of the NAT gateway.
    :param _builtins.str internal_network_id: Specifies the network ID of the
           downstream interface (the next hop of the DVR) of the NAT gateway.
    :param _builtins.str name: Specifies the nat gateway name. The name can
           contain only digits, letters, underscores (_), and hyphens(-).
    :param _builtins.str region: Specifies the region in which to create the Nat
           gateway resource. If omitted, the provider-level region will be used.
    :param _builtins.str router_id: Specifies the ID of the router this nat
           gateway belongs to.
    :param _builtins.str spec: The NAT gateway type.
           The value can be:
    :param _builtins.str status: Specifies the status of the NAT gateway.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['id'] = id
    __args__['internalNetworkId'] = internal_network_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['routerId'] = router_id
    __args__['spec'] = spec
    __args__['status'] = status
    __args__['subnetId'] = subnet_id
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Nat/getGateway:getGateway', __args__, opts=opts, typ=GetGatewayResult).value

    return AwaitableGetGatewayResult(
        description=pulumi.get(__ret__, 'description'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        internal_network_id=pulumi.get(__ret__, 'internal_network_id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        router_id=pulumi.get(__ret__, 'router_id'),
        spec=pulumi.get(__ret__, 'spec'),
        status=pulumi.get(__ret__, 'status'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_gateway_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       internal_network_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       router_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       spec: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       subnet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGatewayResult]:
    """
    Use this data source to get the information of an available SberCloud NAT gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    natgateway = sbercloud.Nat.get_gateway(name="tf_test_natgateway")
    ```


    :param _builtins.str description: Specifies the description of the nat
           gateway. The value contains 0 to 255 characters, and angle brackets (<)
           and (>) are not allowed.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project
           ID of the NAT gateway.
    :param _builtins.str id: Specifies the ID of the NAT gateway.
    :param _builtins.str internal_network_id: Specifies the network ID of the
           downstream interface (the next hop of the DVR) of the NAT gateway.
    :param _builtins.str name: Specifies the nat gateway name. The name can
           contain only digits, letters, underscores (_), and hyphens(-).
    :param _builtins.str region: Specifies the region in which to create the Nat
           gateway resource. If omitted, the provider-level region will be used.
    :param _builtins.str router_id: Specifies the ID of the router this nat
           gateway belongs to.
    :param _builtins.str spec: The NAT gateway type.
           The value can be:
    :param _builtins.str status: Specifies the status of the NAT gateway.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['id'] = id
    __args__['internalNetworkId'] = internal_network_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['routerId'] = router_id
    __args__['spec'] = spec
    __args__['status'] = status
    __args__['subnetId'] = subnet_id
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Nat/getGateway:getGateway', __args__, opts=opts, typ=GetGatewayResult)
    return __ret__.apply(lambda __response__: GetGatewayResult(
        description=pulumi.get(__response__, 'description'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        internal_network_id=pulumi.get(__response__, 'internal_network_id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        router_id=pulumi.get(__response__, 'router_id'),
        spec=pulumi.get(__response__, 'spec'),
        status=pulumi.get(__response__, 'status'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
