# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SnatRuleArgs', 'SnatRule']

@pulumi.input_type
class SnatRuleArgs:
    def __init__(__self__, *,
                 nat_gateway_id: pulumi.Input[_builtins.str],
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 floating_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 global_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SnatRule resource.
        :param pulumi.Input[_builtins.str] nat_gateway_id: ID of the nat gateway this snat rule belongs to.
               Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] cidr: Specifies CIDR, which can be in the format of a network segment or a host IP address.
               This parameter and `network_id` are alternative. Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the SNAT rule.
               The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        :param pulumi.Input[_builtins.str] floating_ip_id: ID of the floating ip this snat rule connets to.
               Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] global_eip_id: The IDs (separated by commas) of global EIPs connected by SNAT rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the snat rule resource. If omitted, the provider-level region will be used. Changing this creates a new snat rule resource.
        :param pulumi.Input[_builtins.int] source_type: Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct Connect scenario).
               Defaults to 0, only `cidr` can be specified over a Direct Connect connection.
               Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the network IDs of subnet connected by SNAT rule (VPC side).  
               This parameter and `cidr` are alternative. Changing this will create a new resource.
        """
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if floating_ip_id is not None:
            pulumi.set(__self__, "floating_ip_id", floating_ip_id)
        if global_eip_id is not None:
            pulumi.set(__self__, "global_eip_id", global_eip_id)
        if network_id is not None:
            warnings.warn("""schema: Deprecated; Use 'subnet_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""network_id is deprecated: schema: Deprecated; Use 'subnet_id' instead.""")
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the nat gateway this snat rule belongs to.
        Changing this creates a new snat rule.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nat_gateway_id", value)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies CIDR, which can be in the format of a network segment or a host IP address.
        This parameter and `network_id` are alternative. Changing this creates a new snat rule.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the SNAT rule.
        The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="floatingIpId")
    def floating_ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the floating ip this snat rule connets to.
        Changing this creates a new snat rule.
        """
        return pulumi.get(self, "floating_ip_id")

    @floating_ip_id.setter
    def floating_ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "floating_ip_id", value)

    @_builtins.property
    @pulumi.getter(name="globalEipId")
    def global_eip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs (separated by commas) of global EIPs connected by SNAT rule.
        """
        return pulumi.get(self, "global_eip_id")

    @global_eip_id.setter
    def global_eip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_eip_id", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    @_utilities.deprecated("""schema: Deprecated; Use 'subnet_id' instead.""")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the snat rule resource. If omitted, the provider-level region will be used. Changing this creates a new snat rule resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct Connect scenario).
        Defaults to 0, only `cidr` can be specified over a Direct Connect connection.
        Changing this creates a new snat rule.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the network IDs of subnet connected by SNAT rule (VPC side).  
        This parameter and `cidr` are alternative. Changing this will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class _SnatRuleState:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 floating_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 floating_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freezed_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 global_eip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 global_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SnatRule resources.
        :param pulumi.Input[_builtins.str] cidr: Specifies CIDR, which can be in the format of a network segment or a host IP address.
               This parameter and `network_id` are alternative. Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the SNAT rule.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the SNAT rule.
               The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        :param pulumi.Input[_builtins.str] floating_ip_address: The actual floating IP address.
        :param pulumi.Input[_builtins.str] floating_ip_id: ID of the floating ip this snat rule connets to.
               Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] freezed_ip_address: The frozen EIP associated with the SNAT rule.
        :param pulumi.Input[_builtins.str] global_eip_address: The global EIP addresses (separated by commas) connected by SNAT rule.
        :param pulumi.Input[_builtins.str] global_eip_id: The IDs (separated by commas) of global EIPs connected by SNAT rule.
        :param pulumi.Input[_builtins.str] nat_gateway_id: ID of the nat gateway this snat rule belongs to.
               Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the snat rule resource. If omitted, the provider-level region will be used. Changing this creates a new snat rule resource.
        :param pulumi.Input[_builtins.int] source_type: Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct Connect scenario).
               Defaults to 0, only `cidr` can be specified over a Direct Connect connection.
               Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] status: The status of the snat rule.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the network IDs of subnet connected by SNAT rule (VPC side).  
               This parameter and `cidr` are alternative. Changing this will create a new resource.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if floating_ip_address is not None:
            pulumi.set(__self__, "floating_ip_address", floating_ip_address)
        if floating_ip_id is not None:
            pulumi.set(__self__, "floating_ip_id", floating_ip_id)
        if freezed_ip_address is not None:
            pulumi.set(__self__, "freezed_ip_address", freezed_ip_address)
        if global_eip_address is not None:
            pulumi.set(__self__, "global_eip_address", global_eip_address)
        if global_eip_id is not None:
            pulumi.set(__self__, "global_eip_id", global_eip_id)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if network_id is not None:
            warnings.warn("""schema: Deprecated; Use 'subnet_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""network_id is deprecated: schema: Deprecated; Use 'subnet_id' instead.""")
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies CIDR, which can be in the format of a network segment or a host IP address.
        This parameter and `network_id` are alternative. Changing this creates a new snat rule.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the SNAT rule.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the SNAT rule.
        The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="floatingIpAddress")
    def floating_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The actual floating IP address.
        """
        return pulumi.get(self, "floating_ip_address")

    @floating_ip_address.setter
    def floating_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "floating_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="floatingIpId")
    def floating_ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the floating ip this snat rule connets to.
        Changing this creates a new snat rule.
        """
        return pulumi.get(self, "floating_ip_id")

    @floating_ip_id.setter
    def floating_ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "floating_ip_id", value)

    @_builtins.property
    @pulumi.getter(name="freezedIpAddress")
    def freezed_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The frozen EIP associated with the SNAT rule.
        """
        return pulumi.get(self, "freezed_ip_address")

    @freezed_ip_address.setter
    def freezed_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "freezed_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="globalEipAddress")
    def global_eip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The global EIP addresses (separated by commas) connected by SNAT rule.
        """
        return pulumi.get(self, "global_eip_address")

    @global_eip_address.setter
    def global_eip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_eip_address", value)

    @_builtins.property
    @pulumi.getter(name="globalEipId")
    def global_eip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs (separated by commas) of global EIPs connected by SNAT rule.
        """
        return pulumi.get(self, "global_eip_id")

    @global_eip_id.setter
    def global_eip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_eip_id", value)

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the nat gateway this snat rule belongs to.
        Changing this creates a new snat rule.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    @_utilities.deprecated("""schema: Deprecated; Use 'subnet_id' instead.""")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the snat rule resource. If omitted, the provider-level region will be used. Changing this creates a new snat rule resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct Connect scenario).
        Defaults to 0, only `cidr` can be specified over a Direct Connect connection.
        Changing this creates a new snat rule.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the snat rule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the network IDs of subnet connected by SNAT rule (VPC side).  
        This parameter and `cidr` are alternative. Changing this will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.type_token("sbercloud:Nat/snatRule:SnatRule")
class SnatRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 floating_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 global_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Snat rule resource within SberCloud Nat

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        snat1 = sbercloud.nat.SnatRule("snat_1",
            nat_gateway_id="3c0dffda-7c76-452b-9dcc-5bce7ae56b17",
            network_id="dc8632e2-d9ff-41b1-aa0c-d455557314a0",
            floating_ip_id="0a166fc5-a904-42fb-b1ef-cf18afeeddca")
        ```

        ## Import

        Snat can be imported using the following format:

        ```sh
        $ pulumi import sbercloud:Nat/snatRule:SnatRule snat_1 9e0713cb-0a2f-484e-8c7d-daecbb61dbe4
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr: Specifies CIDR, which can be in the format of a network segment or a host IP address.
               This parameter and `network_id` are alternative. Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the SNAT rule.
               The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        :param pulumi.Input[_builtins.str] floating_ip_id: ID of the floating ip this snat rule connets to.
               Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] global_eip_id: The IDs (separated by commas) of global EIPs connected by SNAT rule.
        :param pulumi.Input[_builtins.str] nat_gateway_id: ID of the nat gateway this snat rule belongs to.
               Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the snat rule resource. If omitted, the provider-level region will be used. Changing this creates a new snat rule resource.
        :param pulumi.Input[_builtins.int] source_type: Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct Connect scenario).
               Defaults to 0, only `cidr` can be specified over a Direct Connect connection.
               Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the network IDs of subnet connected by SNAT rule (VPC side).  
               This parameter and `cidr` are alternative. Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnatRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Snat rule resource within SberCloud Nat

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        snat1 = sbercloud.nat.SnatRule("snat_1",
            nat_gateway_id="3c0dffda-7c76-452b-9dcc-5bce7ae56b17",
            network_id="dc8632e2-d9ff-41b1-aa0c-d455557314a0",
            floating_ip_id="0a166fc5-a904-42fb-b1ef-cf18afeeddca")
        ```

        ## Import

        Snat can be imported using the following format:

        ```sh
        $ pulumi import sbercloud:Nat/snatRule:SnatRule snat_1 9e0713cb-0a2f-484e-8c7d-daecbb61dbe4
        ```

        :param str resource_name: The name of the resource.
        :param SnatRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnatRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 floating_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 global_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnatRuleArgs.__new__(SnatRuleArgs)

            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["description"] = description
            __props__.__dict__["floating_ip_id"] = floating_ip_id
            __props__.__dict__["global_eip_id"] = global_eip_id
            if nat_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'nat_gateway_id'")
            __props__.__dict__["nat_gateway_id"] = nat_gateway_id
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["region"] = region
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["floating_ip_address"] = None
            __props__.__dict__["freezed_ip_address"] = None
            __props__.__dict__["global_eip_address"] = None
            __props__.__dict__["status"] = None
        super(SnatRule, __self__).__init__(
            'sbercloud:Nat/snatRule:SnatRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            floating_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            floating_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
            freezed_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            global_eip_address: Optional[pulumi.Input[_builtins.str]] = None,
            global_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
            nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            source_type: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SnatRule':
        """
        Get an existing SnatRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr: Specifies CIDR, which can be in the format of a network segment or a host IP address.
               This parameter and `network_id` are alternative. Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the SNAT rule.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the SNAT rule.
               The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        :param pulumi.Input[_builtins.str] floating_ip_address: The actual floating IP address.
        :param pulumi.Input[_builtins.str] floating_ip_id: ID of the floating ip this snat rule connets to.
               Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] freezed_ip_address: The frozen EIP associated with the SNAT rule.
        :param pulumi.Input[_builtins.str] global_eip_address: The global EIP addresses (separated by commas) connected by SNAT rule.
        :param pulumi.Input[_builtins.str] global_eip_id: The IDs (separated by commas) of global EIPs connected by SNAT rule.
        :param pulumi.Input[_builtins.str] nat_gateway_id: ID of the nat gateway this snat rule belongs to.
               Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the snat rule resource. If omitted, the provider-level region will be used. Changing this creates a new snat rule resource.
        :param pulumi.Input[_builtins.int] source_type: Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct Connect scenario).
               Defaults to 0, only `cidr` can be specified over a Direct Connect connection.
               Changing this creates a new snat rule.
        :param pulumi.Input[_builtins.str] status: The status of the snat rule.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the network IDs of subnet connected by SNAT rule (VPC side).  
               This parameter and `cidr` are alternative. Changing this will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnatRuleState.__new__(_SnatRuleState)

        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["floating_ip_address"] = floating_ip_address
        __props__.__dict__["floating_ip_id"] = floating_ip_id
        __props__.__dict__["freezed_ip_address"] = freezed_ip_address
        __props__.__dict__["global_eip_address"] = global_eip_address
        __props__.__dict__["global_eip_id"] = global_eip_id
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["region"] = region
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        return SnatRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies CIDR, which can be in the format of a network segment or a host IP address.
        This parameter and `network_id` are alternative. Changing this creates a new snat rule.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the SNAT rule.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the SNAT rule.
        The value is a string of no more than `255` characters, and angle brackets (<>) are not allowed.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="floatingIpAddress")
    def floating_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The actual floating IP address.
        """
        return pulumi.get(self, "floating_ip_address")

    @_builtins.property
    @pulumi.getter(name="floatingIpId")
    def floating_ip_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the floating ip this snat rule connets to.
        Changing this creates a new snat rule.
        """
        return pulumi.get(self, "floating_ip_id")

    @_builtins.property
    @pulumi.getter(name="freezedIpAddress")
    def freezed_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The frozen EIP associated with the SNAT rule.
        """
        return pulumi.get(self, "freezed_ip_address")

    @_builtins.property
    @pulumi.getter(name="globalEipAddress")
    def global_eip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The global EIP addresses (separated by commas) connected by SNAT rule.
        """
        return pulumi.get(self, "global_eip_address")

    @_builtins.property
    @pulumi.getter(name="globalEipId")
    def global_eip_id(self) -> pulumi.Output[_builtins.str]:
        """
        The IDs (separated by commas) of global EIPs connected by SNAT rule.
        """
        return pulumi.get(self, "global_eip_id")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the nat gateway this snat rule belongs to.
        Changing this creates a new snat rule.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="networkId")
    @_utilities.deprecated("""schema: Deprecated; Use 'subnet_id' instead.""")
    def network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the snat rule resource. If omitted, the provider-level region will be used. Changing this creates a new snat rule resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the scenario. The valid value is 0 (VPC scenario) and 1 (Direct Connect scenario).
        Defaults to 0, only `cidr` can be specified over a Direct Connect connection.
        Changing this creates a new snat rule.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the snat rule.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the network IDs of subnet connected by SNAT rule (VPC side).  
        This parameter and `cidr` are alternative. Changing this will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

