# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AclRuleArgs', 'AclRule']

@pulumi.input_type
class AclRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AclRule resource.
        :param pulumi.Input[_builtins.str] action: Specifies the action in the network ACL rule. Currently, the value can be *allow* or
               *deny*.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol supported by the network ACL rule. Valid values are: *tcp*,
               *udp* and *icmp*.
        :param pulumi.Input[_builtins.str] description: Specifies the description for the network ACL rule.
        :param pulumi.Input[_builtins.str] destination_ip_address: Specifies the destination IP address to which the traffic is allowed.
               The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[_builtins.str] destination_port: Specifies the destination port number or port number range. The value ranges
               from 1 to 65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        :param pulumi.Input[_builtins.bool] enabled: Enabled status for the network ACL rule. Defaults to true.
        :param pulumi.Input[_builtins.int] ip_version: Specifies the IP version, either 4 (default) or 6. This parameter is available after
               the IPv6 function is enabled.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the network ACL rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the network ACL rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new network ACL rule resource.
        :param pulumi.Input[_builtins.str] source_ip_address: Specifies the source IP address that the traffic is allowed from. The default
               value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[_builtins.str] source_port: Specifies the source port number or port number range. The value ranges from 1 to
               65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ip_address is not None:
            pulumi.set(__self__, "destination_ip_address", destination_ip_address)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the action in the network ACL rule. Currently, the value can be *allow* or
        *deny*.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the protocol supported by the network ACL rule. Valid values are: *tcp*,
        *udp* and *icmp*.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description for the network ACL rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination IP address to which the traffic is allowed.
        The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        """
        return pulumi.get(self, "destination_ip_address")

    @destination_ip_address.setter
    def destination_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination port number or port number range. The value ranges
        from 1 to 65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_port", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enabled status for the network ACL rule. Defaults to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IP version, either 4 (default) or 6. This parameter is available after
        the IPv6 function is enabled.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique name for the network ACL rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the network ACL rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new network ACL rule resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the source IP address that the traffic is allowed from. The default
        value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        """
        return pulumi.get(self, "source_ip_address")

    @source_ip_address.setter
    def source_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the source port number or port number range. The value ranges from 1 to
        65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_port", value)


@pulumi.input_type
class _AclRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AclRule resources.
        :param pulumi.Input[_builtins.str] action: Specifies the action in the network ACL rule. Currently, the value can be *allow* or
               *deny*.
        :param pulumi.Input[_builtins.str] description: Specifies the description for the network ACL rule.
        :param pulumi.Input[_builtins.str] destination_ip_address: Specifies the destination IP address to which the traffic is allowed.
               The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[_builtins.str] destination_port: Specifies the destination port number or port number range. The value ranges
               from 1 to 65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        :param pulumi.Input[_builtins.bool] enabled: Enabled status for the network ACL rule. Defaults to true.
        :param pulumi.Input[_builtins.int] ip_version: Specifies the IP version, either 4 (default) or 6. This parameter is available after
               the IPv6 function is enabled.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the network ACL rule.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol supported by the network ACL rule. Valid values are: *tcp*,
               *udp* and *icmp*.
        :param pulumi.Input[_builtins.str] region: The region in which to create the network ACL rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new network ACL rule resource.
        :param pulumi.Input[_builtins.str] source_ip_address: Specifies the source IP address that the traffic is allowed from. The default
               value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[_builtins.str] source_port: Specifies the source port number or port number range. The value ranges from 1 to
               65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ip_address is not None:
            pulumi.set(__self__, "destination_ip_address", destination_ip_address)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the action in the network ACL rule. Currently, the value can be *allow* or
        *deny*.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description for the network ACL rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination IP address to which the traffic is allowed.
        The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        """
        return pulumi.get(self, "destination_ip_address")

    @destination_ip_address.setter
    def destination_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination port number or port number range. The value ranges
        from 1 to 65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_port", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enabled status for the network ACL rule. Defaults to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IP version, either 4 (default) or 6. This parameter is available after
        the IPv6 function is enabled.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique name for the network ACL rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol supported by the network ACL rule. Valid values are: *tcp*,
        *udp* and *icmp*.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the network ACL rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new network ACL rule resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the source IP address that the traffic is allowed from. The default
        value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        """
        return pulumi.get(self, "source_ip_address")

    @source_ip_address.setter
    def source_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the source port number or port number range. The value ranges from 1 to
        65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_port", value)


@pulumi.type_token("sbercloud:NetworkAcl/aclRule:AclRule")
class AclRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a network ACL rule resource within SberCloud.

        ## Basic Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        rule1 = sbercloud.networkacl.AclRule("rule_1",
            name="rule_1",
            protocol="udp",
            action="deny",
            source_ip_address="1.2.3.4",
            source_port="444",
            destination_ip_address="4.3.2.0/24",
            destination_port="555")
        ```

        ## Create a network acl rule with range port

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        rule2 = sbercloud.networkacl.AclRule("rule_2",
            protocol="tcp",
            ip_version=4,
            action="allow",
            destination_port="1:100")
        ```

        ## Import

        network ACL rules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:NetworkAcl/aclRule:AclRule rule_1 89a84b28-4cc2-4859-9885-c67e802a46a3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Specifies the action in the network ACL rule. Currently, the value can be *allow* or
               *deny*.
        :param pulumi.Input[_builtins.str] description: Specifies the description for the network ACL rule.
        :param pulumi.Input[_builtins.str] destination_ip_address: Specifies the destination IP address to which the traffic is allowed.
               The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[_builtins.str] destination_port: Specifies the destination port number or port number range. The value ranges
               from 1 to 65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        :param pulumi.Input[_builtins.bool] enabled: Enabled status for the network ACL rule. Defaults to true.
        :param pulumi.Input[_builtins.int] ip_version: Specifies the IP version, either 4 (default) or 6. This parameter is available after
               the IPv6 function is enabled.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the network ACL rule.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol supported by the network ACL rule. Valid values are: *tcp*,
               *udp* and *icmp*.
        :param pulumi.Input[_builtins.str] region: The region in which to create the network ACL rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new network ACL rule resource.
        :param pulumi.Input[_builtins.str] source_ip_address: Specifies the source IP address that the traffic is allowed from. The default
               value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[_builtins.str] source_port: Specifies the source port number or port number range. The value ranges from 1 to
               65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a network ACL rule resource within SberCloud.

        ## Basic Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        rule1 = sbercloud.networkacl.AclRule("rule_1",
            name="rule_1",
            protocol="udp",
            action="deny",
            source_ip_address="1.2.3.4",
            source_port="444",
            destination_ip_address="4.3.2.0/24",
            destination_port="555")
        ```

        ## Create a network acl rule with range port

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        rule2 = sbercloud.networkacl.AclRule("rule_2",
            protocol="tcp",
            ip_version=4,
            action="allow",
            destination_port="1:100")
        ```

        ## Import

        network ACL rules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:NetworkAcl/aclRule:AclRule rule_1 89a84b28-4cc2-4859-9885-c67e802a46a3
        ```

        :param str resource_name: The name of the resource.
        :param AclRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclRuleArgs.__new__(AclRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_ip_address"] = destination_ip_address
            __props__.__dict__["destination_port"] = destination_port
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["name"] = name
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["source_ip_address"] = source_ip_address
            __props__.__dict__["source_port"] = source_port
        super(AclRule, __self__).__init__(
            'sbercloud:NetworkAcl/aclRule:AclRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            destination_port: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_version: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            source_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            source_port: Optional[pulumi.Input[_builtins.str]] = None) -> 'AclRule':
        """
        Get an existing AclRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Specifies the action in the network ACL rule. Currently, the value can be *allow* or
               *deny*.
        :param pulumi.Input[_builtins.str] description: Specifies the description for the network ACL rule.
        :param pulumi.Input[_builtins.str] destination_ip_address: Specifies the destination IP address to which the traffic is allowed.
               The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[_builtins.str] destination_port: Specifies the destination port number or port number range. The value ranges
               from 1 to 65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        :param pulumi.Input[_builtins.bool] enabled: Enabled status for the network ACL rule. Defaults to true.
        :param pulumi.Input[_builtins.int] ip_version: Specifies the IP version, either 4 (default) or 6. This parameter is available after
               the IPv6 function is enabled.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the network ACL rule.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol supported by the network ACL rule. Valid values are: *tcp*,
               *udp* and *icmp*.
        :param pulumi.Input[_builtins.str] region: The region in which to create the network ACL rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new network ACL rule resource.
        :param pulumi.Input[_builtins.str] source_ip_address: Specifies the source IP address that the traffic is allowed from. The default
               value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[_builtins.str] source_port: Specifies the source port number or port number range. The value ranges from 1 to
               65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclRuleState.__new__(_AclRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_ip_address"] = destination_ip_address
        __props__.__dict__["destination_port"] = destination_port
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["source_ip_address"] = source_ip_address
        __props__.__dict__["source_port"] = source_port
        return AclRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the action in the network ACL rule. Currently, the value can be *allow* or
        *deny*.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description for the network ACL rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the destination IP address to which the traffic is allowed.
        The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        """
        return pulumi.get(self, "destination_ip_address")

    @_builtins.property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the destination port number or port number range. The value ranges
        from 1 to 65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        """
        return pulumi.get(self, "destination_port")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enabled status for the network ACL rule. Defaults to true.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the IP version, either 4 (default) or 6. This parameter is available after
        the IPv6 function is enabled.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a unique name for the network ACL rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the protocol supported by the network ACL rule. Valid values are: *tcp*,
        *udp* and *icmp*.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the network ACL rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new network ACL rule resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the source IP address that the traffic is allowed from. The default
        value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        """
        return pulumi.get(self, "source_ip_address")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the source port number or port number range. The value ranges from 1 to
        65535. For a port number range, enter two port numbers connected by a colon(:). For example, 1:100.
        """
        return pulumi.get(self, "source_port")

