# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NetworkingEipAssociateArgs', 'NetworkingEipAssociate']

@pulumi.input_type
class NetworkingEipAssociateArgs:
    def __init__(__self__, *,
                 public_ip: pulumi.Input[_builtins.str],
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkingEipAssociate resource.
        :param pulumi.Input[_builtins.str] public_ip: The EIP to associate.
        :param pulumi.Input[_builtins.str] port_id: ID of an existing port with at least one IP address to
               associate with this EIP.
        """
        pulumi.set(__self__, "public_ip", public_ip)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Input[_builtins.str]:
        """
        The EIP to associate.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fixed_ip", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of an existing port with at least one IP address to
        associate with this EIP.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _NetworkingEipAssociateState:
    def __init__(__self__, *,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkingEipAssociate resources.
        :param pulumi.Input[_builtins.str] port_id: ID of an existing port with at least one IP address to
               associate with this EIP.
        :param pulumi.Input[_builtins.str] public_ip: The EIP to associate.
        """
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ipv6 is not None:
            pulumi.set(__self__, "public_ipv6", public_ipv6)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fixed_ip", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of an existing port with at least one IP address to
        associate with this EIP.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EIP to associate.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicIpv6")
    def public_ipv6(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_ipv6")

    @public_ipv6.setter
    def public_ipv6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ipv6", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("sbercloud:index/networkingEipAssociate:NetworkingEipAssociate")
class NetworkingEipAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Associates an EIP to a port.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        myport = sbercloud.Vpc.get_port(network_id="a5bbd213-e1d3-49b6-aed1-9df60ea94b9a")
        myeip = sbercloud.vpc.Eip("myeip",
            publicip={
                "type": "5_bgp",
            },
            bandwidth={
                "name": "test",
                "size": 8,
                "share_type": "PER",
                "charge_mode": "traffic",
            })
        associated = sbercloud.NetworkingEipAssociate("associated",
            public_ip=myeip.address,
            port_id=myport.id)
        ```

        ## Import

        EIP associations can be imported using the `id` of the EIP, e.g.

        ```sh
        $ pulumi import sbercloud:index/networkingEipAssociate:NetworkingEipAssociate eip 2c7f39f3-702b-48d1-940c-b50384177ee1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] port_id: ID of an existing port with at least one IP address to
               associate with this EIP.
        :param pulumi.Input[_builtins.str] public_ip: The EIP to associate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkingEipAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates an EIP to a port.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        myport = sbercloud.Vpc.get_port(network_id="a5bbd213-e1d3-49b6-aed1-9df60ea94b9a")
        myeip = sbercloud.vpc.Eip("myeip",
            publicip={
                "type": "5_bgp",
            },
            bandwidth={
                "name": "test",
                "size": 8,
                "share_type": "PER",
                "charge_mode": "traffic",
            })
        associated = sbercloud.NetworkingEipAssociate("associated",
            public_ip=myeip.address,
            port_id=myport.id)
        ```

        ## Import

        EIP associations can be imported using the `id` of the EIP, e.g.

        ```sh
        $ pulumi import sbercloud:index/networkingEipAssociate:NetworkingEipAssociate eip 2c7f39f3-702b-48d1-940c-b50384177ee1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkingEipAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkingEipAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkingEipAssociateArgs.__new__(NetworkingEipAssociateArgs)

            __props__.__dict__["fixed_ip"] = fixed_ip
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["port_id"] = port_id
            if public_ip is None and not opts.urn:
                raise TypeError("Missing required property 'public_ip'")
            __props__.__dict__["public_ip"] = public_ip
            __props__.__dict__["region"] = region
            __props__.__dict__["mac_address"] = None
            __props__.__dict__["public_ipv6"] = None
            __props__.__dict__["status"] = None
        super(NetworkingEipAssociate, __self__).__init__(
            'sbercloud:index/networkingEipAssociate:NetworkingEipAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
            mac_address: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            port_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[_builtins.str]] = None,
            public_ipv6: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkingEipAssociate':
        """
        Get an existing NetworkingEipAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] port_id: ID of an existing port with at least one IP address to
               associate with this EIP.
        :param pulumi.Input[_builtins.str] public_ip: The EIP to associate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkingEipAssociateState.__new__(_NetworkingEipAssociateState)

        __props__.__dict__["fixed_ip"] = fixed_ip
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["public_ipv6"] = public_ipv6
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        return NetworkingEipAssociate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "fixed_ip")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of an existing port with at least one IP address to
        associate with this EIP.
        """
        return pulumi.get(self, "port_id")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The EIP to associate.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="publicIpv6")
    def public_ipv6(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "public_ipv6")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "status")

