# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BucketObjectArgs', 'BucketObject']

@pulumi.input_type
class BucketObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 key: pulumi.Input[_builtins.str],
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BucketObject resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket to put the file in.
        :param pulumi.Input[_builtins.str] key: The name of the object once it is in the bucket.
        :param pulumi.Input[_builtins.str] acl: The ACL policy to apply. Defaults to `private`.
        :param pulumi.Input[_builtins.str] content: The literal content being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. application/octet-stream.
               All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] etag: Specifies the unique identifier of the object content. It can be used to trigger updates.
               The only meaningful value is `md5(file("path_to_file"))`.
               
               Either `source` or `content` must be provided to specify the bucket content.
               These two arguments are mutually-exclusive.
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the kms key. If omitted, the default master key will be used.
        :param pulumi.Input[_builtins.str] region: The region in which to create the OBS bucket object resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket object resource.
        :param pulumi.Input[_builtins.str] source: The path to the source file being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] storage_class: Specifies the storage class of the object. Defaults to `STANDARD`.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the bucket to put the file in.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL policy to apply. Defaults to `private`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The literal content being uploaded to the bucket.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A standard MIME type describing the format of the object data, e.g. application/octet-stream.
        All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the unique identifier of the object content. It can be used to trigger updates.
        The only meaningful value is `md5(file("path_to_file"))`.

        Either `source` or `content` must be provided to specify the bucket content.
        These two arguments are mutually-exclusive.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the kms key. If omitted, the default master key will be used.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the OBS bucket object resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket object resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the source file being uploaded to the bucket.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the storage class of the object. Defaults to `STANDARD`.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_class", value)


@pulumi.input_type
class _BucketObjectState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketObject resources.
        :param pulumi.Input[_builtins.str] acl: The ACL policy to apply. Defaults to `private`.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket to put the file in.
        :param pulumi.Input[_builtins.str] content: The literal content being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. application/octet-stream.
               All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] etag: Specifies the unique identifier of the object content. It can be used to trigger updates.
               The only meaningful value is `md5(file("path_to_file"))`.
               
               Either `source` or `content` must be provided to specify the bucket content.
               These two arguments are mutually-exclusive.
        :param pulumi.Input[_builtins.str] key: The name of the object once it is in the bucket.
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the kms key. If omitted, the default master key will be used.
        :param pulumi.Input[_builtins.str] region: The region in which to create the OBS bucket object resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket object resource.
        :param pulumi.Input[_builtins.int] size: the size of the object in bytes.
        :param pulumi.Input[_builtins.str] source: The path to the source file being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] storage_class: Specifies the storage class of the object. Defaults to `STANDARD`.
        :param pulumi.Input[_builtins.str] version_id: A unique version ID value for the object, if bucket versioning is enabled.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL policy to apply. Defaults to `private`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket to put the file in.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The literal content being uploaded to the bucket.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A standard MIME type describing the format of the object data, e.g. application/octet-stream.
        All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the unique identifier of the object content. It can be used to trigger updates.
        The only meaningful value is `md5(file("path_to_file"))`.

        Either `source` or `content` must be provided to specify the bucket content.
        These two arguments are mutually-exclusive.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the kms key. If omitted, the default master key will be used.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the OBS bucket object resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket object resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        the size of the object in bytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the source file being uploaded to the bucket.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the storage class of the object. Defaults to `STANDARD`.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_class", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique version ID value for the object, if bucket versioning is enabled.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_id", value)


@pulumi.type_token("sbercloud:Obs/bucketObject:BucketObject")
class BucketObject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an OBS bucket object resource.

        ## Example Usage

        ### Uploading to a bucket

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        object = sbercloud.obs.BucketObject("object",
            bucket="your_bucket_name",
            key="new_key_from_content",
            content="some object content",
            content_type="application/xml")
        ```

        ### Uploading a file to a bucket

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        examplebucket = sbercloud.obs.Bucket("examplebucket",
            bucket="examplebuckettftest",
            acl="private")
        object = sbercloud.obs.BucketObject("object",
            bucket=examplebucket.bucket,
            key="new_key_from_file",
            source="index.html")
        ```

        ## Import

        OBS bucket object can be imported using the bucket and key separated by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:Obs/bucketObject:BucketObject object bucket/key
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `encryption`, `source`, `acl` and

        `kms_key_id`. It is generally recommended running `pulumi preview` after importing an object.

        You can then decide if changes should be applied to the object, or the resource

        definition should be updated to align with the object. Also you can ignore changes as below.

        resource "sbercloud_obs_bucket_object" "object" {

            ...

          lifecycle {

            ignore_changes = [
            
              encryption, source, acl, kms_key_id,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: The ACL policy to apply. Defaults to `private`.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket to put the file in.
        :param pulumi.Input[_builtins.str] content: The literal content being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. application/octet-stream.
               All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] etag: Specifies the unique identifier of the object content. It can be used to trigger updates.
               The only meaningful value is `md5(file("path_to_file"))`.
               
               Either `source` or `content` must be provided to specify the bucket content.
               These two arguments are mutually-exclusive.
        :param pulumi.Input[_builtins.str] key: The name of the object once it is in the bucket.
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the kms key. If omitted, the default master key will be used.
        :param pulumi.Input[_builtins.str] region: The region in which to create the OBS bucket object resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket object resource.
        :param pulumi.Input[_builtins.str] source: The path to the source file being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] storage_class: Specifies the storage class of the object. Defaults to `STANDARD`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketObjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an OBS bucket object resource.

        ## Example Usage

        ### Uploading to a bucket

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        object = sbercloud.obs.BucketObject("object",
            bucket="your_bucket_name",
            key="new_key_from_content",
            content="some object content",
            content_type="application/xml")
        ```

        ### Uploading a file to a bucket

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        examplebucket = sbercloud.obs.Bucket("examplebucket",
            bucket="examplebuckettftest",
            acl="private")
        object = sbercloud.obs.BucketObject("object",
            bucket=examplebucket.bucket,
            key="new_key_from_file",
            source="index.html")
        ```

        ## Import

        OBS bucket object can be imported using the bucket and key separated by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:Obs/bucketObject:BucketObject object bucket/key
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `encryption`, `source`, `acl` and

        `kms_key_id`. It is generally recommended running `pulumi preview` after importing an object.

        You can then decide if changes should be applied to the object, or the resource

        definition should be updated to align with the object. Also you can ignore changes as below.

        resource "sbercloud_obs_bucket_object" "object" {

            ...

          lifecycle {

            ignore_changes = [
            
              encryption, source, acl, kms_key_id,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param BucketObjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketObjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketObjectArgs.__new__(BucketObjectArgs)

            __props__.__dict__["acl"] = acl
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["content"] = content
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["etag"] = etag
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["region"] = region
            __props__.__dict__["source"] = source
            __props__.__dict__["storage_class"] = storage_class
            __props__.__dict__["size"] = None
            __props__.__dict__["version_id"] = None
        super(BucketObject, __self__).__init__(
            'sbercloud:Obs/bucketObject:BucketObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[_builtins.str]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            content_type: Optional[pulumi.Input[_builtins.str]] = None,
            encryption: Optional[pulumi.Input[_builtins.bool]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            storage_class: Optional[pulumi.Input[_builtins.str]] = None,
            version_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BucketObject':
        """
        Get an existing BucketObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: The ACL policy to apply. Defaults to `private`.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket to put the file in.
        :param pulumi.Input[_builtins.str] content: The literal content being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. application/octet-stream.
               All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] etag: Specifies the unique identifier of the object content. It can be used to trigger updates.
               The only meaningful value is `md5(file("path_to_file"))`.
               
               Either `source` or `content` must be provided to specify the bucket content.
               These two arguments are mutually-exclusive.
        :param pulumi.Input[_builtins.str] key: The name of the object once it is in the bucket.
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the kms key. If omitted, the default master key will be used.
        :param pulumi.Input[_builtins.str] region: The region in which to create the OBS bucket object resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket object resource.
        :param pulumi.Input[_builtins.int] size: the size of the object in bytes.
        :param pulumi.Input[_builtins.str] source: The path to the source file being uploaded to the bucket.
        :param pulumi.Input[_builtins.str] storage_class: Specifies the storage class of the object. Defaults to `STANDARD`.
        :param pulumi.Input[_builtins.str] version_id: A unique version ID value for the object, if bucket versioning is enabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketObjectState.__new__(_BucketObjectState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["content"] = content
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["etag"] = etag
        __props__.__dict__["key"] = key
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["source"] = source
        __props__.__dict__["storage_class"] = storage_class
        __props__.__dict__["version_id"] = version_id
        return BucketObject(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ACL policy to apply. Defaults to `private`.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket to put the file in.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The literal content being uploaded to the bucket.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[_builtins.str]:
        """
        A standard MIME type describing the format of the object data, e.g. application/octet-stream.
        All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the unique identifier of the object content. It can be used to trigger updates.
        The only meaningful value is `md5(file("path_to_file"))`.

        Either `source` or `content` must be provided to specify the bucket content.
        These two arguments are mutually-exclusive.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the kms key. If omitted, the default master key will be used.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the OBS bucket object resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket object resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        the size of the object in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path to the source file being uploaded to the bucket.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the storage class of the object. Defaults to `STANDARD`.
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[_builtins.str]:
        """
        A unique version ID value for the object, if bucket versioning is enabled.
        """
        return pulumi.get(self, "version_id")

