# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BucketPolicyArgs', 'BucketPolicy']

@pulumi.input_type
class BucketPolicyArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 policy: pulumi.Input[_builtins.str],
                 policy_format: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BucketPolicy resource.
        :param pulumi.Input[_builtins.str] bucket: Specifies the name of the bucket to which to apply the policy.
        :param pulumi.Input[_builtins.str] policy: Specifies the text of the bucket policy in JSON format. For more information about
               obs format bucket policy, see the [Developer Guide](https://support.hc.sbercloud.ru/api/obs/obs_04_0027.html).
        :param pulumi.Input[_builtins.str] policy_format: Specifies the policy format, the supported values are *obs* and *s3*. Defaults to *obs* .
        :param pulumi.Input[_builtins.str] region: The region in which to create the OBS bucket policy resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket policy resource.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "policy", policy)
        if policy_format is not None:
            pulumi.set(__self__, "policy_format", policy_format)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the bucket to which to apply the policy.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the text of the bucket policy in JSON format. For more information about
        obs format bucket policy, see the [Developer Guide](https://support.hc.sbercloud.ru/api/obs/obs_04_0027.html).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="policyFormat")
    def policy_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy format, the supported values are *obs* and *s3*. Defaults to *obs* .
        """
        return pulumi.get(self, "policy_format")

    @policy_format.setter
    def policy_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_format", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the OBS bucket policy resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket policy resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _BucketPolicyState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_format: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketPolicy resources.
        :param pulumi.Input[_builtins.str] bucket: Specifies the name of the bucket to which to apply the policy.
        :param pulumi.Input[_builtins.str] policy: Specifies the text of the bucket policy in JSON format. For more information about
               obs format bucket policy, see the [Developer Guide](https://support.hc.sbercloud.ru/api/obs/obs_04_0027.html).
        :param pulumi.Input[_builtins.str] policy_format: Specifies the policy format, the supported values are *obs* and *s3*. Defaults to *obs* .
        :param pulumi.Input[_builtins.str] region: The region in which to create the OBS bucket policy resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket policy resource.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if policy_format is not None:
            pulumi.set(__self__, "policy_format", policy_format)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the bucket to which to apply the policy.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the text of the bucket policy in JSON format. For more information about
        obs format bucket policy, see the [Developer Guide](https://support.hc.sbercloud.ru/api/obs/obs_04_0027.html).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="policyFormat")
    def policy_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy format, the supported values are *obs* and *s3*. Defaults to *obs* .
        """
        return pulumi.get(self, "policy_format")

    @policy_format.setter
    def policy_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_format", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the OBS bucket policy resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket policy resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Obs/bucketPolicy:BucketPolicy")
class BucketPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_format: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Attaches a policy to an OBS bucket resource.

        ## Example Usage

        ### Policy with OBS format

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        bucket = sbercloud.obs.Bucket("bucket", bucket="my-test-bucket")
        policy = sbercloud.obs.BucketPolicy("policy",
            bucket=bucket.id,
            policy=\"\"\"{
          "Statement": [
            {
              "Sid": "AddPerm",
              "Effect": "Allow",
              "Principal": {"ID": "*"},
              "Action": ["GetObject"],
              "Resource": "my-test-bucket/*"
            } 
          ]
        }
        \"\"\")
        ```

        ### Policy with S3 format

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        bucket = sbercloud.obs.Bucket("bucket", bucket="my-test-bucket")
        s3_policy = sbercloud.obs.BucketPolicy("s3_policy",
            bucket=bucket.id,
            policy_format="s3",
            policy=\"\"\"{
          "Version": "2008-10-17",
          "Id": "MYBUCKETPOLICY",
          "Statement": [
            {
              "Sid": "IPAllow",
              "Effect": "Allow",
              "Principal": "*",
              "Action": "s3:*",
              "Resource": "arn:aws:s3:::my-test-bucket/*",
              "Condition": {
                "IpAddress": {"aws:SourceIp": "8.8.8.8/32"}
              }
            }
          ]
        }
        \"\"\")
        ```

        ## Import

        OBS format bucket policy can be imported using the `<bucket>`, e.g.

        ```sh
        $ pulumi import sbercloud:Obs/bucketPolicy:BucketPolicy policy <bucket-name>
        ```
        S3 foramt bucket policy can be imported using the `<bucket>` and "s3" by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:Obs/bucketPolicy:BucketPolicy s3_policy <bucket-name>/s3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: Specifies the name of the bucket to which to apply the policy.
        :param pulumi.Input[_builtins.str] policy: Specifies the text of the bucket policy in JSON format. For more information about
               obs format bucket policy, see the [Developer Guide](https://support.hc.sbercloud.ru/api/obs/obs_04_0027.html).
        :param pulumi.Input[_builtins.str] policy_format: Specifies the policy format, the supported values are *obs* and *s3*. Defaults to *obs* .
        :param pulumi.Input[_builtins.str] region: The region in which to create the OBS bucket policy resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket policy resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attaches a policy to an OBS bucket resource.

        ## Example Usage

        ### Policy with OBS format

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        bucket = sbercloud.obs.Bucket("bucket", bucket="my-test-bucket")
        policy = sbercloud.obs.BucketPolicy("policy",
            bucket=bucket.id,
            policy=\"\"\"{
          "Statement": [
            {
              "Sid": "AddPerm",
              "Effect": "Allow",
              "Principal": {"ID": "*"},
              "Action": ["GetObject"],
              "Resource": "my-test-bucket/*"
            } 
          ]
        }
        \"\"\")
        ```

        ### Policy with S3 format

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        bucket = sbercloud.obs.Bucket("bucket", bucket="my-test-bucket")
        s3_policy = sbercloud.obs.BucketPolicy("s3_policy",
            bucket=bucket.id,
            policy_format="s3",
            policy=\"\"\"{
          "Version": "2008-10-17",
          "Id": "MYBUCKETPOLICY",
          "Statement": [
            {
              "Sid": "IPAllow",
              "Effect": "Allow",
              "Principal": "*",
              "Action": "s3:*",
              "Resource": "arn:aws:s3:::my-test-bucket/*",
              "Condition": {
                "IpAddress": {"aws:SourceIp": "8.8.8.8/32"}
              }
            }
          ]
        }
        \"\"\")
        ```

        ## Import

        OBS format bucket policy can be imported using the `<bucket>`, e.g.

        ```sh
        $ pulumi import sbercloud:Obs/bucketPolicy:BucketPolicy policy <bucket-name>
        ```
        S3 foramt bucket policy can be imported using the `<bucket>` and "s3" by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:Obs/bucketPolicy:BucketPolicy s3_policy <bucket-name>/s3
        ```

        :param str resource_name: The name of the resource.
        :param BucketPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_format: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketPolicyArgs.__new__(BucketPolicyArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            __props__.__dict__["policy_format"] = policy_format
            __props__.__dict__["region"] = region
        super(BucketPolicy, __self__).__init__(
            'sbercloud:Obs/bucketPolicy:BucketPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            policy: Optional[pulumi.Input[_builtins.str]] = None,
            policy_format: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'BucketPolicy':
        """
        Get an existing BucketPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: Specifies the name of the bucket to which to apply the policy.
        :param pulumi.Input[_builtins.str] policy: Specifies the text of the bucket policy in JSON format. For more information about
               obs format bucket policy, see the [Developer Guide](https://support.hc.sbercloud.ru/api/obs/obs_04_0027.html).
        :param pulumi.Input[_builtins.str] policy_format: Specifies the policy format, the supported values are *obs* and *s3*. Defaults to *obs* .
        :param pulumi.Input[_builtins.str] region: The region in which to create the OBS bucket policy resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket policy resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketPolicyState.__new__(_BucketPolicyState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["policy"] = policy
        __props__.__dict__["policy_format"] = policy_format
        __props__.__dict__["region"] = region
        return BucketPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the bucket to which to apply the policy.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the text of the bucket policy in JSON format. For more information about
        obs format bucket policy, see the [Developer Guide](https://support.hc.sbercloud.ru/api/obs/obs_04_0027.html).
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="policyFormat")
    def policy_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the policy format, the supported values are *obs* and *s3*. Defaults to *obs* .
        """
        return pulumi.get(self, "policy_format")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the OBS bucket policy resource. If omitted, the provider-level region will be used. Changing this creates a new OBS bucket policy resource.
        """
        return pulumi.get(self, "region")

