# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBucketObjectResult',
    'AwaitableGetBucketObjectResult',
    'get_bucket_object',
    'get_bucket_object_output',
]

@pulumi.output_type
class GetBucketObjectResult:
    """
    A collection of values returned by getBucketObject.
    """
    def __init__(__self__, body=None, bucket=None, content_type=None, etag=None, id=None, key=None, region=None, size=None, storage_class=None, version_id=None):
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        pulumi.set(__self__, "body", body)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if storage_class and not isinstance(storage_class, str):
            raise TypeError("Expected argument 'storage_class' to be a str")
        pulumi.set(__self__, "storage_class", storage_class)
        if version_id and not isinstance(version_id, str):
            raise TypeError("Expected argument 'version_id' to be a str")
        pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter
    def body(self) -> _builtins.str:
        """
        The content of an object which is available only for objects which have a human-readable Content-Type
        (text/* and application/json) and smaller than **64KB**. This is to prevent printing unsafe characters and
        potentially downloading large amount of data.
        """
        return pulumi.get(self, "body")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        a standard MIME type describing the format of the object data, e.g. application/octet-stream.
        All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        the ETag generated for the object (an MD5 sum of the object content). When the object is encrypted on the
        server side, the ETag value is not the MD5 value of the object, but the unique identifier calculated through the
        server-side encryption.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        the size of the object in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        specifies the storage class of the object.
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        a unique version ID value for the object, if bucket versioning is enabled.
        """
        return pulumi.get(self, "version_id")


class AwaitableGetBucketObjectResult(GetBucketObjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBucketObjectResult(
            body=self.body,
            bucket=self.bucket,
            content_type=self.content_type,
            etag=self.etag,
            id=self.id,
            key=self.key,
            region=self.region,
            size=self.size,
            storage_class=self.storage_class,
            version_id=self.version_id)


def get_bucket_object(bucket: Optional[_builtins.str] = None,
                      key: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBucketObjectResult:
    """
    Use this data source to get info of special SberCloud obs object.

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    object = sbercloud.Obs.get_bucket_object(bucket="my-test-bucket",
        key="new-key")
    ```


    :param _builtins.str bucket: The name of the bucket to put the file in.
    :param _builtins.str key: The name of the object once it is in the bucket.
    :param _builtins.str region: The region in which to obtain the OBS object. If omitted, the provider-level region will
           be used.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['key'] = key
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Obs/getBucketObject:getBucketObject', __args__, opts=opts, typ=GetBucketObjectResult).value

    return AwaitableGetBucketObjectResult(
        body=pulumi.get(__ret__, 'body'),
        bucket=pulumi.get(__ret__, 'bucket'),
        content_type=pulumi.get(__ret__, 'content_type'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        key=pulumi.get(__ret__, 'key'),
        region=pulumi.get(__ret__, 'region'),
        size=pulumi.get(__ret__, 'size'),
        storage_class=pulumi.get(__ret__, 'storage_class'),
        version_id=pulumi.get(__ret__, 'version_id'))
def get_bucket_object_output(bucket: Optional[pulumi.Input[_builtins.str]] = None,
                             key: Optional[pulumi.Input[_builtins.str]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBucketObjectResult]:
    """
    Use this data source to get info of special SberCloud obs object.

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    object = sbercloud.Obs.get_bucket_object(bucket="my-test-bucket",
        key="new-key")
    ```


    :param _builtins.str bucket: The name of the bucket to put the file in.
    :param _builtins.str key: The name of the object once it is in the bucket.
    :param _builtins.str region: The region in which to obtain the OBS object. If omitted, the provider-level region will
           be used.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['key'] = key
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Obs/getBucketObject:getBucketObject', __args__, opts=opts, typ=GetBucketObjectResult)
    return __ret__.apply(lambda __response__: GetBucketObjectResult(
        body=pulumi.get(__response__, 'body'),
        bucket=pulumi.get(__response__, 'bucket'),
        content_type=pulumi.get(__response__, 'content_type'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        key=pulumi.get(__response__, 'key'),
        region=pulumi.get(__response__, 'region'),
        size=pulumi.get(__response__, 'size'),
        storage_class=pulumi.get(__response__, 'storage_class'),
        version_id=pulumi.get(__response__, 'version_id')))
