# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBucketsResult',
    'AwaitableGetBucketsResult',
    'get_buckets',
    'get_buckets_output',
]

@pulumi.output_type
class GetBucketsResult:
    """
    A collection of values returned by getBuckets.
    """
    def __init__(__self__, bucket=None, buckets=None, enterprise_project_id=None, id=None, region=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if buckets and not isinstance(buckets, list):
            raise TypeError("Expected argument 'buckets' to be a list")
        pulumi.set(__self__, "buckets", buckets)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        The name of the OBS bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def buckets(self) -> Sequence['outputs.GetBucketsBucketResult']:
        """
        A list of OBS buckets.
        """
        return pulumi.get(self, "buckets")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        The enterprise project id of the OBS bucket.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region where the OBS bucket belongs.
        """
        return pulumi.get(self, "region")


class AwaitableGetBucketsResult(GetBucketsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBucketsResult(
            bucket=self.bucket,
            buckets=self.buckets,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            region=self.region)


def get_buckets(bucket: Optional[_builtins.str] = None,
                enterprise_project_id: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBucketsResult:
    """
    Use this data source to get all OBS buckets.

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    buckets = sbercloud.Obs.get_buckets(bucket="your-bucket-name")
    ```


    :param _builtins.str bucket: The name of the OBS bucket.
    :param _builtins.str enterprise_project_id: The enterprise project id of the OBS bucket.
    :param _builtins.str region: The region in which to obtain the OBS bucket.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Obs/getBuckets:getBuckets', __args__, opts=opts, typ=GetBucketsResult).value

    return AwaitableGetBucketsResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        buckets=pulumi.get(__ret__, 'buckets'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_buckets_output(bucket: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBucketsResult]:
    """
    Use this data source to get all OBS buckets.

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    buckets = sbercloud.Obs.get_buckets(bucket="your-bucket-name")
    ```


    :param _builtins.str bucket: The name of the OBS bucket.
    :param _builtins.str enterprise_project_id: The enterprise project id of the OBS bucket.
    :param _builtins.str region: The region in which to obtain the OBS bucket.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Obs/getBuckets:getBuckets', __args__, opts=opts, typ=GetBucketsResult)
    return __ret__.apply(lambda __response__: GetBucketsResult(
        bucket=pulumi.get(__response__, 'bucket'),
        buckets=pulumi.get(__response__, 'buckets'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
