# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BucketCorsRule',
    'BucketLifecycleRule',
    'BucketLifecycleRuleAbortIncompleteMultipartUpload',
    'BucketLifecycleRuleExpiration',
    'BucketLifecycleRuleNoncurrentVersionExpiration',
    'BucketLifecycleRuleNoncurrentVersionTransition',
    'BucketLifecycleRuleTransition',
    'BucketLogging',
    'BucketStorageInfo',
    'BucketWebsite',
    'GetBucketsBucketResult',
]

@pulumi.output_type
class BucketCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 allowed_headers: Optional[Sequence[_builtins.str]] = None,
                 expose_headers: Optional[Sequence[_builtins.str]] = None,
                 max_age_seconds: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] allowed_methods: Specifies the acceptable operation type of buckets and objects.
               The methods include `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        :param Sequence[_builtins.str] allowed_origins: Requests from this origin can access the bucket. Multiple matching rules are allowed.
               One rule occupies one line, and allows one wildcard character (*) at most.
        :param Sequence[_builtins.str] allowed_headers: Specifies the allowed header of cross-origin requests.
               Only CORS requests matching the allowed header are valid.
        :param Sequence[_builtins.str] expose_headers: Specifies the exposed header in CORS responses, providing additional information for clients.
        :param _builtins.int max_age_seconds: Specifies the duration that your browser can cache CORS responses, expressed in seconds.
               The default value is 100.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        Specifies the acceptable operation type of buckets and objects.
        The methods include `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        Requests from this origin can access the bucket. Multiple matching rules are allowed.
        One rule occupies one line, and allows one wildcard character (*) at most.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the allowed header of cross-origin requests.
        Only CORS requests matching the allowed header are valid.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the exposed header in CORS responses, providing additional information for clients.
        """
        return pulumi.get(self, "expose_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies the duration that your browser can cache CORS responses, expressed in seconds.
        The default value is 100.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class BucketLifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUploads":
            suggest = "abort_incomplete_multipart_uploads"
        elif key == "noncurrentVersionExpirations":
            suggest = "noncurrent_version_expirations"
        elif key == "noncurrentVersionTransitions":
            suggest = "noncurrent_version_transitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 name: _builtins.str,
                 abort_incomplete_multipart_uploads: Optional[Sequence['outputs.BucketLifecycleRuleAbortIncompleteMultipartUpload']] = None,
                 expirations: Optional[Sequence['outputs.BucketLifecycleRuleExpiration']] = None,
                 noncurrent_version_expirations: Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionExpiration']] = None,
                 noncurrent_version_transitions: Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionTransition']] = None,
                 prefix: Optional[_builtins.str] = None,
                 transitions: Optional[Sequence['outputs.BucketLifecycleRuleTransition']] = None):
        """
        :param _builtins.bool enabled: Specifies lifecycle rule status.
        :param _builtins.str name: Unique identifier for lifecycle rules. The Rule Name contains a maximum of 255 characters.
        :param Sequence['BucketLifecycleRuleExpirationArgs'] expirations: Specifies a period when objects that have been last updated are automatically deleted. (documented below).
        :param Sequence['BucketLifecycleRuleNoncurrentVersionExpirationArgs'] noncurrent_version_expirations: Specifies a period when noncurrent object versions are automatically deleted. (documented below).
        :param Sequence['BucketLifecycleRuleNoncurrentVersionTransitionArgs'] noncurrent_version_transitions: Specifies a period when noncurrent object versions are automatically transitioned to `WARM` or `COLD` storage class (documented below).
               
               At least one of `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
        :param _builtins.str prefix: Object key prefix identifying one or more objects to which the rule applies.
               If omitted, all objects in the bucket will be managed by the lifecycle rule.
               The prefix cannot start or end with a slash (/), cannot have consecutive slashes (/), and cannot contain the following special characters: \\:*?"<>|.
        :param Sequence['BucketLifecycleRuleTransitionArgs'] transitions: Specifies a period when objects that have been last updated are automatically transitioned to `WARM` or `COLD` storage class (documented below).
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)
        if abort_incomplete_multipart_uploads is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_uploads", abort_incomplete_multipart_uploads)
        if expirations is not None:
            pulumi.set(__self__, "expirations", expirations)
        if noncurrent_version_expirations is not None:
            pulumi.set(__self__, "noncurrent_version_expirations", noncurrent_version_expirations)
        if noncurrent_version_transitions is not None:
            pulumi.set(__self__, "noncurrent_version_transitions", noncurrent_version_transitions)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Specifies lifecycle rule status.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Unique identifier for lifecycle rules. The Rule Name contains a maximum of 255 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="abortIncompleteMultipartUploads")
    def abort_incomplete_multipart_uploads(self) -> Optional[Sequence['outputs.BucketLifecycleRuleAbortIncompleteMultipartUpload']]:
        return pulumi.get(self, "abort_incomplete_multipart_uploads")

    @_builtins.property
    @pulumi.getter
    def expirations(self) -> Optional[Sequence['outputs.BucketLifecycleRuleExpiration']]:
        """
        Specifies a period when objects that have been last updated are automatically deleted. (documented below).
        """
        return pulumi.get(self, "expirations")

    @_builtins.property
    @pulumi.getter(name="noncurrentVersionExpirations")
    def noncurrent_version_expirations(self) -> Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionExpiration']]:
        """
        Specifies a period when noncurrent object versions are automatically deleted. (documented below).
        """
        return pulumi.get(self, "noncurrent_version_expirations")

    @_builtins.property
    @pulumi.getter(name="noncurrentVersionTransitions")
    def noncurrent_version_transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionTransition']]:
        """
        Specifies a period when noncurrent object versions are automatically transitioned to `WARM` or `COLD` storage class (documented below).

        At least one of `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
        """
        return pulumi.get(self, "noncurrent_version_transitions")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        If omitted, all objects in the bucket will be managed by the lifecycle rule.
        The prefix cannot start or end with a slash (/), cannot have consecutive slashes (/), and cannot contain the following special characters: \\:*?"<>|.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleTransition']]:
        """
        Specifies a period when objects that have been last updated are automatically transitioned to `WARM` or `COLD` storage class (documented below).
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class BucketLifecycleRuleAbortIncompleteMultipartUpload(dict):
    def __init__(__self__, *,
                 days: _builtins.int):
        pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleExpiration(dict):
    def __init__(__self__, *,
                 days: _builtins.int):
        """
        :param _builtins.int days: Specifies the number of days when objects that have been last updated are automatically deleted.
               The expiration time must be greater than the transition times.
        """
        pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days when objects that have been last updated are automatically deleted.
        The expiration time must be greater than the transition times.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleNoncurrentVersionExpiration(dict):
    def __init__(__self__, *,
                 days: _builtins.int):
        """
        :param _builtins.int days: Specifies the number of days when noncurrent object versions are automatically deleted.
        """
        pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days when noncurrent object versions are automatically deleted.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleNoncurrentVersionTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleNoncurrentVersionTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: _builtins.int,
                 storage_class: _builtins.str):
        """
        :param _builtins.int days: Specifies the number of days when noncurrent object versions are automatically transitioned to the specified storage class.
        :param _builtins.str storage_class: The class of storage used to store the object. Only `WARM` and `COLD` are supported.
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days when noncurrent object versions are automatically transitioned to the specified storage class.
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        The class of storage used to store the object. Only `WARM` and `COLD` are supported.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class BucketLifecycleRuleTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: _builtins.int,
                 storage_class: _builtins.str):
        """
        :param _builtins.int days: Specifies the number of days when objects that have been last updated are automatically transitioned to the specified storage class.
        :param _builtins.str storage_class: The class of storage used to store the object. Only `WARM` and `COLD` are supported.
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days when objects that have been last updated are automatically transitioned to the specified storage class.
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        The class of storage used to store the object. Only `WARM` and `COLD` are supported.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class BucketLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetBucket":
            suggest = "target_bucket"
        elif key == "targetPrefix":
            suggest = "target_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_bucket: _builtins.str,
                 agency: Optional[_builtins.str] = None,
                 target_prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str target_bucket: The name of the bucket that will receive the log objects.
               The acl policy of the target bucket should be `log-delivery-write`.
        :param _builtins.str agency: schema: Required
        :param _builtins.str target_prefix: To specify a key prefix for log objects.
        """
        pulumi.set(__self__, "target_bucket", target_bucket)
        if agency is not None:
            pulumi.set(__self__, "agency", agency)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> _builtins.str:
        """
        The name of the bucket that will receive the log objects.
        The acl policy of the target bucket should be `log-delivery-write`.
        """
        return pulumi.get(self, "target_bucket")

    @_builtins.property
    @pulumi.getter
    def agency(self) -> Optional[_builtins.str]:
        """
        schema: Required
        """
        return pulumi.get(self, "agency")

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[_builtins.str]:
        """
        To specify a key prefix for log objects.
        """
        return pulumi.get(self, "target_prefix")


@pulumi.output_type
class BucketStorageInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectNumber":
            suggest = "object_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketStorageInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketStorageInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketStorageInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_number: Optional[_builtins.int] = None,
                 size: Optional[_builtins.int] = None):
        """
        :param _builtins.int object_number: The number of objects stored in the bucket.
        :param _builtins.int size: The stored size of the bucket.
        """
        if object_number is not None:
            pulumi.set(__self__, "object_number", object_number)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="objectNumber")
    def object_number(self) -> Optional[_builtins.int]:
        """
        The number of objects stored in the bucket.
        """
        return pulumi.get(self, "object_number")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The stored size of the bucket.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class BucketWebsite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDocument":
            suggest = "error_document"
        elif key == "indexDocument":
            suggest = "index_document"
        elif key == "redirectAllRequestsTo":
            suggest = "redirect_all_requests_to"
        elif key == "routingRules":
            suggest = "routing_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_document: Optional[_builtins.str] = None,
                 index_document: Optional[_builtins.str] = None,
                 redirect_all_requests_to: Optional[_builtins.str] = None,
                 routing_rules: Optional[_builtins.str] = None):
        """
        :param _builtins.str error_document: Specifies the error page returned when an error occurs during static website access.
               Only HTML, JPG, PNG, BMP, and WEBP files under the root directory are supported.
        :param _builtins.str index_document: Unless using `redirect_all_requests_to`. Specifies the default homepage of the static website, only HTML web pages are supported.
               OBS only allows files such as `index.html` in the root directory of a bucket to function as the default homepage.
               That is to say, do not set the default homepage with a multi-level directory structure (for example, /page/index.html).
        :param _builtins.str redirect_all_requests_to: A hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
        :param _builtins.str routing_rules: A JSON or XML format containing routing rules describing redirect behavior and when redirects are applied.
               Each rule contains a `Condition` and a `Redirect` as shown in the following table:
               
               Parameter | Key
               --- | ---
               Condition | KeyPrefixEquals, HttpErrorCodeReturnedEquals
               Redirect | Protocol, HostName, ReplaceKeyPrefixWith, ReplaceKeyWith, HttpRedirectCode
        """
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if redirect_all_requests_to is not None:
            pulumi.set(__self__, "redirect_all_requests_to", redirect_all_requests_to)
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)

    @_builtins.property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[_builtins.str]:
        """
        Specifies the error page returned when an error occurs during static website access.
        Only HTML, JPG, PNG, BMP, and WEBP files under the root directory are supported.
        """
        return pulumi.get(self, "error_document")

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[_builtins.str]:
        """
        Unless using `redirect_all_requests_to`. Specifies the default homepage of the static website, only HTML web pages are supported.
        OBS only allows files such as `index.html` in the root directory of a bucket to function as the default homepage.
        That is to say, do not set the default homepage with a multi-level directory structure (for example, /page/index.html).
        """
        return pulumi.get(self, "index_document")

    @_builtins.property
    @pulumi.getter(name="redirectAllRequestsTo")
    def redirect_all_requests_to(self) -> Optional[_builtins.str]:
        """
        A hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
        """
        return pulumi.get(self, "redirect_all_requests_to")

    @_builtins.property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[_builtins.str]:
        """
        A JSON or XML format containing routing rules describing redirect behavior and when redirects are applied.
        Each rule contains a `Condition` and a `Redirect` as shown in the following table:

        Parameter | Key
        --- | ---
        Condition | KeyPrefixEquals, HttpErrorCodeReturnedEquals
        Redirect | Protocol, HostName, ReplaceKeyPrefixWith, ReplaceKeyWith, HttpRedirectCode
        """
        return pulumi.get(self, "routing_rules")


@pulumi.output_type
class GetBucketsBucketResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 created_at: _builtins.str,
                 enterprise_project_id: _builtins.str,
                 region: _builtins.str,
                 storage_class: _builtins.str):
        """
        :param _builtins.str bucket: The name of the OBS bucket.
        :param _builtins.str created_at: The date when the OBS bucket was created.
        :param _builtins.str enterprise_project_id: The enterprise project id of the OBS bucket.
        :param _builtins.str region: The region in which to obtain the OBS bucket.
               If omitted, the provider-level region will be used.
        :param _builtins.str storage_class: The storage class of the OBS bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the OBS bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date when the OBS bucket was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        """
        The enterprise project id of the OBS bucket.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region in which to obtain the OBS bucket.
        If omitted, the provider-level region will be used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        The storage class of the OBS bucket.
        """
        return pulumi.get(self, "storage_class")


